import { AwsAsset } from "../../generated/assets";
import { AwsCategoryId } from "../categories/definitions";
/** Parsed asset key */
export interface ParsedAssetKey {
    /** Reference to the full key that was parsed */
    readonly assetKey: string;
    /** Category id */
    readonly category: AwsCategoryId;
    /** Service id if key is partitioned by resource */
    readonly service?: AwsAsset.Service;
    /** Resource id if key is for a resource */
    readonly resource?: AwsAsset.Resource;
    /** The last segment of the key (which is the nested icon). For instances and things this includes the dir prefix. */
    readonly basename: string;
    /** The instance type if key is for an ec2 instance */
    readonly instanceType?: AwsAsset.InstanceType;
    /** The iot thing if key is for an iot thing */
    readonly iotThing?: AwsAsset.IotThing;
}
/** Parse asset key into parts */
export declare function parseAssetPath(assetPath: string): ParsedAssetKey;
