"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightTheme = exports.LightPalette = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const palette_1 = require("./palette");
/** Light theme color palette */
var LightPalette;
(function (LightPalette) {
    LightPalette["PUBLIC"] = "#E9F3E6";
    LightPalette["PRIVATE"] = "#E6F2F8";
    LightPalette["GENERIC"] = "#5A6B861A";
    LightPalette["PRIMARY"] = "#232F3E";
    LightPalette["SECONDARY"] = "#5B9BD5";
    LightPalette["TERTIARY"] = "#5A6B86";
})(LightPalette || (exports.LightPalette = LightPalette = {}));
/** Light theme definition */
exports.LightTheme = {
    id: "light",
    backgrounds: {
        base: palette_1.BasePalette.WHITE,
        private: LightPalette.PRIVATE,
        public: LightPalette.PUBLIC,
        generic: LightPalette.GENERIC,
    },
    text: {
        default: palette_1.BasePalette.BLACK,
        primary: LightPalette.PRIMARY,
        secondary: LightPalette.SECONDARY,
        tertiary: LightPalette.TERTIARY,
    },
    groups: {
        cloud: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#DF3312",
            bgcolor: false,
            borderColor: "#DF3312",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#CD2264",
            bgcolor: false,
            borderColor: "#CD2264",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#5A6B86",
            bgcolor: false,
            borderColor: "#5A6B86",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#000000CC", // 80%
            bgcolor: "#5A6B861A", // 10%
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: LightPalette.GENERIC,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: LightPalette.SECONDARY,
            tail: "normal",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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