"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_DIAGRAM = exports.CONFIG_DEFAULTS = exports.DEFAULT_DIAGRAM_NAME = exports.DEFAULT_DIAGRAM_TITLE = exports.DiagramFormat = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_graph_1 = require("../cdk-graph");
/**
 * Supported diagram formats that can be generated.
 *
 * Extended formats are automatically generated, for example if you generate "png" which extends
 * "svg" which extends "dot", the resulting generated files will be all aforementioned.
 */
var DiagramFormat;
(function (DiagramFormat) {
    /**
     * Graphviz [DOT Language](https://graphviz.org/doc/info/lang.html)
     *
     * @default
     */
    DiagramFormat["DOT"] = "dot";
    /**
     * [SVG](https://developer.mozilla.org/en-US/docs/Web/SVG) generated
     * using [dot-wasm](https://hpcc-systems.github.io/hpcc-js-wasm/classes/graphviz.Graphviz.html)
     * from {@link DiagramFormat.DOT} file.
     *
     * @extends {DiagramFormat.DOT}
     */
    DiagramFormat["SVG"] = "svg";
    /**
     * [PNG](https://en.wikipedia.org/wiki/Portable_Network_Graphics) generated
     * using [sharp](https://sharp.pixelplumbing.com/api-output#png) from {@link DiagramFormat.SVG} file
     *
     * @extends {DiagramFormat.SVG}
     */
    DiagramFormat["PNG"] = "png";
    // TODO: add drawio support
})(DiagramFormat || (exports.DiagramFormat = DiagramFormat = {}));
/** Default diagram title */
exports.DEFAULT_DIAGRAM_TITLE = "Cloud Diagram";
/** Default diagram name */
exports.DEFAULT_DIAGRAM_NAME = "diagram";
/** Default configuration settings */
exports.CONFIG_DEFAULTS = {
    format: [DiagramFormat.PNG],
    filterPlan: {
        preset: cdk_graph_1.FilterPreset.COMPACT,
    },
};
/** Default diagram config */
exports.DEFAULT_DIAGRAM = {
    name: exports.DEFAULT_DIAGRAM_NAME,
    title: exports.DEFAULT_DIAGRAM_TITLE,
};
//# sourceMappingURL=data:application/json;base64,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