"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FONT_CSS_CLASSES = exports.GraphFonts = exports.FONT_STYLESHEET = exports.FONT_FAMILY = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Graph font family
 * @internal
 */
exports.FONT_FAMILY = "Roboto Condensed";
var FontWeights;
(function (FontWeights) {
    FontWeights[FontWeights["LIGHT"] = 300] = "LIGHT";
    FontWeights[FontWeights["REGULAR"] = 400] = "REGULAR";
    FontWeights[FontWeights["BOLD"] = 700] = "BOLD";
})(FontWeights || (FontWeights = {}));
var FontStyles;
(function (FontStyles) {
    FontStyles["NORMAL"] = "normal";
    FontStyles["ITALIC"] = "italic";
})(FontStyles || (FontStyles = {}));
/**
 * Graph font stylesheet
 * @internal
 */
exports.FONT_STYLESHEET = "https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@300;400;700&display=swap";
function fontClassName(weight, style) {
    if (style === "NORMAL") {
        return `font_${weight.toLowerCase()}`;
    }
    return `font_${weight.toLowerCase()}_${style.toLowerCase()}`;
}
function defineGraphFont(weight, style) {
    return {
        fontname: exports.FONT_FAMILY,
        class: fontClassName(weight, style),
    };
}
/**
 * Graph fonts
 * @internal
 */
exports.GraphFonts = {
    LIGHT: defineGraphFont("LIGHT", "NORMAL"),
    LIGHT_ITALIC: defineGraphFont("LIGHT", "ITALIC"),
    REGULAR: defineGraphFont("REGULAR", "NORMAL"),
    REGULAR_ITALIC: defineGraphFont("REGULAR", "ITALIC"),
    BOLD: defineGraphFont("BOLD", "NORMAL"),
    BOLD_ITALIC: defineGraphFont("BOLD", "ITALIC"),
};
/**
 * Graph font css style classes
 * @internal
 */
exports.FONT_CSS_CLASSES = Object.keys(exports.GraphFonts).reduce((_css, _fontKey) => {
    const [_weightKey, _styleKey = "NORMAL"] = _fontKey.split("_");
    const _className = fontClassName(_weightKey, _styleKey);
    const _weight = FontWeights[_weightKey];
    const _style = FontStyles[_styleKey];
    return (_css +
        `\n.${_className} { font-family: "${exports.FONT_FAMILY}", sans-serif; font-style: ${_style}; font-weight: ${_weight}; }`);
}, "");
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm9udHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmb250cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEM7OztHQUdHO0FBQ1UsUUFBQSxXQUFXLEdBQUcsa0JBQWtCLENBQUM7QUFFOUMsSUFBSyxXQUlKO0FBSkQsV0FBSyxXQUFXO0lBQ2QsaURBQVcsQ0FBQTtJQUNYLHFEQUFhLENBQUE7SUFDYiwrQ0FBVSxDQUFBO0FBQ1osQ0FBQyxFQUpJLFdBQVcsS0FBWCxXQUFXLFFBSWY7QUFFRCxJQUFLLFVBR0o7QUFIRCxXQUFLLFVBQVU7SUFDYiwrQkFBaUIsQ0FBQTtJQUNqQiwrQkFBaUIsQ0FBQTtBQUNuQixDQUFDLEVBSEksVUFBVSxLQUFWLFVBQVUsUUFHZDtBQUVEOzs7R0FHRztBQUNVLFFBQUEsZUFBZSxHQUMxQix5RkFBeUYsQ0FBQztBQUU1RixTQUFTLGFBQWEsQ0FDcEIsTUFBZ0MsRUFDaEMsS0FBOEI7SUFFOUIsSUFBSSxLQUFLLEtBQUssUUFBUSxFQUFFLENBQUM7UUFDdkIsT0FBTyxRQUFRLE1BQU0sQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUFDO0lBQ3hDLENBQUM7SUFFRCxPQUFPLFFBQVEsTUFBTSxDQUFDLFdBQVcsRUFBRSxJQUFJLEtBQUssQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUFDO0FBQy9ELENBQUM7QUFFRCxTQUFTLGVBQWUsQ0FDdEIsTUFBZ0MsRUFDaEMsS0FBOEI7SUFFOUIsT0FBTztRQUNMLFFBQVEsRUFBRSxtQkFBVztRQUNyQixLQUFLLEVBQUUsYUFBYSxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUM7S0FDcEMsQ0FBQztBQUNKLENBQUM7QUFFRDs7O0dBR0c7QUFDVSxRQUFBLFVBQVUsR0FBRztJQUN4QixLQUFLLEVBQUUsZUFBZSxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUM7SUFDekMsWUFBWSxFQUFFLGVBQWUsQ0FBQyxPQUFPLEVBQUUsUUFBUSxDQUFDO0lBQ2hELE9BQU8sRUFBRSxlQUFlLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQztJQUM3QyxjQUFjLEVBQUUsZUFBZSxDQUFDLFNBQVMsRUFBRSxRQUFRLENBQUM7SUFDcEQsSUFBSSxFQUFFLGVBQWUsQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFDO0lBQ3ZDLFdBQVcsRUFBRSxlQUFlLENBQUMsTUFBTSxFQUFFLFFBQVEsQ0FBQztDQUN0QyxDQUFDO0FBRVg7OztHQUdHO0FBQ1UsUUFBQSxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLGtCQUFVLENBQUMsQ0FBQyxNQUFNLENBQzVELENBQUMsSUFBSSxFQUFFLFFBQVEsRUFBVSxFQUFFO0lBQ3pCLE1BQU0sQ0FBQyxVQUFVLEVBQUUsU0FBUyxHQUFHLFFBQVEsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUc1RCxDQUFDO0lBQ0YsTUFBTSxVQUFVLEdBQUcsYUFBYSxDQUFDLFVBQVUsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUN4RCxNQUFNLE9BQU8sR0FBRyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDeEMsTUFBTSxNQUFNLEdBQUcsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBRXJDLE9BQU8sQ0FDTCxJQUFJO1FBQ0osTUFBTSxVQUFVLG9CQUFvQixtQkFBVyw4QkFBOEIsTUFBTSxrQkFBa0IsT0FBTyxLQUFLLENBQ2xILENBQUM7QUFDSixDQUFDLEVBQ0QsRUFBRSxDQUNILENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbi8qKlxuICogR3JhcGggZm9udCBmYW1pbHlcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY29uc3QgRk9OVF9GQU1JTFkgPSBcIlJvYm90byBDb25kZW5zZWRcIjtcblxuZW51bSBGb250V2VpZ2h0cyB7XG4gIExJR0hUID0gMzAwLFxuICBSRUdVTEFSID0gNDAwLFxuICBCT0xEID0gNzAwLFxufVxuXG5lbnVtIEZvbnRTdHlsZXMge1xuICBOT1JNQUwgPSBcIm5vcm1hbFwiLFxuICBJVEFMSUMgPSBcIml0YWxpY1wiLFxufVxuXG4vKipcbiAqIEdyYXBoIGZvbnQgc3R5bGVzaGVldFxuICogQGludGVybmFsXG4gKi9cbmV4cG9ydCBjb25zdCBGT05UX1NUWUxFU0hFRVQgPVxuICBcImh0dHBzOi8vZm9udHMuZ29vZ2xlYXBpcy5jb20vY3NzMj9mYW1pbHk9Um9ib3RvK0NvbmRlbnNlZDp3Z2h0QDMwMDs0MDA7NzAwJmRpc3BsYXk9c3dhcFwiO1xuXG5mdW5jdGlvbiBmb250Q2xhc3NOYW1lKFxuICB3ZWlnaHQ6IGtleW9mIHR5cGVvZiBGb250V2VpZ2h0cyxcbiAgc3R5bGU6IGtleW9mIHR5cGVvZiBGb250U3R5bGVzXG4pOiBzdHJpbmcge1xuICBpZiAoc3R5bGUgPT09IFwiTk9STUFMXCIpIHtcbiAgICByZXR1cm4gYGZvbnRfJHt3ZWlnaHQudG9Mb3dlckNhc2UoKX1gO1xuICB9XG5cbiAgcmV0dXJuIGBmb250XyR7d2VpZ2h0LnRvTG93ZXJDYXNlKCl9XyR7c3R5bGUudG9Mb3dlckNhc2UoKX1gO1xufVxuXG5mdW5jdGlvbiBkZWZpbmVHcmFwaEZvbnQoXG4gIHdlaWdodDoga2V5b2YgdHlwZW9mIEZvbnRXZWlnaHRzLFxuICBzdHlsZToga2V5b2YgdHlwZW9mIEZvbnRTdHlsZXNcbik6IHsgZm9udG5hbWU6IHN0cmluZzsgY2xhc3M6IHN0cmluZyB9IHtcbiAgcmV0dXJuIHtcbiAgICBmb250bmFtZTogRk9OVF9GQU1JTFksXG4gICAgY2xhc3M6IGZvbnRDbGFzc05hbWUod2VpZ2h0LCBzdHlsZSksXG4gIH07XG59XG5cbi8qKlxuICogR3JhcGggZm9udHNcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY29uc3QgR3JhcGhGb250cyA9IHtcbiAgTElHSFQ6IGRlZmluZUdyYXBoRm9udChcIkxJR0hUXCIsIFwiTk9STUFMXCIpLFxuICBMSUdIVF9JVEFMSUM6IGRlZmluZUdyYXBoRm9udChcIkxJR0hUXCIsIFwiSVRBTElDXCIpLFxuICBSRUdVTEFSOiBkZWZpbmVHcmFwaEZvbnQoXCJSRUdVTEFSXCIsIFwiTk9STUFMXCIpLFxuICBSRUdVTEFSX0lUQUxJQzogZGVmaW5lR3JhcGhGb250KFwiUkVHVUxBUlwiLCBcIklUQUxJQ1wiKSxcbiAgQk9MRDogZGVmaW5lR3JhcGhGb250KFwiQk9MRFwiLCBcIk5PUk1BTFwiKSxcbiAgQk9MRF9JVEFMSUM6IGRlZmluZUdyYXBoRm9udChcIkJPTERcIiwgXCJJVEFMSUNcIiksXG59IGFzIGNvbnN0O1xuXG4vKipcbiAqIEdyYXBoIGZvbnQgY3NzIHN0eWxlIGNsYXNzZXNcbiAqIEBpbnRlcm5hbFxuICovXG5leHBvcnQgY29uc3QgRk9OVF9DU1NfQ0xBU1NFUyA9IE9iamVjdC5rZXlzKEdyYXBoRm9udHMpLnJlZHVjZShcbiAgKF9jc3MsIF9mb250S2V5KTogc3RyaW5nID0+IHtcbiAgICBjb25zdCBbX3dlaWdodEtleSwgX3N0eWxlS2V5ID0gXCJOT1JNQUxcIl0gPSBfZm9udEtleS5zcGxpdChcIl9cIikgYXMgW1xuICAgICAga2V5b2YgdHlwZW9mIEZvbnRXZWlnaHRzLFxuICAgICAga2V5b2YgdHlwZW9mIEZvbnRTdHlsZXMgfCB1bmRlZmluZWRcbiAgICBdO1xuICAgIGNvbnN0IF9jbGFzc05hbWUgPSBmb250Q2xhc3NOYW1lKF93ZWlnaHRLZXksIF9zdHlsZUtleSk7XG4gICAgY29uc3QgX3dlaWdodCA9IEZvbnRXZWlnaHRzW193ZWlnaHRLZXldO1xuICAgIGNvbnN0IF9zdHlsZSA9IEZvbnRTdHlsZXNbX3N0eWxlS2V5XTtcblxuICAgIHJldHVybiAoXG4gICAgICBfY3NzICtcbiAgICAgIGBcXG4uJHtfY2xhc3NOYW1lfSB7IGZvbnQtZmFtaWx5OiBcIiR7Rk9OVF9GQU1JTFl9XCIsIHNhbnMtc2VyaWY7IGZvbnQtc3R5bGU6ICR7X3N0eWxlfTsgZm9udC13ZWlnaHQ6ICR7X3dlaWdodH07IH1gXG4gICAgKTtcbiAgfSxcbiAgXCJcIlxuKTtcbiJdfQ==