"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphThemeRenderingIconTarget = void 0;
/** Icon rendering target options for GraphTheme */
var GraphThemeRenderingIconTarget;
(function (GraphThemeRenderingIconTarget) {
    /**
     * Data icon (eg: EC2 instance type icon, T2).
     *
     * Resolution precedence: `data => resource => general => service => category`
     * @default
     */
    GraphThemeRenderingIconTarget[GraphThemeRenderingIconTarget["DATA"] = 0] = "DATA";
    /**
     * Resource icon.
     *
     * Resolution precedence: `resource => general => service => category`
     */
    GraphThemeRenderingIconTarget[GraphThemeRenderingIconTarget["RESOURCE"] = 1] = "RESOURCE";
    /**
     * General icon.
     *
     * Resolution precedence: `resource => general => service => category`
     */
    GraphThemeRenderingIconTarget[GraphThemeRenderingIconTarget["GENERAL"] = 2] = "GENERAL";
    /**
     * Service icon.
     *
     * Resolution precedence: `service => category`
     */
    GraphThemeRenderingIconTarget[GraphThemeRenderingIconTarget["SERVICE"] = 3] = "SERVICE";
    /**
     * Category icon.
     *
     * Resolution precedence: `category`
     */
    GraphThemeRenderingIconTarget[GraphThemeRenderingIconTarget["CATEGORY"] = 4] = "CATEGORY";
})(GraphThemeRenderingIconTarget || (exports.GraphThemeRenderingIconTarget = GraphThemeRenderingIconTarget = {}));
//# sourceMappingURL=data:application/json;base64,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