"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.processProjectGraph = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
// eslint-disable-next-line import/no-extraneous-dependencies
const devkit_1 = require("@nx/devkit");
function processProjectGraph(graph) {
    const builder = new devkit_1.ProjectGraphBuilder(graph);
    const rootNode = Object.keys(graph.nodes).reduce((_, k) => graph.nodes[k].data.root === "" ? graph.nodes[k].name : undefined, undefined);
    rootNode && builder.removeNode(rootNode);
    // We will see how this is used below.
    return builder.getUpdatedProjectGraph();
}
exports.processProjectGraph = processProjectGraph;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXZuX3BsdWdpbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm12bl9wbHVnaW4udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7c0NBQ3NDO0FBQ3RDLDZEQUE2RDtBQUM3RCx1Q0FBK0Q7QUFFL0QsU0FBZ0IsbUJBQW1CLENBQUMsS0FBbUI7SUFDckQsTUFBTSxPQUFPLEdBQUcsSUFBSSw0QkFBbUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMvQyxNQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQzlDLENBQUMsQ0FBcUIsRUFBRSxDQUFTLEVBQUUsRUFBRSxDQUNuQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxFQUNuRSxTQUFTLENBQ1YsQ0FBQztJQUVGLFFBQVEsSUFBSSxPQUFPLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBRXpDLHNDQUFzQztJQUN0QyxPQUFPLE9BQU8sQ0FBQyxzQkFBc0IsRUFBRSxDQUFDO0FBQzFDLENBQUM7QUFaRCxrREFZQyIsInNvdXJjZXNDb250ZW50IjpbIi8qISBDb3B5cmlnaHQgW0FtYXpvbi5jb21dKGh0dHA6Ly9hbWF6b24uY29tLyksIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMCAqL1xuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llc1xuaW1wb3J0IHsgUHJvamVjdEdyYXBoQnVpbGRlciwgUHJvamVjdEdyYXBoIH0gZnJvbSBcIkBueC9kZXZraXRcIjtcblxuZXhwb3J0IGZ1bmN0aW9uIHByb2Nlc3NQcm9qZWN0R3JhcGgoZ3JhcGg6IFByb2plY3RHcmFwaCk6IFByb2plY3RHcmFwaCB7XG4gIGNvbnN0IGJ1aWxkZXIgPSBuZXcgUHJvamVjdEdyYXBoQnVpbGRlcihncmFwaCk7XG4gIGNvbnN0IHJvb3ROb2RlID0gT2JqZWN0LmtleXMoZ3JhcGgubm9kZXMpLnJlZHVjZShcbiAgICAoXzogc3RyaW5nIHwgdW5kZWZpbmVkLCBrOiBzdHJpbmcpID0+XG4gICAgICBncmFwaC5ub2Rlc1trXS5kYXRhLnJvb3QgPT09IFwiXCIgPyBncmFwaC5ub2Rlc1trXS5uYW1lIDogdW5kZWZpbmVkLFxuICAgIHVuZGVmaW5lZFxuICApO1xuXG4gIHJvb3ROb2RlICYmIGJ1aWxkZXIucmVtb3ZlTm9kZShyb290Tm9kZSk7XG5cbiAgLy8gV2Ugd2lsbCBzZWUgaG93IHRoaXMgaXMgdXNlZCBiZWxvdy5cbiAgcmV0dXJuIGJ1aWxkZXIuZ2V0VXBkYXRlZFByb2plY3RHcmFwaCgpO1xufVxuIl19