"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryLogger = void 0;
const types_1 = require("./types");
/**
 * Records nag results in memory
 */
class MemoryLogger {
    constructor() {
        this.results = [];
    }
    onCompliance(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.COMPLIANT,
        });
    }
    onNonCompliance(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.NON_COMPLIANT,
        });
    }
    onSuppressed(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.NON_COMPLIANT_SUPPRESSED,
        });
    }
    onError(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.ERROR,
        });
    }
    onSuppressedError(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.ERROR_SUPPRESSED,
            suppressionReason: data.errorSuppressionReason,
        });
    }
    onNotApplicable(data) {
        this.results.push({
            ...data,
            compliance: types_1.NagResultCompliance.NOT_APPLICABLE,
        });
    }
}
exports.MemoryLogger = MemoryLogger;
//# sourceMappingURL=data:application/json;base64,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