"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthorizerFunctions = void 0;
const api_gateway_auth_1 = require("./api-gateway-auth");
const predicates_1 = require("../authorizers/predicates");
/**
 * Return all lambda functions used as authorizers, labelled by authorizer id
 */
const getAuthorizerFunctions = (options) => (0, api_gateway_auth_1.getAllAuthorizers)(options.integrations, options.defaultAuthorizer)
    .filter((authorizer) => (0, predicates_1.isCustomAuthorizer)(authorizer))
    .map((authorizer) => ({
    label: authorizer.authorizerId,
    function: authorizer.function,
}));
exports.getAuthorizerFunctions = getAuthorizerFunctions;
//# sourceMappingURL=data:application/json;base64,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