"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedAsyncApiMarkdownDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
class GeneratedAsyncApiMarkdownDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec(`npx --yes @asyncapi/cli@1.7.3 generate fromTemplate "${options.specPath}" @asyncapi/markdown-template@1.5.0 --param outFilename=index.md --force-write`);
        this.compileTask.spawn(this.generateTask);
        if (!options.commitGeneratedCode) {
            this.gitignore.addPatterns("index.md");
        }
    }
}
exports.GeneratedAsyncApiMarkdownDocumentationProject = GeneratedAsyncApiMarkdownDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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