"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaCdkInfrastructureBaseProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const monorepo_1 = require("../../../../../monorepo");
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const type_safe_api_command_environment_1 = require("../../components/type-safe-api-command-environment");
const utils_1 = require("../../components/utils");
class GeneratedJavaCdkInfrastructureBaseProject extends java_1.JavaProject {
    constructor(options) {
        super({
            ...options,
            sample: false,
            junit: false,
        });
        this.buildGenerateCommandArgs = () => {
            return (0, utils_1.buildCodegenCommandArgs)(this.buildCodegenOptions());
        };
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.options = options;
        this.packageName = `${this.pom.groupId}.${this.name}.infra`;
        this.srcDir = path.join("src", "main", "java", ...this.packageName.split("."));
        [
            `software.aws/pdk@${monorepo_1.ProjectUtils.getPdkVersion()}`,
            "software.constructs/constructs@10.3.0",
            "software.amazon.awscdk/aws-cdk-lib@2.133.0",
            "io.github.cdklabs/cdknag@2.28.60",
            "org.projectlombok/lombok@1.18.30",
            "com.fasterxml.jackson.core/jackson-databind@2.17.0",
            `io.github.cdklabs/projen@0.80.10`,
            `${options.generatedJavaTypes.pom.groupId}/${options.generatedJavaTypes.pom.artifactId}@${options.generatedJavaTypes.pom.version}`,
        ]
            .filter((dep) => !this.deps.tryGetDependency(dep.split("@")[0], projen_1.DependencyType.RUNTIME))
            .forEach((dep) => this.addDependency(dep));
        // Pin constructs version
        this.deps.removeDependency("software.constructs/constructs", projen_1.DependencyType.BUILD);
        this.addDependency("software.constructs/constructs@10.3.0");
        // Remove the projen test dependency since otherwise it takes precedence, causing projen to be unavailable at synth time
        this.deps.removeDependency("io.github.cdklabs/projen", projen_1.DependencyType.TEST);
        // Add a dependency on the generated java types repository
        this.pom.addRepository({
            url: `file://${path.relative(this.outdir, options.generatedJavaTypes.outdir)}/dist/java`,
            id: `${options.generatedJavaTypes.pom.groupId}-${options.generatedJavaTypes.pom.artifactId}-repo`,
        });
        const generateTask = this.addTask("generate");
        this.generateTask = generateTask;
        generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_NEXT, this.buildGenerateCommandArgs()));
        // Copy the parsed spec into the resources directory so that it's included in the jar
        generateTask.exec("mkdir -p src/main/resources");
        generateTask.exec(`cp -f ${this.options.specPath} src/main/resources/.api.json`);
        // Absolute path of this project is required for determining the path to the handlers jar,
        // since java executes from the jar which could be anywhere in the filesystem (eg the .m2 directory).
        // While ugly, since this is written at build time and not checked in it remains portable.
        generateTask.exec("echo $(pwd) > src/main/resources/project-absolute-path.txt");
        this.gitignore.addPatterns(".tsapi-manifest", ".openapi-generator");
        this.preCompileTask.spawn(generateTask);
    }
}
exports.GeneratedJavaCdkInfrastructureBaseProject = GeneratedJavaCdkInfrastructureBaseProject;
//# sourceMappingURL=data:application/json;base64,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