import { JavaProject } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedJavaRuntimeOptions } from "../../types";
import { CodegenOptions } from "../components/utils";
/**
 * Configuration for the generated java runtime project
 */
export interface GeneratedJavaRuntimeBaseProjectOptions extends GeneratedJavaRuntimeOptions, CodeGenerationSourceOptions {
}
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
export declare abstract class GeneratedJavaRuntimeBaseProject extends JavaProject {
    /**
     * The package name, for use in imports
     */
    readonly packageName: string;
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedJavaRuntimeBaseProjectOptions;
    constructor(options: GeneratedJavaRuntimeBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildCodegenOptions(): CodegenOptions;
}
