"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketDocumentationFormat = exports.DocumentationFormat = exports.WebSocketLibrary = exports.Library = exports.PythonVersion = exports.JavaVersion = exports.NodeVersion = exports.Language = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for runtimes and infrastructure
 */
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["JAVA"] = "java";
})(Language || (exports.Language = Language = {}));
/**
 * Versions of node
 */
var NodeVersion;
(function (NodeVersion) {
    NodeVersion["NODE_18"] = "NODE_18";
    NodeVersion["NODE_20"] = "NODE_20";
})(NodeVersion || (exports.NodeVersion = NodeVersion = {}));
/**
 * Versions of java
 */
var JavaVersion;
(function (JavaVersion) {
    JavaVersion["JAVA_8"] = "JAVA_8";
    JavaVersion["JAVA_11"] = "JAVA_11";
    JavaVersion["JAVA_17"] = "JAVA_17";
    JavaVersion["JAVA_21"] = "JAVA_21";
})(JavaVersion || (exports.JavaVersion = JavaVersion = {}));
/**
 * Versions of python
 */
var PythonVersion;
(function (PythonVersion) {
    PythonVersion["PYTHON_3_11"] = "PYTHON_3_11";
    PythonVersion["PYTHON_3_12"] = "PYTHON_3_12";
})(PythonVersion || (exports.PythonVersion = PythonVersion = {}));
/**
 * Supported libraries for code generation
 */
var Library;
(function (Library) {
    Library["TYPESCRIPT_REACT_QUERY_HOOKS"] = "typescript-react-query-hooks";
})(Library || (exports.Library = Library = {}));
var WebSocketLibrary;
(function (WebSocketLibrary) {
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_CLIENT"] = "typescript-websocket-client";
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_HOOKS"] = "typescript-websocket-hooks";
})(WebSocketLibrary || (exports.WebSocketLibrary = WebSocketLibrary = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * OpenAPI Generator 'html2' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md
     * @deprecated Will be removed in 0.24.0. Please use HTML_REDOC instead for HTML documentation.
     */
    DocumentationFormat["HTML2"] = "html2";
    /**
     * OpenAPI Generator 'markdown' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * OpenAPI Generator 'plantuml' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat || (exports.DocumentationFormat = DocumentationFormat = {}));
/**
 * Formats for WebSocket documentation generation
 */
var WebSocketDocumentationFormat;
(function (WebSocketDocumentationFormat) {
    /**
     * HTML Documentation generated by AsyncAPI's HTML Template
     * @see https://github.com/asyncapi/html-template
     */
    WebSocketDocumentationFormat["HTML"] = "html_asyncapi";
    /**
     * Markdown Documentation generated by AsyncAPI's Markdown Template
     * @see https://github.com/asyncapi/markdown-template
     */
    WebSocketDocumentationFormat["MARKDOWN"] = "markdown_asyncapi";
})(WebSocketDocumentationFormat || (exports.WebSocketDocumentationFormat = WebSocketDocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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