"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithySettingsGradleFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Synthesize a settings.gradle file for Smithy projects
 */
class SmithySettingsGradleFile extends projen_1.FileBase {
    constructor(project, options) {
        super(project, "settings.gradle", {
            marker: true,
            readonly: true,
        });
        this.options = options;
    }
    synthesizeContent(_) {
        return `// ${this.marker}
rootProject.name = '${this.options.gradleProjectName}'
`;
    }
}
exports.SmithySettingsGradleFile = SmithySettingsGradleFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21pdGh5LXNldHRpbmdzLWdyYWRsZS1maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21pdGh5LXNldHRpbmdzLWdyYWRsZS1maWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBO3NDQUNzQztBQUN0QyxtQ0FBc0Q7QUFZdEQ7O0dBRUc7QUFDSCxNQUFhLHdCQUF5QixTQUFRLGlCQUFRO0lBR3BELFlBQVksT0FBZ0IsRUFBRSxPQUF3QztRQUNwRSxLQUFLLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFO1lBQ2hDLE1BQU0sRUFBRSxJQUFJO1lBQ1osUUFBUSxFQUFFLElBQUk7U0FDZixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztJQUN6QixDQUFDO0lBRU0saUJBQWlCLENBQUMsQ0FBWTtRQUNuQyxPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU07c0JBQ04sSUFBSSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUI7Q0FDbkQsQ0FBQztJQUNBLENBQUM7Q0FDRjtBQWhCRCw0REFnQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IFByb2plY3QsIEZpbGVCYXNlLCBJUmVzb2x2ZXIgfSBmcm9tIFwicHJvamVuXCI7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgdGhlIFNtaXRoeSBzZXR0aW5ncy5ncmFkbGUgZmlsZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNtaXRoeVNldHRpbmdzR3JhZGxlRmlsZU9wdGlvbnMge1xuICAvKipcbiAgICogTmFtZSBvZiB0aGUgZ3JhZGxlIHByb2plY3RcbiAgICovXG4gIHJlYWRvbmx5IGdyYWRsZVByb2plY3ROYW1lOiBzdHJpbmc7XG59XG5cbi8qKlxuICogU3ludGhlc2l6ZSBhIHNldHRpbmdzLmdyYWRsZSBmaWxlIGZvciBTbWl0aHkgcHJvamVjdHNcbiAqL1xuZXhwb3J0IGNsYXNzIFNtaXRoeVNldHRpbmdzR3JhZGxlRmlsZSBleHRlbmRzIEZpbGVCYXNlIHtcbiAgcmVhZG9ubHkgb3B0aW9uczogU21pdGh5U2V0dGluZ3NHcmFkbGVGaWxlT3B0aW9ucztcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBTbWl0aHlTZXR0aW5nc0dyYWRsZUZpbGVPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCwgXCJzZXR0aW5ncy5ncmFkbGVcIiwge1xuICAgICAgbWFya2VyOiB0cnVlLFxuICAgICAgcmVhZG9ubHk6IHRydWUsXG4gICAgfSk7XG4gICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgfVxuXG4gIHB1YmxpYyBzeW50aGVzaXplQ29udGVudChfOiBJUmVzb2x2ZXIpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiBgLy8gJHt0aGlzLm1hcmtlcn1cbnJvb3RQcm9qZWN0Lm5hbWUgPSAnJHt0aGlzLm9wdGlvbnMuZ3JhZGxlUHJvamVjdE5hbWV9J1xuYDtcbiAgfVxufVxuIl19