"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiModelProjectBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../codegen/components/type-safe-api-command-environment");
const utils_1 = require("../codegen/components/utils");
const types_1 = require("../types");
class TypeSafeApiModelProjectBase extends projen_1.Project {
    constructor(options) {
        super(options);
        /**
         * Name of the final bundled OpenAPI specification
         */
        this.parsedSpecFile = ".api.json";
        this.addApiDefinition = ({ modelLanguage, modelOptions, handlerLanguages, }) => {
            if (modelLanguage === types_1.ModelLanguage.SMITHY) {
                if (!modelOptions.smithy) {
                    throw new Error(`modelOptions.smithy is required when selected model language is ${types_1.ModelLanguage.SMITHY}`);
                }
                const smithyOptions = modelOptions.smithy;
                const smithy = this.addSmithyApiDefinition(smithyOptions, handlerLanguages);
                return {
                    specPath: smithy.openApiSpecificationPath,
                    smithyJsonModelPath: smithy.smithyJsonModelPath,
                };
            }
            else if (modelLanguage === types_1.ModelLanguage.OPENAPI) {
                if (!modelOptions.openapi) {
                    throw new Error(`modelOptions.openapi is required when selected model language is ${types_1.ModelLanguage.OPENAPI}`);
                }
                const openApiOptions = modelOptions.openapi;
                const openapi = this.addOpenApiDefinition(openApiOptions, handlerLanguages);
                return { specPath: openapi.openApiSpecificationPath };
            }
            else {
                throw new Error(`Unknown model language ${modelLanguage}`);
            }
        };
        this.addParseAndBundleTask = (openApiSpecificationPath, smithyJsonModelPath) => {
            this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.PARSE_OPENAPI_SPEC, `--specPath ${openApiSpecificationPath} --outputPath ${this.parsedSpecFile}${smithyJsonModelPath ? ` --smithyJsonPath ${smithyJsonModelPath}` : ""}`));
            this.addGitIgnore(this.parsedSpecFile);
        };
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        // Add the API definition
        const { specPath, smithyJsonModelPath } = this.addApiDefinition(options);
        this.apiName =
            options.modelOptions.smithy?.serviceName.serviceName ??
                options.modelOptions.openapi?.title;
        // Parse and bundle the openapi specification
        this.addParseAndBundleTask(specPath, smithyJsonModelPath);
        // Run the generate task as part of build
        this.compileTask.spawn(this.generateTask);
    }
}
exports.TypeSafeApiModelProjectBase = TypeSafeApiModelProjectBase;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiModelProjectBase[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiModelProjectBase", version: "0.23.72" };
//# sourceMappingURL=data:application/json;base64,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