import { OpenApiDefinition } from "./openapi/open-api-definition";
import { OpenApiProjectDefinition } from "./openapi/open-api-project-definition";
import { SmithyDefinition } from "./smithy/smithy-definition";
import { SmithyProjectDefinition } from "./smithy/smithy-project-definition";
import { TypeSafeApiModelProjectBase, TypeSafeApiModelProjectBaseOptions } from "./type-safe-api-model-project-base";
import { Language } from "../languages";
import { OpenApiModelOptions, SmithyModelOptions } from "../types";
export interface TypeSafeApiModelProjectOptions extends TypeSafeApiModelProjectBaseOptions {
}
export declare class TypeSafeApiModelProject extends TypeSafeApiModelProjectBase {
    /**
     * Reference to the Smithy definition component. Will be defined if the model language is Smithy
     */
    readonly smithy?: SmithyDefinition;
    /**
     * Reference to the OpenAPI definition component. Will be defined if the model language is OpenAPI
     */
    readonly openapi?: OpenApiDefinition;
    constructor(options: TypeSafeApiModelProjectOptions);
    protected addSmithyApiDefinition(options: SmithyModelOptions, handlerLanguages?: Language[] | undefined): SmithyProjectDefinition;
    protected addOpenApiDefinition(options: OpenApiModelOptions, handlerLanguages?: Language[] | undefined): OpenApiProjectDefinition;
}
