"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const open_api_definition_1 = require("./openapi/open-api-definition");
const smithy_definition_1 = require("./smithy/smithy-definition");
const type_safe_api_model_project_base_1 = require("./type-safe-api-model-project-base");
class TypeSafeApiModelProject extends type_safe_api_model_project_base_1.TypeSafeApiModelProjectBase {
    constructor(options) {
        super(options);
        // Add the README as a sample file which the user may edit
        new projen_1.SampleFile(this, "README.md", {
            sourcePath: path.resolve(__dirname, "..", "..", "..", "samples", "type-safe-api", "readme", "model-rest", `${options.modelLanguage}.md`),
        });
    }
    addSmithyApiDefinition(options, handlerLanguages) {
        const smithy = new smithy_definition_1.SmithyDefinition(this, {
            smithyOptions: options,
            handlerLanguages,
        });
        // @ts-ignore called from constructor
        this.smithy = smithy;
        return smithy;
    }
    addOpenApiDefinition(options, handlerLanguages) {
        const openapi = new open_api_definition_1.OpenApiDefinition(this, {
            openApiOptions: options,
            handlerLanguages,
        });
        // @ts-ignore called from constructor
        this.openapi = openapi;
        return openapi;
    }
}
exports.TypeSafeApiModelProject = TypeSafeApiModelProject;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiModelProject", version: "0.23.72" };
//# sourceMappingURL=data:application/json;base64,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