"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeWebSocketApiModelProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const open_api_async_definition_1 = require("./openapi/open-api-async-definition");
const smithy_async_definition_1 = require("./smithy/smithy-async-definition");
const type_safe_api_model_project_base_1 = require("./type-safe-api-model-project-base");
const utils_1 = require("../codegen/components/utils");
class TypeSafeWebSocketApiModelProject extends type_safe_api_model_project_base_1.TypeSafeApiModelProjectBase {
    constructor(options) {
        super(options);
        /**
         * Async API specification path, generated by Type Safe API for documentation generation
         */
        this.asyncApiSpecFile = ".asyncapi.json";
        // Add the README as a sample file which the user may edit
        new projen_1.SampleFile(this, "README.md", {
            sourcePath: path.resolve(__dirname, "..", "..", "..", "samples", "type-safe-api", "readme", "model-async", `${options.modelLanguage}.md`),
        });
        // Add a task to convert the OpenAPI into an AsyncAPI specification,
        // which can be used for documentation generation.
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_ASYNCAPI_SPEC, `--specPath ${this.parsedSpecFile} --outputPath ${this.asyncApiSpecFile}`));
        this.addGitIgnore(this.asyncApiSpecFile);
    }
    addSmithyApiDefinition(options, handlerLanguages) {
        const smithy = new smithy_async_definition_1.SmithyAsyncDefinition(this, {
            smithyOptions: options,
            handlerLanguages,
        });
        // @ts-ignore called from constructor
        this.smithy = smithy;
        return smithy;
    }
    addOpenApiDefinition(options, handlerLanguages) {
        const openapi = new open_api_async_definition_1.OpenApiAsyncDefinition(this, {
            openApiOptions: options,
            handlerLanguages,
        });
        // @ts-ignore called from constructor
        this.openapi = openapi;
        return openapi;
    }
}
exports.TypeSafeWebSocketApiModelProject = TypeSafeWebSocketApiModelProject;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeWebSocketApiModelProject[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeWebSocketApiModelProject", version: "0.23.72" };
//# sourceMappingURL=data:application/json;base64,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