# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """Resource.

    Common fields that are returned in the response for all Azure Resource
    Manager resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """Entity Resource.

    The resource model definition for an Azure Resource Manager resource with
    an etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class CheckNameAvailabilityParameters(Model):
    """Parameters body to pass for resource name availability check.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name.
    :type name: str
    :param type: Required. Resource type. The only legal value of this
     property for checking redis cache name availability is
     'Microsoft.Cache/redis'.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str, type: str, **kwargs) -> None:
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.redis.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.redis.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(Model):
    """Error response.

    Common error response for all Azure Resource Manager APIs to return error
    details for failed operations. (This also follows the OData error response
    format.).

    :param error: The error object.
    :type error: ~azure.mgmt.redis.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ExportRDBParameters(Model):
    """Parameters for Redis export operation.

    All required parameters must be populated in order to send to Azure.

    :param format: File format.
    :type format: str
    :param prefix: Required. Prefix to use for exported files.
    :type prefix: str
    :param container: Required. Container name to export to.
    :type container: str
    """

    _validation = {
        'prefix': {'required': True},
        'container': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'prefix': {'key': 'prefix', 'type': 'str'},
        'container': {'key': 'container', 'type': 'str'},
    }

    def __init__(self, *, prefix: str, container: str, format: str=None, **kwargs) -> None:
        super(ExportRDBParameters, self).__init__(**kwargs)
        self.format = format
        self.prefix = prefix
        self.container = container


class ImportRDBParameters(Model):
    """Parameters for Redis import operation.

    All required parameters must be populated in order to send to Azure.

    :param format: File format.
    :type format: str
    :param files: Required. files to import.
    :type files: list[str]
    """

    _validation = {
        'files': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'files': {'key': 'files', 'type': '[str]'},
    }

    def __init__(self, *, files, format: str=None, **kwargs) -> None:
        super(ImportRDBParameters, self).__init__(**kwargs)
        self.format = format
        self.files = files


class Operation(Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.redis.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, name: str=None, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider
    :type provider: str
    :param operation: Operation type: read, write, delete, listKeys/action,
     etc.
    :type operation: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param description: Friendly name of the operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, operation: str=None, resource: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.operation = operation
        self.resource = resource
        self.description = description


class PrivateEndpoint(Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ARM identifier for Private Endpoint
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.redis.models.PrivateEndpoint
    :param private_link_service_connection_state: Required. A collection of
     information about the state of the connection between service consumer and
     provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.redis.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint
     connection resource. Possible values include: 'Succeeded', 'Creating',
     'Deleting', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.redis.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_link_service_connection_state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_link_service_connection_state, private_endpoint=None, provisioning_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS
     zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, *, required_zone_names=None, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkServiceConnectionState(Model):
    """A collection of information about the state of the connection between
    service consumer and provider.

    :param status: Indicates whether the connection has been
     Approved/Rejected/Removed by the owner of the service. Possible values
     include: 'Pending', 'Approved', 'Rejected'
    :type status: str or
     ~azure.mgmt.redis.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service
     provider require any updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status=None, description: str=None, actions_required: str=None, **kwargs) -> None:
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProxyResource(Resource):
    """Proxy Resource.

    The resource model definition for a Azure Resource Manager proxy resource.
    It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class RedisAccessKeys(Model):
    """Redis cache access keys.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_key: The current primary key that clients can use to
     authenticate with Redis cache.
    :vartype primary_key: str
    :ivar secondary_key: The current secondary key that clients can use to
     authenticate with Redis cache.
    :vartype secondary_key: str
    """

    _validation = {
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
    }

    _attribute_map = {
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(RedisAccessKeys, self).__init__(**kwargs)
        self.primary_key = None
        self.secondary_key = None


class RedisCommonProperties(Model):
    """Create/Update/Get common properties of the redis cache.

    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict[str, str]
    :param redis_version: Redis version. Only major version will be used in
     PUT/PATCH request with current valid values: (4, 6)
    :type redis_version: str
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server
     port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per
     primary.
    :type replicas_per_master: int
    :param replicas_per_primary: The number of replicas to be created per
     primary.
    :type replicas_per_primary: int
    :param tenant_settings: A dictionary of tenant settings
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified
     TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible
     values include: '1.0', '1.1', '1.2'
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param public_network_access: Whether or not public endpoint access is
     allowed for this cache.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
     exclusive access method. Default value is 'Enabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.redis.models.PublicNetworkAccess
    """

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'redis_version': {'key': 'redisVersion', 'type': 'str'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'replicas_per_primary': {'key': 'replicasPerPrimary', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(self, *, redis_configuration=None, redis_version: str=None, enable_non_ssl_port: bool=None, replicas_per_master: int=None, replicas_per_primary: int=None, tenant_settings=None, shard_count: int=None, minimum_tls_version=None, public_network_access=None, **kwargs) -> None:
        super(RedisCommonProperties, self).__init__(**kwargs)
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access


class RedisCreateParameters(Model):
    """Parameters supplied to the Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict[str, str]
    :param redis_version: Redis version. Only major version will be used in
     PUT/PATCH request with current valid values: (4, 6)
    :type redis_version: str
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server
     port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per
     primary.
    :type replicas_per_master: int
    :param replicas_per_primary: The number of replicas to be created per
     primary.
    :type replicas_per_primary: int
    :param tenant_settings: A dictionary of tenant settings
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified
     TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible
     values include: '1.0', '1.1', '1.2'
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param public_network_access: Whether or not public endpoint access is
     allowed for this cache.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
     exclusive access method. Default value is 'Enabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.redis.models.PublicNetworkAccess
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to
     deploy the Redis cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache
     inside an existing Azure Virtual Network.
    :type static_ip: str
    :param zones: A list of availability zones denoting where the resource
     needs to come from.
    :type zones: list[str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
        'location': {'required': True},
    }

    _attribute_map = {
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'replicas_per_primary': {'key': 'properties.replicasPerPrimary', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIP', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, sku, location: str, redis_configuration=None, redis_version: str=None, enable_non_ssl_port: bool=None, replicas_per_master: int=None, replicas_per_primary: int=None, tenant_settings=None, shard_count: int=None, minimum_tls_version=None, public_network_access=None, subnet_id: str=None, static_ip: str=None, zones=None, tags=None, **kwargs) -> None:
        super(RedisCreateParameters, self).__init__(**kwargs)
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip
        self.zones = zones
        self.location = location
        self.tags = tags


class RedisCreateProperties(RedisCommonProperties):
    """Properties supplied to Create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict[str, str]
    :param redis_version: Redis version. Only major version will be used in
     PUT/PATCH request with current valid values: (4, 6)
    :type redis_version: str
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server
     port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per
     primary.
    :type replicas_per_master: int
    :param replicas_per_primary: The number of replicas to be created per
     primary.
    :type replicas_per_primary: int
    :param tenant_settings: A dictionary of tenant settings
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified
     TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible
     values include: '1.0', '1.1', '1.2'
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param public_network_access: Whether or not public endpoint access is
     allowed for this cache.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
     exclusive access method. Default value is 'Enabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.redis.models.PublicNetworkAccess
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to
     deploy the Redis cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache
     inside an existing Azure Virtual Network.
    :type static_ip: str
    """

    _validation = {
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
    }

    _attribute_map = {
        'redis_configuration': {'key': 'redisConfiguration', 'type': '{str}'},
        'redis_version': {'key': 'redisVersion', 'type': 'str'},
        'enable_non_ssl_port': {'key': 'enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'replicasPerMaster', 'type': 'int'},
        'replicas_per_primary': {'key': 'replicasPerPrimary', 'type': 'int'},
        'tenant_settings': {'key': 'tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'static_ip': {'key': 'staticIP', 'type': 'str'},
    }

    def __init__(self, *, sku, redis_configuration=None, redis_version: str=None, enable_non_ssl_port: bool=None, replicas_per_master: int=None, replicas_per_primary: int=None, tenant_settings=None, shard_count: int=None, minimum_tls_version=None, public_network_access=None, subnet_id: str=None, static_ip: str=None, **kwargs) -> None:
        super(RedisCreateProperties, self).__init__(redis_configuration=redis_configuration, redis_version=redis_version, enable_non_ssl_port=enable_non_ssl_port, replicas_per_master=replicas_per_master, replicas_per_primary=replicas_per_primary, tenant_settings=tenant_settings, shard_count=shard_count, minimum_tls_version=minimum_tls_version, public_network_access=public_network_access, **kwargs)
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip


class RedisFirewallRule(ProxyResource):
    """A firewall rule on a redis cache has a name, and describes a contiguous
    range of IP addresses permitted to connect.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param start_ip: Required. lowest IP address included in the range
    :type start_ip: str
    :param end_ip: Required. highest IP address included in the range
    :type end_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip': {'required': True},
        'end_ip': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip': {'key': 'properties.startIP', 'type': 'str'},
        'end_ip': {'key': 'properties.endIP', 'type': 'str'},
    }

    def __init__(self, *, start_ip: str, end_ip: str, **kwargs) -> None:
        super(RedisFirewallRule, self).__init__(**kwargs)
        self.start_ip = start_ip
        self.end_ip = end_ip


class RedisFirewallRuleCreateParameters(RedisFirewallRule):
    """Parameters required for creating a firewall rule on redis cache. (Note, you
    can just use the FirewallRule type instead now.).

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param start_ip: Required. lowest IP address included in the range
    :type start_ip: str
    :param end_ip: Required. highest IP address included in the range
    :type end_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip': {'required': True},
        'end_ip': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip': {'key': 'properties.startIP', 'type': 'str'},
        'end_ip': {'key': 'properties.endIP', 'type': 'str'},
    }

    def __init__(self, *, start_ip: str, end_ip: str, **kwargs) -> None:
        super(RedisFirewallRuleCreateParameters, self).__init__(start_ip=start_ip, end_ip=end_ip, **kwargs)


class RedisForceRebootResponse(Model):
    """Response to force reboot for Redis cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar message: Status message
    :vartype message: str
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(RedisForceRebootResponse, self).__init__(**kwargs)
        self.message = None


class RedisInstanceDetails(Model):
    """Details of single instance of redis.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar ssl_port: Redis instance SSL port.
    :vartype ssl_port: int
    :ivar non_ssl_port: If enableNonSslPort is true, provides Redis instance
     Non-SSL port.
    :vartype non_ssl_port: int
    :ivar zone: If the Cache uses availability zones, specifies availability
     zone where this instance is located.
    :vartype zone: str
    :ivar shard_id: If clustering is enabled, the Shard ID of Redis Instance
    :vartype shard_id: int
    :ivar is_master: Specifies whether the instance is a primary node.
    :vartype is_master: bool
    :ivar is_primary: Specifies whether the instance is a primary node.
    :vartype is_primary: bool
    """

    _validation = {
        'ssl_port': {'readonly': True},
        'non_ssl_port': {'readonly': True},
        'zone': {'readonly': True},
        'shard_id': {'readonly': True},
        'is_master': {'readonly': True},
        'is_primary': {'readonly': True},
    }

    _attribute_map = {
        'ssl_port': {'key': 'sslPort', 'type': 'int'},
        'non_ssl_port': {'key': 'nonSslPort', 'type': 'int'},
        'zone': {'key': 'zone', 'type': 'str'},
        'shard_id': {'key': 'shardId', 'type': 'int'},
        'is_master': {'key': 'isMaster', 'type': 'bool'},
        'is_primary': {'key': 'isPrimary', 'type': 'bool'},
    }

    def __init__(self, **kwargs) -> None:
        super(RedisInstanceDetails, self).__init__(**kwargs)
        self.ssl_port = None
        self.non_ssl_port = None
        self.zone = None
        self.shard_id = None
        self.is_master = None
        self.is_primary = None


class RedisLinkedServer(Model):
    """Linked server Id.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Linked server Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(RedisLinkedServer, self).__init__(**kwargs)
        self.id = None


class RedisLinkedServerCreateParameters(Model):
    """Parameter required for creating a linked server to redis cache.

    All required parameters must be populated in order to send to Azure.

    :param linked_redis_cache_id: Required. Fully qualified resourceId of the
     linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis
     cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values
     include: 'Primary', 'Secondary'
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    """

    _validation = {
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
    }

    _attribute_map = {
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'ReplicationRole'},
    }

    def __init__(self, *, linked_redis_cache_id: str, linked_redis_cache_location: str, server_role, **kwargs) -> None:
        super(RedisLinkedServerCreateParameters, self).__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role


class RedisLinkedServerWithProperties(ProxyResource):
    """Response to put/get linked server (with properties) for Redis cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param linked_redis_cache_id: Required. Fully qualified resourceId of the
     linked redis cache.
    :type linked_redis_cache_id: str
    :param linked_redis_cache_location: Required. Location of the linked redis
     cache.
    :type linked_redis_cache_location: str
    :param server_role: Required. Role of the linked server. Possible values
     include: 'Primary', 'Secondary'
    :type server_role: str or ~azure.mgmt.redis.models.ReplicationRole
    :ivar provisioning_state: Terminal state of the link between primary and
     secondary redis cache.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'linked_redis_cache_id': {'required': True},
        'linked_redis_cache_location': {'required': True},
        'server_role': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_redis_cache_id': {'key': 'properties.linkedRedisCacheId', 'type': 'str'},
        'linked_redis_cache_location': {'key': 'properties.linkedRedisCacheLocation', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'ReplicationRole'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, linked_redis_cache_id: str, linked_redis_cache_location: str, server_role, **kwargs) -> None:
        super(RedisLinkedServerWithProperties, self).__init__(**kwargs)
        self.linked_redis_cache_id = linked_redis_cache_id
        self.linked_redis_cache_location = linked_redis_cache_location
        self.server_role = server_role
        self.provisioning_state = None


class RedisPatchSchedule(ProxyResource):
    """Response to put/get patch schedules for Redis cache.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param schedule_entries: Required. List of patch schedules for a Redis
     cache.
    :type schedule_entries: list[~azure.mgmt.redis.models.ScheduleEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'schedule_entries': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'schedule_entries': {'key': 'properties.scheduleEntries', 'type': '[ScheduleEntry]'},
    }

    def __init__(self, *, schedule_entries, **kwargs) -> None:
        super(RedisPatchSchedule, self).__init__(**kwargs)
        self.schedule_entries = schedule_entries


class RedisRebootParameters(Model):
    """Specifies which Redis node(s) to reboot.

    :param reboot_type: Which Redis node(s) to reboot. Depending on this value
     data loss is possible. Possible values include: 'PrimaryNode',
     'SecondaryNode', 'AllNodes'
    :type reboot_type: str or ~azure.mgmt.redis.models.RebootType
    :param shard_id: If clustering is enabled, the ID of the shard to be
     rebooted.
    :type shard_id: int
    :param ports: A list of redis instances to reboot, specified by
     per-instance SSL ports or non-SSL ports.
    :type ports: list[int]
    """

    _attribute_map = {
        'reboot_type': {'key': 'rebootType', 'type': 'str'},
        'shard_id': {'key': 'shardId', 'type': 'int'},
        'ports': {'key': 'ports', 'type': '[int]'},
    }

    def __init__(self, *, reboot_type=None, shard_id: int=None, ports=None, **kwargs) -> None:
        super(RedisRebootParameters, self).__init__(**kwargs)
        self.reboot_type = reboot_type
        self.shard_id = shard_id
        self.ports = ports


class RedisRegenerateKeyParameters(Model):
    """Specifies which Redis access keys to reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The Redis access key to regenerate. Possible
     values include: 'Primary', 'Secondary'
    :type key_type: str or ~azure.mgmt.redis.models.RedisKeyType
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'RedisKeyType'},
    }

    def __init__(self, *, key_type, **kwargs) -> None:
        super(RedisRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_type = key_type


class TrackedResource(Resource):
    """Tracked Resource.

    The resource model definition for an Azure Resource Manager tracked top
    level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class RedisResource(TrackedResource):
    """A single Redis item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. E.g.
     "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict[str, str]
    :param redis_version: Redis version. Only major version will be used in
     PUT/PATCH request with current valid values: (4, 6)
    :type redis_version: str
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server
     port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per
     primary.
    :type replicas_per_master: int
    :param replicas_per_primary: The number of replicas to be created per
     primary.
    :type replicas_per_primary: int
    :param tenant_settings: A dictionary of tenant settings
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified
     TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible
     values include: '1.0', '1.1', '1.2'
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param public_network_access: Whether or not public endpoint access is
     allowed for this cache.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
     exclusive access method. Default value is 'Enabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.redis.models.PublicNetworkAccess
    :param sku: Required. The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param subnet_id: The full resource ID of a subnet in a virtual network to
     deploy the Redis cache in. Example format:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
    :type subnet_id: str
    :param static_ip: Static IP address. Required when deploying a Redis cache
     inside an existing Azure Virtual Network.
    :type static_ip: str
    :ivar provisioning_state: Redis instance provisioning status. Possible
     values include: 'Creating', 'Deleting', 'Disabled', 'Failed', 'Linking',
     'Provisioning', 'RecoveringScaleFailure', 'Scaling', 'Succeeded',
     'Unlinking', 'Unprovisioning', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.redis.models.ProvisioningState
    :ivar host_name: Redis host name.
    :vartype host_name: str
    :ivar port: Redis non-SSL port.
    :vartype port: int
    :ivar ssl_port: Redis SSL port.
    :vartype ssl_port: int
    :ivar access_keys: The keys of the Redis cache - not set if this object is
     not the response to Create or Update redis cache
    :vartype access_keys: ~azure.mgmt.redis.models.RedisAccessKeys
    :ivar linked_servers: List of the linked servers associated with the cache
    :vartype linked_servers: list[~azure.mgmt.redis.models.RedisLinkedServer]
    :ivar instances: List of the Redis instances associated with the cache
    :vartype instances: list[~azure.mgmt.redis.models.RedisInstanceDetails]
    :ivar private_endpoint_connections: List of private endpoint connection
     associated with the specified redis cache
    :vartype private_endpoint_connections:
     list[~azure.mgmt.redis.models.PrivateEndpointConnection]
    :param zones: A list of availability zones denoting where the resource
     needs to come from.
    :type zones: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'subnet_id': {'pattern': r'^/subscriptions/[^/]*/resourceGroups/[^/]*/providers/Microsoft.(ClassicNetwork|Network)/virtualNetworks/[^/]*/subnets/[^/]*$'},
        'static_ip': {'pattern': r'^\d+\.\d+\.\d+\.\d+$'},
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
        'port': {'readonly': True},
        'ssl_port': {'readonly': True},
        'access_keys': {'readonly': True},
        'linked_servers': {'readonly': True},
        'instances': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'replicas_per_primary': {'key': 'properties.replicasPerPrimary', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIP', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'ssl_port': {'key': 'properties.sslPort', 'type': 'int'},
        'access_keys': {'key': 'properties.accessKeys', 'type': 'RedisAccessKeys'},
        'linked_servers': {'key': 'properties.linkedServers', 'type': '[RedisLinkedServer]'},
        'instances': {'key': 'properties.instances', 'type': '[RedisInstanceDetails]'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, *, location: str, sku, tags=None, redis_configuration=None, redis_version: str=None, enable_non_ssl_port: bool=None, replicas_per_master: int=None, replicas_per_primary: int=None, tenant_settings=None, shard_count: int=None, minimum_tls_version=None, public_network_access=None, subnet_id: str=None, static_ip: str=None, zones=None, **kwargs) -> None:
        super(RedisResource, self).__init__(tags=tags, location=location, **kwargs)
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku
        self.subnet_id = subnet_id
        self.static_ip = static_ip
        self.provisioning_state = None
        self.host_name = None
        self.port = None
        self.ssl_port = None
        self.access_keys = None
        self.linked_servers = None
        self.instances = None
        self.private_endpoint_connections = None
        self.zones = zones


class RedisUpdateParameters(Model):
    """Parameters supplied to the Update Redis operation.

    :param redis_configuration: All Redis Settings. Few possible keys:
     rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value
     etc.
    :type redis_configuration: dict[str, str]
    :param redis_version: Redis version. Only major version will be used in
     PUT/PATCH request with current valid values: (4, 6)
    :type redis_version: str
    :param enable_non_ssl_port: Specifies whether the non-ssl Redis server
     port (6379) is enabled.
    :type enable_non_ssl_port: bool
    :param replicas_per_master: The number of replicas to be created per
     primary.
    :type replicas_per_master: int
    :param replicas_per_primary: The number of replicas to be created per
     primary.
    :type replicas_per_primary: int
    :param tenant_settings: A dictionary of tenant settings
    :type tenant_settings: dict[str, str]
    :param shard_count: The number of shards to be created on a Premium
     Cluster Cache.
    :type shard_count: int
    :param minimum_tls_version: Optional: requires clients to use a specified
     TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2'). Possible
     values include: '1.0', '1.1', '1.2'
    :type minimum_tls_version: str or ~azure.mgmt.redis.models.TlsVersion
    :param public_network_access: Whether or not public endpoint access is
     allowed for this cache.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the
     exclusive access method. Default value is 'Enabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.redis.models.PublicNetworkAccess
    :param sku: The SKU of the Redis cache to deploy.
    :type sku: ~azure.mgmt.redis.models.Sku
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'redis_configuration': {'key': 'properties.redisConfiguration', 'type': '{str}'},
        'redis_version': {'key': 'properties.redisVersion', 'type': 'str'},
        'enable_non_ssl_port': {'key': 'properties.enableNonSslPort', 'type': 'bool'},
        'replicas_per_master': {'key': 'properties.replicasPerMaster', 'type': 'int'},
        'replicas_per_primary': {'key': 'properties.replicasPerPrimary', 'type': 'int'},
        'tenant_settings': {'key': 'properties.tenantSettings', 'type': '{str}'},
        'shard_count': {'key': 'properties.shardCount', 'type': 'int'},
        'minimum_tls_version': {'key': 'properties.minimumTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, redis_configuration=None, redis_version: str=None, enable_non_ssl_port: bool=None, replicas_per_master: int=None, replicas_per_primary: int=None, tenant_settings=None, shard_count: int=None, minimum_tls_version=None, public_network_access=None, sku=None, tags=None, **kwargs) -> None:
        super(RedisUpdateParameters, self).__init__(**kwargs)
        self.redis_configuration = redis_configuration
        self.redis_version = redis_version
        self.enable_non_ssl_port = enable_non_ssl_port
        self.replicas_per_master = replicas_per_master
        self.replicas_per_primary = replicas_per_primary
        self.tenant_settings = tenant_settings
        self.shard_count = shard_count
        self.minimum_tls_version = minimum_tls_version
        self.public_network_access = public_network_access
        self.sku = sku
        self.tags = tags


class ScheduleEntry(Model):
    """Patch schedule entry for a Premium Redis Cache.

    All required parameters must be populated in order to send to Azure.

    :param day_of_week: Required. Day of the week when a cache can be patched.
     Possible values include: 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
     'Friday', 'Saturday', 'Sunday', 'Everyday', 'Weekend'
    :type day_of_week: str or ~azure.mgmt.redis.models.DayOfWeek
    :param start_hour_utc: Required. Start hour after which cache patching can
     start.
    :type start_hour_utc: int
    :param maintenance_window: ISO8601 timespan specifying how much time cache
     patching can take.
    :type maintenance_window: timedelta
    """

    _validation = {
        'day_of_week': {'required': True},
        'start_hour_utc': {'required': True},
    }

    _attribute_map = {
        'day_of_week': {'key': 'dayOfWeek', 'type': 'DayOfWeek'},
        'start_hour_utc': {'key': 'startHourUtc', 'type': 'int'},
        'maintenance_window': {'key': 'maintenanceWindow', 'type': 'duration'},
    }

    def __init__(self, *, day_of_week, start_hour_utc: int, maintenance_window=None, **kwargs) -> None:
        super(ScheduleEntry, self).__init__(**kwargs)
        self.day_of_week = day_of_week
        self.start_hour_utc = start_hour_utc
        self.maintenance_window = maintenance_window


class Sku(Model):
    """SKU parameters supplied to the create Redis operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The type of Redis cache to deploy. Valid values:
     (Basic, Standard, Premium). Possible values include: 'Basic', 'Standard',
     'Premium'
    :type name: str or ~azure.mgmt.redis.models.SkuName
    :param family: Required. The SKU family to use. Valid values: (C, P). (C =
     Basic/Standard, P = Premium). Possible values include: 'C', 'P'
    :type family: str or ~azure.mgmt.redis.models.SkuFamily
    :param capacity: Required. The size of the Redis cache to deploy. Valid
     values: for C (Basic/Standard) family (0, 1, 2, 3, 4, 5, 6), for P
     (Premium) family (1, 2, 3, 4).
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'family': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, *, name, family, capacity: int, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.family = family
        self.capacity = capacity


class UpgradeNotification(Model):
    """Properties of upgrade notification.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of upgrade notification.
    :vartype name: str
    :ivar timestamp: Timestamp when upgrade notification occurred.
    :vartype timestamp: datetime
    :ivar upsell_notification: Details about this upgrade notification
    :vartype upsell_notification: dict[str, str]
    """

    _validation = {
        'name': {'readonly': True},
        'timestamp': {'readonly': True},
        'upsell_notification': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'upsell_notification': {'key': 'upsellNotification', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(UpgradeNotification, self).__init__(**kwargs)
        self.name = None
        self.timestamp = None
        self.upsell_notification = None
