<p align="center"><img src="https://raw.githubusercontent.com/PKSHATechnology-Research/camphr/master/img/logoc.svg?sanitize=true" width="200" /></p>

# Camphr - spaCy plugin for Transformers, Udify, Elmo, etc.

[![Documentation Status](https://readthedocs.org/projects/camphr/badge/?version=latest)](https://camphr.readthedocs.io/en/latest/?badge=latest)
[![Gitter](https://badges.gitter.im/camphr/community.svg)](https://gitter.im/camphr/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)
[![PyPI version](https://badge.fury.io/py/camphr.svg)](https://badge.fury.io/py/camphr)
![test and publish](https://github.com/PKSHATechnology-Research/camphr/workflows/test%20and%20publish/badge.svg)
![](https://github.com/PKSHATechnology-Research/camphr/workflows/test%20extras/badge.svg)
![](https://github.com/PKSHATechnology-Research/camphr/workflows/test%20package/badge.svg)

Camphr is a *Natural Language Processing* library that helps in seamless integration for a wide variety of techniques from state-of-the-art to conventional ones.
You can use [Transformers](https://huggingface.co/transformers/) ,  [Udify](https://github.com/Hyperparticle/udify), [ELmo](https://allennlp.org/elmo), etc. on [spaCy](https://github.com/explosion/spaCy).

Check the [documentation](https://camphr.readthedocs.io/en/latest/) for more information.

(For Japanese: https://qiita.com/tamurahey/items/53a1902625ccaac1bb2f)

# Features

- A [spaCy](https://github.com/explosion/spaCy) plugin - Easily integration for a wide variety of methods
- [Transformers](https://huggingface.co/transformers/) with spaCy - Fine-tuning pretrained model with [Hydra](https://hydra.cc/). Embedding vector
- [Udify](https://github.com/Hyperparticle/udify) - BERT based multitask model in 75 languages
- [Elmo](https://allennlp.org/elmo) - Deep contextualized word representations
- Rule base matching with Aho-Corasick, Regex
- (for Japanese) KNP

# License

Camphr is licensed under [Apache 2.0](./LICENSE).

