model = dict(type='FasterRCNN',
             backbone=dict(type='ResNet',
                           depth=50,
                           num_stages=4,
                           out_indices=(0, 1, 2, 3),
                           frozen_stages=1,
                           norm_cfg=dict(type='BN', requires_grad=True),
                           norm_eval=True,
                           style='pytorch'),
             neck=dict(type='FPN',
                       in_channels=[256, 512, 1024, 2048],
                       out_channels=256,
                       num_outs=5),
             rpn_head=dict(type='RPNHead',
                           in_channels=256,
                           feat_channels=256,
                           anchor_generator=dict(type='AnchorGenerator',
                                                 scales=[8],
                                                 ratios=[0.5, 1.0, 2.0],
                                                 strides=[4, 8, 16, 32, 64]),
                           bbox_coder=dict(type='DeltaXYWHBBoxCoder',
                                           target_means=[0.0, 0.0, 0.0, 0.0],
                                           target_stds=[1.0, 1.0, 1.0, 1.0])),
             roi_head=dict(
                 type='StandardRoIHead',
                 bbox_roi_extractor=dict(type='SingleRoIExtractor',
                                         roi_layer=dict(type='RoIAlign',
                                                        output_size=7,
                                                        sampling_ratio=0),
                                         out_channels=256,
                                         featmap_strides=[4, 8, 16, 32]),
                 bbox_head=dict(type='Shared2FCBBoxHead',
                                in_channels=256,
                                fc_out_channels=1024,
                                roi_feat_size=7,
                                num_classes=1,
                                bbox_coder=dict(
                                    type='DeltaXYWHBBoxCoder',
                                    target_means=[0.0, 0.0, 0.0, 0.0],
                                    target_stds=[0.1, 0.1, 0.2, 0.2]),
                                reg_class_agnostic=False)),
             test_cfg=dict(rpn=dict(nms_pre=1000,
                                    max_per_img=1000,
                                    nms=dict(type='nms', iou_threshold=0.7),
                                    min_bbox_size=0),
                           rcnn=dict(score_thr=0.05,
                                     nms=dict(type='nms', iou_threshold=0.5),
                                     max_per_img=100)))
test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='MultiScaleFlipAug',
         img_scale=(1333, 800),
         flip=False,
         transforms=[
             dict(type='Resize', keep_ratio=True),
             dict(type='RandomFlip'),
             dict(type='Normalize',
                  mean=[123.675, 116.28, 103.53],
                  std=[58.395, 57.12, 57.375],
                  to_rgb=True),
             dict(type='Pad', size_divisor=32),
             dict(type='ImageToTensor', keys=['img']),
             dict(type='Collect', keys=['img'])
         ])
]
data = dict(test=dict(pipeline=test_pipeline))
