model = dict(type='YOLOV3',
             backbone=dict(type='Darknet', depth=53, out_indices=(3, 4, 5)),
             neck=dict(type='YOLOV3Neck',
                       num_scales=3,
                       in_channels=[1024, 512, 256],
                       out_channels=[512, 256, 128]),
             bbox_head=dict(type='YOLOV3Head',
                            num_classes=1,
                            in_channels=[512, 256, 128],
                            out_channels=[1024, 512, 256],
                            anchor_generator=dict(type='YOLOAnchorGenerator',
                                                  base_sizes=[[(116, 90),
                                                               (156, 198),
                                                               (373, 326)],
                                                              [(30, 61),
                                                               (62, 45),
                                                               (59, 119)],
                                                              [(10, 13),
                                                               (16, 30),
                                                               (33, 23)]],
                                                  strides=[32, 16, 8]),
                            bbox_coder=dict(type='YOLOBBoxCoder'),
                            featmap_strides=[32, 16, 8]),
             test_cfg=dict(nms_pre=1000,
                           min_bbox_size=0,
                           score_thr=0.05,
                           conf_thr=0.005,
                           nms=dict(type='nms', iou_threshold=0.45),
                           max_per_img=100))
test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='MultiScaleFlipAug',
         img_scale=(608, 608),
         flip=False,
         transforms=[
             dict(type='Resize', keep_ratio=True),
             dict(type='RandomFlip'),
             dict(type='Normalize',
                  mean=[0, 0, 0],
                  std=[255.0, 255.0, 255.0],
                  to_rgb=True),
             dict(type='Pad', size_divisor=32),
             dict(type='ImageToTensor', keys=['img']),
             dict(type='Collect', keys=['img'])
         ])
]
data = dict(test=dict(pipeline=test_pipeline))
