# Generated by Django 2.2.7 on 2019-12-05 05:12

import controlled_vocabulary.models
from django.db import migrations, models
import django.db.models.deletion
import dublincore_resource.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('controlled_vocabulary', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='DublinCoreAgent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('full_name', models.CharField(max_length=200)),
                ('identifier', models.URLField(blank=True, default='', max_length=300)),
            ],
        ),
        migrations.CreateModel(
            name='DublinCoreRights',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('shorthand', models.CharField(blank=True, default='', max_length=50)),
                ('statement', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='DublinCoreResource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identifier', models.CharField(blank=True, default='', help_text='A code or URL that uniquely identifies the resource within a referencial system. It should be compact, widely recognised and as stable as possible (i.e. it will never change in the future). e.g. ISBN:1-56592-149-6', max_length=200)),
                ('title', models.CharField(help_text='A name given to the resource.', max_length=300)),
                ('date', models.CharField(blank=True, default='', help_text="The point or period in time the resource was created or made available. Not necessarily the same as 'temporal' column (see below).", max_length=30)),
                ('bibliographic_citation', models.TextField(blank=True, default='', help_text='A bibliographic reference for the resource.')),
                ('description', models.TextField(blank=True, default='', help_text='An account of the resource (e.g. abstract, summary). One or more sentences.')),
                ('temporal', models.CharField(blank=True, default='', help_text='The date or period in history the resource refers to.', max_length=200)),
                ('attachment', models.FileField(blank=True, default='', upload_to=dublincore_resource.models.get_upload_path)),
                ('contributors', models.ManyToManyField(blank=True, help_text='A person or organization not specified in a Creator element who has made significant intellectual contributions to the resource but whose contribution is secondary to any person or organization specified in a Creator element', related_name='contributed_resources', to='dublincore_resource.DublinCoreAgent')),
                ('creators', models.ManyToManyField(blank=True, help_text='The person or organization primarily responsible for creating the intellectual content of the resource.', related_name='created_resources', to='dublincore_resource.DublinCoreAgent')),
                ('format', controlled_vocabulary.models.ControlledTermField(blank=True, help_text='The physical or digital manifestation of the resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='controlled_vocabulary.ControlledTerm', vocabularies='mime')),
                ('language', controlled_vocabulary.models.ControlledTermField(blank=True, help_text='The primary language of the resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='controlled_vocabulary.ControlledTerm', vocabularies='iso639-2')),
                ('publisher', models.ForeignKey(blank=True, help_text='An entity responsible for making the resource available.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='published_resources', to='dublincore_resource.DublinCoreAgent')),
                ('rights', models.ForeignKey(blank=True, help_text='A rights management statement, an identifier that links to a rights management statement, or an identifier that links to a service providing information about rights management for the resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='resources', to='dublincore_resource.DublinCoreRights')),
                ('spatial', controlled_vocabulary.models.ControlledTermField(blank=True, help_text="The location or geographic scope of the resource's content.", null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='controlled_vocabulary.ControlledTerm', vocabularies='wikidata')),
                ('subject', controlled_vocabulary.models.ControlledTermField(blank=True, help_text='The topic of the resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='controlled_vocabulary.ControlledTerm', vocabularies='fast-topic')),
                ('type', controlled_vocabulary.models.ControlledTermField(blank=True, help_text='The nature or genre of the resource.', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to='controlled_vocabulary.ControlledTerm', vocabularies='dcmitype')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
