# affinidi_tdk_vault_data_manager_client

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

For more information, please visit [https://github.com/affinidi/affinidi-tdk](https://github.com/affinidi/affinidi-tdk)

Documentation is available at [https://docs.affinidi.com/dev-tools/affinidi-tdk/clients/vault-data-manager](https://docs.affinidi.com/dev-tools/affinidi-tdk/clients/vault-data-manager)

## Requirements.

Python 3.7+

## Installation & Usage

### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install affinidi_tdk_vault_data_manager_client
```

Then import the package:

```python
import affinidi_tdk_vault_data_manager_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```

Then import the package:

```python
import affinidi_tdk_vault_data_manager_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import affinidi_tdk_vault_data_manager_client
from affinidi_tdk_vault_data_manager_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.vault.affinidi.com/vfs
# See configuration.py for a list of all supported configuration parameters.
configuration = affinidi_tdk_vault_data_manager_client.Configuration(
    host = "https://api.vault.affinidi.com/vfs"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ConsumerTokenAuth
configuration.api_key['ConsumerTokenAuth'] = os.environ["API_KEY"]

# Configure a hook to auto-refresh API key for your personal access token (PAT), if expired
import affinidi_tdk_auth_provider

stats = {
  apiGatewayUrl,
  keyId,
  passphrase,
  privateKey,
  projectId,
  tokenEndpoint,
  tokenId,
}
authProvider = affinidi_tdk_auth_provider.AuthProvider(stats)
configuration.refresh_api_key_hook = lambda api_client: authProvider.fetch_project_scoped_token()

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ConsumerTokenAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with affinidi_tdk_vault_data_manager_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = affinidi_tdk_vault_data_manager_client.AccountsApi(api_client)
    create_account_input = affinidi_tdk_vault_data_manager_client.CreateAccountInput() # CreateAccountInput | CreateAccount

    try:
        api_response = api_instance.create_account(create_account_input)
        print("The response of AccountsApi->create_account:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccountsApi->create_account: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.vault.affinidi.com/vfs*

| Class            | Method                                                                        | HTTP request                                          | Description |
| ---------------- | ----------------------------------------------------------------------------- | ----------------------------------------------------- | ----------- |
| _AccountsApi_    | [**create_account**](docs/AccountsApi.md#create_account)                      | **POST** /v1/accounts                                 |
| _AccountsApi_    | [**delete_account**](docs/AccountsApi.md#delete_account)                      | **DELETE** /v1/accounts/{accountIndex}                |
| _AccountsApi_    | [**list_accounts**](docs/AccountsApi.md#list_accounts)                        | **GET** /v1/accounts                                  |
| _AccountsApi_    | [**update_account**](docs/AccountsApi.md#update_account)                      | **PUT** /v1/accounts/{accountIndex}                   |
| _ConfigApi_      | [**get_config**](docs/ConfigApi.md#get_config)                                | **GET** /v1/config                                    |
| _FilesApi_       | [**get_scanned_file_info**](docs/FilesApi.md#get_scanned_file_info)           | **GET** /v1/scanned-files/{scannedFileJobId}          |
| _FilesApi_       | [**list_scanned_files**](docs/FilesApi.md#list_scanned_files)                 | **GET** /v1/scanned-files/                            |
| _FilesApi_       | [**start_file_scan**](docs/FilesApi.md#start_file_scan)                       | **POST** /v1/nodes/{nodeId}/file/scan                 |
| _NodesApi_       | [**create_node**](docs/NodesApi.md#create_node)                               | **POST** /v1/nodes                                    |
| _NodesApi_       | [**delete_node**](docs/NodesApi.md#delete_node)                               | **DELETE** /v1/nodes/{nodeId}                         |
| _NodesApi_       | [**get_detailed_node_info**](docs/NodesApi.md#get_detailed_node_info)         | **GET** /v1/nodes/{nodeId}                            |
| _NodesApi_       | [**init_nodes**](docs/NodesApi.md#init_nodes)                                 | **POST** /v1/nodes/init                               |
| _NodesApi_       | [**list_node_children**](docs/NodesApi.md#list_node_children)                 | **GET** /v1/nodes/{nodeId}/children                   |
| _NodesApi_       | [**list_root_node_children**](docs/NodesApi.md#list_root_node_children)       | **GET** /v1/nodes                                     |
| _NodesApi_       | [**move_node**](docs/NodesApi.md#move_node)                                   | **POST** /v1/nodes/{nodeId}/move                      |
| _NodesApi_       | [**permanently_delete_node**](docs/NodesApi.md#permanently_delete_node)       | **DELETE** /v1/nodes/{nodeId}/remove/{nodeIdToRemove} |
| _NodesApi_       | [**restore_node_from_trashbin**](docs/NodesApi.md#restore_node_from_trashbin) | **POST** /v1/nodes/{nodeId}/restore/{nodeIdToRestore} |
| _NodesApi_       | [**update_node**](docs/NodesApi.md#update_node)                               | **PATCH** /v1/nodes/{nodeId}                          |
| _ProfileDataApi_ | [**query_profile_data**](docs/ProfileDataApi.md#query_profile_data)           | **GET** /v1/nodes/{nodeId}/profile-data               |
| _ProfileDataApi_ | [**update_profile_data**](docs/ProfileDataApi.md#update_profile_data)         | **PATCH** /v1/nodes/{nodeId}/profile-data             |
| _WellKnownApi_   | [**get_well_known_jwks**](docs/WellKnownApi.md#get_well_known_jwks)           | **GET** /.well-known/jwks.json                        |

## Documentation For Models

- [AccountDto](docs/AccountDto.md)
- [AwsCredentialExchangeOperationOK](docs/AwsCredentialExchangeOperationOK.md)
- [ConsumerMetadataDto](docs/ConsumerMetadataDto.md)
- [CorsAwsCredentialExchangeOK](docs/CorsAwsCredentialExchangeOK.md)
- [CorsDeleteAccountOK](docs/CorsDeleteAccountOK.md)
- [CorsDeleteNodeOK](docs/CorsDeleteNodeOK.md)
- [CorsGetConfigOK](docs/CorsGetConfigOK.md)
- [CorsGetScannedFileInfoOK](docs/CorsGetScannedFileInfoOK.md)
- [CorsGetWellKnownJwksOK](docs/CorsGetWellKnownJwksOK.md)
- [CorsInitNodesOK](docs/CorsInitNodesOK.md)
- [CorsListAccountsOK](docs/CorsListAccountsOK.md)
- [CorsListNodeChildrenOK](docs/CorsListNodeChildrenOK.md)
- [CorsListRootNodeChildrenOK](docs/CorsListRootNodeChildrenOK.md)
- [CorsListScannedFilesOK](docs/CorsListScannedFilesOK.md)
- [CorsMoveNodeOK](docs/CorsMoveNodeOK.md)
- [CorsPermanentlyDeleteNodeOK](docs/CorsPermanentlyDeleteNodeOK.md)
- [CorsRestoreNodeFromTrashbinOK](docs/CorsRestoreNodeFromTrashbinOK.md)
- [CorsStartFileScanOK](docs/CorsStartFileScanOK.md)
- [CorsUpdateProfileDataOK](docs/CorsUpdateProfileDataOK.md)
- [CreateAccountInput](docs/CreateAccountInput.md)
- [CreateAccountOK](docs/CreateAccountOK.md)
- [CreateNodeInput](docs/CreateNodeInput.md)
- [CreateNodeOK](docs/CreateNodeOK.md)
- [DeleteAccountDto](docs/DeleteAccountDto.md)
- [DeleteNodeDto](docs/DeleteNodeDto.md)
- [EdekInfo](docs/EdekInfo.md)
- [GetConfigOK](docs/GetConfigOK.md)
- [GetDetailedNodeInfoOK](docs/GetDetailedNodeInfoOK.md)
- [GetScannedFileInfoOK](docs/GetScannedFileInfoOK.md)
- [InitNodesOK](docs/InitNodesOK.md)
- [InvalidParameterError](docs/InvalidParameterError.md)
- [InvalidParameterErrorDetailsInner](docs/InvalidParameterErrorDetailsInner.md)
- [JsonWebKeyDto](docs/JsonWebKeyDto.md)
- [JsonWebKeySetDto](docs/JsonWebKeySetDto.md)
- [ListAccountsDto](docs/ListAccountsDto.md)
- [ListNodeChildrenOK](docs/ListNodeChildrenOK.md)
- [ListRootNodeChildrenOK](docs/ListRootNodeChildrenOK.md)
- [ListScannedFilesOK](docs/ListScannedFilesOK.md)
- [ListScannedFilesOKScannedFilesInner](docs/ListScannedFilesOKScannedFilesInner.md)
- [MoveNodeDto](docs/MoveNodeDto.md)
- [MoveNodeInput](docs/MoveNodeInput.md)
- [NodeDto](docs/NodeDto.md)
- [NodeStatus](docs/NodeStatus.md)
- [NodeType](docs/NodeType.md)
- [NotFoundError](docs/NotFoundError.md)
- [QueryProfileDataOK](docs/QueryProfileDataOK.md)
- [RestoreNodeFromTrashbin](docs/RestoreNodeFromTrashbin.md)
- [StartFileScanInput](docs/StartFileScanInput.md)
- [StartFileScanOK](docs/StartFileScanOK.md)
- [UnexpectedError](docs/UnexpectedError.md)
- [UpdateAccountDto](docs/UpdateAccountDto.md)
- [UpdateAccountInput](docs/UpdateAccountInput.md)
- [UpdateNodeInput](docs/UpdateNodeInput.md)
- [UpdateProfileDataInput](docs/UpdateProfileDataInput.md)
- [UpdateProfileDataOK](docs/UpdateProfileDataOK.md)

<a id="documentation-for-authorization"></a>

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="AwsSigV4"></a>

### AwsSigV4

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

<a id="ApiKey"></a>

### ApiKey

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header

<a id="bearerAuth"></a>

### bearerAuth

- **Type**: Bearer authentication (JWT)

<a id="ConsumerTokenAuth"></a>

### ConsumerTokenAuth

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header

<a id="UserTokenAuth"></a>

### UserTokenAuth

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header

<a id="ProjectTokenAuth"></a>

### ProjectTokenAuth

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header

## Author

info@affinidi.com
