# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictStr, conint, constr, validator

from typing import Optional

from affinidi_tdk_vault_data_manager_client.models.create_node_input import CreateNodeInput
from affinidi_tdk_vault_data_manager_client.models.create_node_ok import CreateNodeOK
from affinidi_tdk_vault_data_manager_client.models.delete_node_dto import DeleteNodeDto
from affinidi_tdk_vault_data_manager_client.models.get_detailed_node_info_ok import GetDetailedNodeInfoOK
from affinidi_tdk_vault_data_manager_client.models.init_nodes_ok import InitNodesOK
from affinidi_tdk_vault_data_manager_client.models.list_node_children_ok import ListNodeChildrenOK
from affinidi_tdk_vault_data_manager_client.models.list_root_node_children_ok import ListRootNodeChildrenOK
from affinidi_tdk_vault_data_manager_client.models.move_node_dto import MoveNodeDto
from affinidi_tdk_vault_data_manager_client.models.move_node_input import MoveNodeInput
from affinidi_tdk_vault_data_manager_client.models.node_dto import NodeDto
from affinidi_tdk_vault_data_manager_client.models.restore_node_from_trashbin import RestoreNodeFromTrashbin
from affinidi_tdk_vault_data_manager_client.models.update_node_input import UpdateNodeInput

from affinidi_tdk_vault_data_manager_client.api_client import ApiClient
from affinidi_tdk_vault_data_manager_client.api_response import ApiResponse
from affinidi_tdk_vault_data_manager_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class NodesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_node(self, create_node_input : Annotated[CreateNodeInput, Field(..., description="CreateNode")], **kwargs) -> CreateNodeOK:  # noqa: E501
        """create_node  # noqa: E501

        creates node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_node(create_node_input, async_req=True)
        >>> result = thread.get()

        :param create_node_input: CreateNode (required)
        :type create_node_input: CreateNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateNodeOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_node_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_node_with_http_info(create_node_input, **kwargs)  # noqa: E501

    @validate_arguments
    def create_node_with_http_info(self, create_node_input : Annotated[CreateNodeInput, Field(..., description="CreateNode")], **kwargs) -> ApiResponse:  # noqa: E501
        """create_node  # noqa: E501

        creates node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_node_with_http_info(create_node_input, async_req=True)
        >>> result = thread.get()

        :param create_node_input: CreateNode (required)
        :type create_node_input: CreateNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateNodeOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'create_node_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_node_input'] is not None:
            _body_params = _params['create_node_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "CreateNodeOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_node(self, node_id : constr(strict=True), **kwargs) -> DeleteNodeDto:  # noqa: E501
        """delete_node  # noqa: E501

        Mark a node and any attached files for deletion. If the node is a folder, perform the same action for all its children if the profile type is PROFILE, VC_ROOT, or VC. For other node types, move them to the TRASH_BIN node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_node(node_id, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeleteNodeDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_node_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_node_with_http_info(node_id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_node_with_http_info(self, node_id : constr(strict=True), **kwargs) -> ApiResponse:  # noqa: E501
        """delete_node  # noqa: E501

        Mark a node and any attached files for deletion. If the node is a folder, perform the same action for all its children if the profile type is PROFILE, VC_ROOT, or VC. For other node types, move them to the TRASH_BIN node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_node_with_http_info(node_id, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeleteNodeDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_node" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '202': "DeleteNodeDto",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_detailed_node_info(self, node_id : constr(strict=True), dek : Annotated[Optional[StrictStr], Field(description="A base64url encoded data encryption key, encrypted using VFS public key. getUrl will not be returned if dek is not provided")] = None, **kwargs) -> GetDetailedNodeInfoOK:  # noqa: E501
        """get_detailed_node_info  # noqa: E501

        Gets detailed information about the node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_detailed_node_info(node_id, dek, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param dek: A base64url encoded data encryption key, encrypted using VFS public key. getUrl will not be returned if dek is not provided
        :type dek: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetDetailedNodeInfoOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_detailed_node_info_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.get_detailed_node_info_with_http_info(node_id, dek, **kwargs)  # noqa: E501

    @validate_arguments
    def get_detailed_node_info_with_http_info(self, node_id : constr(strict=True), dek : Annotated[Optional[StrictStr], Field(description="A base64url encoded data encryption key, encrypted using VFS public key. getUrl will not be returned if dek is not provided")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """get_detailed_node_info  # noqa: E501

        Gets detailed information about the node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_detailed_node_info_with_http_info(node_id, dek, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param dek: A base64url encoded data encryption key, encrypted using VFS public key. getUrl will not be returned if dek is not provided
        :type dek: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetDetailedNodeInfoOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'dek'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_detailed_node_info" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        if _params.get('dek') is not None:  # noqa: E501
            _query_params.append(('dek', _params['dek']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "GetDetailedNodeInfoOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def init_nodes(self, **kwargs) -> InitNodesOK:  # noqa: E501
        """(Deprecated) init_nodes  # noqa: E501

        Initialize root node, and TRASH_BIN  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InitNodesOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the init_nodes_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.init_nodes_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def init_nodes_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """(Deprecated) init_nodes  # noqa: E501

        Initialize root node, and TRASH_BIN  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.init_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InitNodesOK, status_code(int), headers(HTTPHeaderDict))
        """

        warnings.warn("POST /v1/nodes/init is deprecated.", DeprecationWarning)

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method init_nodes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "InitNodesOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/init', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_node_children(self, node_id : Annotated[StrictStr, Field(..., description="Description for nodeId.")], limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Maximum number of records to fetch in a list")] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, **kwargs) -> ListNodeChildrenOK:  # noqa: E501
        """list_node_children  # noqa: E501

        lists children of the node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_node_children(node_id, limit, exclusive_start_key, async_req=True)
        >>> result = thread.get()

        :param node_id: Description for nodeId. (required)
        :type node_id: str
        :param limit: Maximum number of records to fetch in a list
        :type limit: int
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListNodeChildrenOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_node_children_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_node_children_with_http_info(node_id, limit, exclusive_start_key, **kwargs)  # noqa: E501

    @validate_arguments
    def list_node_children_with_http_info(self, node_id : Annotated[StrictStr, Field(..., description="Description for nodeId.")], limit : Annotated[Optional[conint(strict=True, le=100, ge=1)], Field(description="Maximum number of records to fetch in a list")] = None, exclusive_start_key : Annotated[Optional[constr(strict=True, max_length=3000)], Field(description="exclusiveStartKey for retrieving the next batch of data.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """list_node_children  # noqa: E501

        lists children of the node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_node_children_with_http_info(node_id, limit, exclusive_start_key, async_req=True)
        >>> result = thread.get()

        :param node_id: Description for nodeId. (required)
        :type node_id: str
        :param limit: Maximum number of records to fetch in a list
        :type limit: int
        :param exclusive_start_key: exclusiveStartKey for retrieving the next batch of data.
        :type exclusive_start_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListNodeChildrenOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'limit',
            'exclusive_start_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_node_children" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('exclusive_start_key') is not None:  # noqa: E501
            _query_params.append(('exclusiveStartKey', _params['exclusive_start_key']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "ListNodeChildrenOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/children', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_root_node_children(self, **kwargs) -> ListRootNodeChildrenOK:  # noqa: E501
        """list_root_node_children  # noqa: E501

        lists children of the root node for the consumer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_root_node_children(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListRootNodeChildrenOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_root_node_children_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_root_node_children_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    def list_root_node_children_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """list_root_node_children  # noqa: E501

        lists children of the root node for the consumer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_root_node_children_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListRootNodeChildrenOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_root_node_children" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "ListRootNodeChildrenOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def move_node(self, node_id : constr(strict=True), move_node_input : Annotated[MoveNodeInput, Field(..., description="MoveNode")], **kwargs) -> MoveNodeDto:  # noqa: E501
        """move_node  # noqa: E501

        Moves a node from source to destination along with the hierarchy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_node(node_id, move_node_input, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param move_node_input: MoveNode (required)
        :type move_node_input: MoveNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MoveNodeDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the move_node_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.move_node_with_http_info(node_id, move_node_input, **kwargs)  # noqa: E501

    @validate_arguments
    def move_node_with_http_info(self, node_id : constr(strict=True), move_node_input : Annotated[MoveNodeInput, Field(..., description="MoveNode")], **kwargs) -> ApiResponse:  # noqa: E501
        """move_node  # noqa: E501

        Moves a node from source to destination along with the hierarchy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.move_node_with_http_info(node_id, move_node_input, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param move_node_input: MoveNode (required)
        :type move_node_input: MoveNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MoveNodeDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'move_node_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_node" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['move_node_input'] is not None:
            _body_params = _params['move_node_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '202': "MoveNodeDto",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/move', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def permanently_delete_node(self, node_id : Annotated[constr(strict=True), Field(..., description="nodeId of the TRASH_BIN")], node_id_to_remove : Annotated[constr(strict=True), Field(..., description="nodeId of the node to be deleted from TRASH_BIN")], **kwargs) -> None:  # noqa: E501
        """permanently_delete_node  # noqa: E501

        Permanently delete a node from TRASH_BIN, if the node is not in the TRASH_BIN it cannot delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permanently_delete_node(node_id, node_id_to_remove, async_req=True)
        >>> result = thread.get()

        :param node_id: nodeId of the TRASH_BIN (required)
        :type node_id: str
        :param node_id_to_remove: nodeId of the node to be deleted from TRASH_BIN (required)
        :type node_id_to_remove: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the permanently_delete_node_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.permanently_delete_node_with_http_info(node_id, node_id_to_remove, **kwargs)  # noqa: E501

    @validate_arguments
    def permanently_delete_node_with_http_info(self, node_id : Annotated[constr(strict=True), Field(..., description="nodeId of the TRASH_BIN")], node_id_to_remove : Annotated[constr(strict=True), Field(..., description="nodeId of the node to be deleted from TRASH_BIN")], **kwargs) -> ApiResponse:  # noqa: E501
        """permanently_delete_node  # noqa: E501

        Permanently delete a node from TRASH_BIN, if the node is not in the TRASH_BIN it cannot delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.permanently_delete_node_with_http_info(node_id, node_id_to_remove, async_req=True)
        >>> result = thread.get()

        :param node_id: nodeId of the TRASH_BIN (required)
        :type node_id: str
        :param node_id_to_remove: nodeId of the node to be deleted from TRASH_BIN (required)
        :type node_id_to_remove: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'node_id',
            'node_id_to_remove'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permanently_delete_node" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']

        if _params['node_id_to_remove'] is not None:
            _path_params['nodeIdToRemove'] = _params['node_id_to_remove']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/remove/{nodeIdToRemove}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def restore_node_from_trashbin(self, node_id : Annotated[constr(strict=True), Field(..., description="nodeId of the TRASH_BIN")], node_id_to_restore : Annotated[constr(strict=True), Field(..., description="nodeId of the node to be restored from TRASH_BIN")], restore_node_from_trashbin : Annotated[RestoreNodeFromTrashbin, Field(..., description="RestoreNodeFromTrashbin")], **kwargs) -> MoveNodeDto:  # noqa: E501
        """restore_node_from_trashbin  # noqa: E501

        Restore node marked for deletion from TRASH_BIN  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_node_from_trashbin(node_id, node_id_to_restore, restore_node_from_trashbin, async_req=True)
        >>> result = thread.get()

        :param node_id: nodeId of the TRASH_BIN (required)
        :type node_id: str
        :param node_id_to_restore: nodeId of the node to be restored from TRASH_BIN (required)
        :type node_id_to_restore: str
        :param restore_node_from_trashbin: RestoreNodeFromTrashbin (required)
        :type restore_node_from_trashbin: RestoreNodeFromTrashbin
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MoveNodeDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the restore_node_from_trashbin_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.restore_node_from_trashbin_with_http_info(node_id, node_id_to_restore, restore_node_from_trashbin, **kwargs)  # noqa: E501

    @validate_arguments
    def restore_node_from_trashbin_with_http_info(self, node_id : Annotated[constr(strict=True), Field(..., description="nodeId of the TRASH_BIN")], node_id_to_restore : Annotated[constr(strict=True), Field(..., description="nodeId of the node to be restored from TRASH_BIN")], restore_node_from_trashbin : Annotated[RestoreNodeFromTrashbin, Field(..., description="RestoreNodeFromTrashbin")], **kwargs) -> ApiResponse:  # noqa: E501
        """restore_node_from_trashbin  # noqa: E501

        Restore node marked for deletion from TRASH_BIN  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.restore_node_from_trashbin_with_http_info(node_id, node_id_to_restore, restore_node_from_trashbin, async_req=True)
        >>> result = thread.get()

        :param node_id: nodeId of the TRASH_BIN (required)
        :type node_id: str
        :param node_id_to_restore: nodeId of the node to be restored from TRASH_BIN (required)
        :type node_id_to_restore: str
        :param restore_node_from_trashbin: RestoreNodeFromTrashbin (required)
        :type restore_node_from_trashbin: RestoreNodeFromTrashbin
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MoveNodeDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'node_id_to_restore',
            'restore_node_from_trashbin'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restore_node_from_trashbin" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']

        if _params['node_id_to_restore'] is not None:
            _path_params['nodeIdToRestore'] = _params['node_id_to_restore']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['restore_node_from_trashbin'] is not None:
            _body_params = _params['restore_node_from_trashbin']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '202': "MoveNodeDto",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/restore/{nodeIdToRestore}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_node(self, node_id : Annotated[StrictStr, Field(..., description="Description for nodeId.")], update_node_input : Annotated[UpdateNodeInput, Field(..., description="UpdateNodeInput")], **kwargs) -> NodeDto:  # noqa: E501
        """update_node  # noqa: E501

        Updates a node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_node(node_id, update_node_input, async_req=True)
        >>> result = thread.get()

        :param node_id: Description for nodeId. (required)
        :type node_id: str
        :param update_node_input: UpdateNodeInput (required)
        :type update_node_input: UpdateNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: NodeDto
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_node_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_node_with_http_info(node_id, update_node_input, **kwargs)  # noqa: E501

    @validate_arguments
    def update_node_with_http_info(self, node_id : Annotated[StrictStr, Field(..., description="Description for nodeId.")], update_node_input : Annotated[UpdateNodeInput, Field(..., description="UpdateNodeInput")], **kwargs) -> ApiResponse:  # noqa: E501
        """update_node  # noqa: E501

        Updates a node  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_node_with_http_info(node_id, update_node_input, async_req=True)
        >>> result = thread.get()

        :param node_id: Description for nodeId. (required)
        :type node_id: str
        :param update_node_input: UpdateNodeInput (required)
        :type update_node_input: UpdateNodeInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(NodeDto, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'update_node_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_node_input'] is not None:
            _body_params = _params['update_node_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "NodeDto",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
