# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictStr, constr, validator

from typing import Optional

from affinidi_tdk_vault_data_manager_client.models.query_profile_data_ok import QueryProfileDataOK
from affinidi_tdk_vault_data_manager_client.models.update_profile_data_input import UpdateProfileDataInput
from affinidi_tdk_vault_data_manager_client.models.update_profile_data_ok import UpdateProfileDataOK

from affinidi_tdk_vault_data_manager_client.api_client import ApiClient
from affinidi_tdk_vault_data_manager_client.api_response import ApiResponse
from affinidi_tdk_vault_data_manager_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProfileDataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def query_profile_data(self, node_id : Annotated[StrictStr, Field(..., description="the nodeId of the node being operated on")], dek : Annotated[StrictStr, Field(..., description="A base64url encoded data encryption key, encrypted using VFS public")], query : Annotated[Optional[StrictStr], Field(description="data query, TBD maybe encode it with base64 to make it url friendly?")] = None, **kwargs) -> QueryProfileDataOK:  # noqa: E501
        """query_profile_data  # noqa: E501

        Retrieves information from a profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_profile_data(node_id, dek, query, async_req=True)
        >>> result = thread.get()

        :param node_id: the nodeId of the node being operated on (required)
        :type node_id: str
        :param dek: A base64url encoded data encryption key, encrypted using VFS public (required)
        :type dek: str
        :param query: data query, TBD maybe encode it with base64 to make it url friendly?
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: QueryProfileDataOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the query_profile_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.query_profile_data_with_http_info(node_id, dek, query, **kwargs)  # noqa: E501

    @validate_arguments
    def query_profile_data_with_http_info(self, node_id : Annotated[StrictStr, Field(..., description="the nodeId of the node being operated on")], dek : Annotated[StrictStr, Field(..., description="A base64url encoded data encryption key, encrypted using VFS public")], query : Annotated[Optional[StrictStr], Field(description="data query, TBD maybe encode it with base64 to make it url friendly?")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """query_profile_data  # noqa: E501

        Retrieves information from a profile.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.query_profile_data_with_http_info(node_id, dek, query, async_req=True)
        >>> result = thread.get()

        :param node_id: the nodeId of the node being operated on (required)
        :type node_id: str
        :param dek: A base64url encoded data encryption key, encrypted using VFS public (required)
        :type dek: str
        :param query: data query, TBD maybe encode it with base64 to make it url friendly?
        :type query: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(QueryProfileDataOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'dek',
            'query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_profile_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        if _params.get('query') is not None:  # noqa: E501
            _query_params.append(('query', _params['query']))

        if _params.get('dek') is not None:  # noqa: E501
            _query_params.append(('dek', _params['dek']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "QueryProfileDataOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/profile-data', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_profile_data(self, node_id : constr(strict=True), update_profile_data_input : Annotated[UpdateProfileDataInput, Field(..., description="Updates the schema with the given data")], **kwargs) -> UpdateProfileDataOK:  # noqa: E501
        """update_profile_data  # noqa: E501

        Updates the profile with the given data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_profile_data(node_id, update_profile_data_input, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param update_profile_data_input: Updates the schema with the given data (required)
        :type update_profile_data_input: UpdateProfileDataInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpdateProfileDataOK
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_profile_data_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_profile_data_with_http_info(node_id, update_profile_data_input, **kwargs)  # noqa: E501

    @validate_arguments
    def update_profile_data_with_http_info(self, node_id : constr(strict=True), update_profile_data_input : Annotated[UpdateProfileDataInput, Field(..., description="Updates the schema with the given data")], **kwargs) -> ApiResponse:  # noqa: E501
        """update_profile_data  # noqa: E501

        Updates the profile with the given data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_profile_data_with_http_info(node_id, update_profile_data_input, async_req=True)
        >>> result = thread.get()

        :param node_id: (required)
        :type node_id: str
        :param update_profile_data_input: Updates the schema with the given data (required)
        :type update_profile_data_input: UpdateProfileDataInput
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpdateProfileDataOK, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'node_id',
            'update_profile_data_input'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_profile_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['node_id'] is not None:
            _path_params['nodeId'] = _params['node_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_profile_data_input'] is not None:
            _body_params = _params['update_profile_data_input']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ConsumerTokenAuth']  # noqa: E501

        _response_types_map = {
            '200': "UpdateProfileDataOK",
            '400': "InvalidParameterError",
        }

        return self.api_client.call_api(
            '/v1/nodes/{nodeId}/profile-data', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
