# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from affinidi_tdk_vault_data_manager_client.models.node_status import NodeStatus
from affinidi_tdk_vault_data_manager_client.models.node_type import NodeType

class ConsumerMetadataDto(BaseModel):
    """
    ConsumerMetadataDto
    """
    node_id: StrictStr = Field(default=..., alias="nodeId")
    status: NodeStatus = Field(...)
    file_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="fileCount")
    folder_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="folderCount")
    profile_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="profileCount")
    name: StrictStr = Field(...)
    consumer_id: StrictStr = Field(default=..., alias="consumerId")
    created_at: StrictStr = Field(default=..., alias="createdAt", description="creation date/time")
    modified_at: StrictStr = Field(default=..., alias="modifiedAt", description="modification date/time")
    created_by: StrictStr = Field(default=..., alias="createdBy", description="Identifier of the user who created")
    modified_by: StrictStr = Field(default=..., alias="modifiedBy", description="Identifier of the user who last updated")
    description: Optional[StrictStr] = Field(default=None, description="Description of the node")
    type: NodeType = Field(...)
    consumed_file_storage: Union[StrictFloat, StrictInt] = Field(default=..., alias="consumedFileStorage", description="Tracks the amount of bytes used by the stored data.")
    __properties = ["nodeId", "status", "fileCount", "folderCount", "profileCount", "name", "consumerId", "createdAt", "modifiedAt", "createdBy", "modifiedBy", "description", "type", "consumedFileStorage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ConsumerMetadataDto:
        """Create an instance of ConsumerMetadataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ConsumerMetadataDto:
        """Create an instance of ConsumerMetadataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ConsumerMetadataDto.parse_obj(obj)

        _obj = ConsumerMetadataDto.parse_obj({
            "node_id": obj.get("nodeId"),
            "status": obj.get("status"),
            "file_count": obj.get("fileCount"),
            "folder_count": obj.get("folderCount"),
            "profile_count": obj.get("profileCount"),
            "name": obj.get("name"),
            "consumer_id": obj.get("consumerId"),
            "created_at": obj.get("createdAt"),
            "modified_at": obj.get("modifiedAt"),
            "created_by": obj.get("createdBy"),
            "modified_by": obj.get("modifiedBy"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "consumed_file_storage": obj.get("consumedFileStorage")
        })
        return _obj


