# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, constr, validator

class CreateAccountInput(BaseModel):
    """
    CreateAccountInput
    """
    account_index: Union[StrictFloat, StrictInt] = Field(default=..., alias="accountIndex", description="number that is used for profile DID derivation")
    account_did: constr(strict=True) = Field(default=..., alias="accountDid", description="DID that is associated with the account number")
    did_proof: StrictStr = Field(default=..., alias="didProof", description="JWT that proves ownership of profile DID by requester")
    alias: Optional[StrictStr] = Field(default=None, description="Alias of account")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata of account")
    description: Optional[StrictStr] = Field(default=None, description="Description of account")
    __properties = ["accountIndex", "accountDid", "didProof", "alias", "metadata", "description"]

    @validator('account_did')
    def account_did_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^did:.*$", value):
            raise ValueError(r"must validate the regular expression /^did:.*$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateAccountInput:
        """Create an instance of CreateAccountInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateAccountInput:
        """Create an instance of CreateAccountInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateAccountInput.parse_obj(obj)

        _obj = CreateAccountInput.parse_obj({
            "account_index": obj.get("accountIndex"),
            "account_did": obj.get("accountDid"),
            "did_proof": obj.get("didProof"),
            "alias": obj.get("alias"),
            "metadata": obj.get("metadata"),
            "description": obj.get("description")
        })
        return _obj


