# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from affinidi_tdk_vault_data_manager_client.models.edek_info import EdekInfo
from affinidi_tdk_vault_data_manager_client.models.node_type import NodeType

class CreateNodeInput(BaseModel):
    """
    CreateNodeInput
    """
    name: constr(strict=True, max_length=128) = Field(default=..., description="Name of the item")
    type: NodeType = Field(...)
    description: Optional[StrictStr] = Field(default=None, description="description of profile if creating a new profile")
    parent_node_id: Optional[StrictStr] = Field(default=None, alias="parentNodeId", description="parent node id, if not provided then root element is used")
    edek_info: Optional[EdekInfo] = Field(default=None, alias="edekInfo")
    dek: Optional[StrictStr] = Field(default=None, description="A base64 encoded data encryption key, encrypted using VFS public key, required for node types [FILE, PROFILE]")
    metadata: Optional[StrictStr] = Field(default=None, description="metadata of the node in stringified json format")
    __properties = ["name", "type", "description", "parentNodeId", "edekInfo", "dek", "metadata"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateNodeInput:
        """Create an instance of CreateNodeInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of edek_info
        if self.edek_info:
            _dict['edekInfo'] = self.edek_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateNodeInput:
        """Create an instance of CreateNodeInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateNodeInput.parse_obj(obj)

        _obj = CreateNodeInput.parse_obj({
            "name": obj.get("name"),
            "type": obj.get("type"),
            "description": obj.get("description"),
            "parent_node_id": obj.get("parentNodeId"),
            "edek_info": EdekInfo.from_dict(obj.get("edekInfo")) if obj.get("edekInfo") is not None else None,
            "dek": obj.get("dek"),
            "metadata": obj.get("metadata")
        })
        return _obj


