# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from affinidi_tdk_vault_data_manager_client.models.edek_info import EdekInfo
from affinidi_tdk_vault_data_manager_client.models.node_status import NodeStatus
from affinidi_tdk_vault_data_manager_client.models.node_type import NodeType

class GetDetailedNodeInfoOK(BaseModel):
    """
    GetDetailedNodeInfoOK
    """
    node_id: StrictStr = Field(default=..., alias="nodeId", description="A unique identifier of current node")
    status: NodeStatus = Field(...)
    file_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="fileCount", description="number of files in current node")
    profile_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="profileCount", description="number of profiles in current node")
    folder_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="folderCount", description="number of folders in current node")
    vc_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="vcCount", description="number of vcCount in current node")
    name: StrictStr = Field(default=..., description="display name of current node")
    consumer_id: StrictStr = Field(default=..., alias="consumerId", description="unique identifier for consumer")
    parent_node_id: StrictStr = Field(default=..., alias="parentNodeId", description="parent node path")
    profile_id: StrictStr = Field(default=..., alias="profileId", description="A unique identifier of profile, under which current node is created")
    created_at: StrictStr = Field(default=..., alias="createdAt", description="creation date/time of the node")
    modified_at: StrictStr = Field(default=..., alias="modifiedAt", description="modification date/time of the node")
    created_by: StrictStr = Field(default=..., alias="createdBy", description="Identifier of the user who created the node")
    modified_by: StrictStr = Field(default=..., alias="modifiedBy", description="Identifier of the user who last updated the node")
    description: Optional[StrictStr] = Field(default=None, description="Description of the node")
    type: NodeType = Field(...)
    link: Optional[StrictStr] = Field(default=None, description="id of the file, used for FILE node only")
    var_schema: Optional[StrictStr] = Field(default=None, alias="schema", description="name of the schema, used for PROFILE node only")
    consumed_file_storage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="consumedFileStorage", description="amount of bytes used by the stored data, used for ROOT_ELEMENT only for now")
    edek_info: Optional[EdekInfo] = Field(default=None, alias="edekInfo")
    metadata: Optional[StrictStr] = Field(default=None, description="A JSON string format containing metadata of the node")
    get_url: Optional[StrictStr] = Field(default=None, alias="getUrl")
    __properties = ["nodeId", "status", "fileCount", "profileCount", "folderCount", "vcCount", "name", "consumerId", "parentNodeId", "profileId", "createdAt", "modifiedAt", "createdBy", "modifiedBy", "description", "type", "link", "schema", "consumedFileStorage", "edekInfo", "metadata", "getUrl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GetDetailedNodeInfoOK:
        """Create an instance of GetDetailedNodeInfoOK from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of edek_info
        if self.edek_info:
            _dict['edekInfo'] = self.edek_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetDetailedNodeInfoOK:
        """Create an instance of GetDetailedNodeInfoOK from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return GetDetailedNodeInfoOK.parse_obj(obj)

        _obj = GetDetailedNodeInfoOK.parse_obj({
            "node_id": obj.get("nodeId"),
            "status": obj.get("status"),
            "file_count": obj.get("fileCount"),
            "profile_count": obj.get("profileCount"),
            "folder_count": obj.get("folderCount"),
            "vc_count": obj.get("vcCount"),
            "name": obj.get("name"),
            "consumer_id": obj.get("consumerId"),
            "parent_node_id": obj.get("parentNodeId"),
            "profile_id": obj.get("profileId"),
            "created_at": obj.get("createdAt"),
            "modified_at": obj.get("modifiedAt"),
            "created_by": obj.get("createdBy"),
            "modified_by": obj.get("modifiedBy"),
            "description": obj.get("description"),
            "type": obj.get("type"),
            "link": obj.get("link"),
            "var_schema": obj.get("schema"),
            "consumed_file_storage": obj.get("consumedFileStorage"),
            "edek_info": EdekInfo.from_dict(obj.get("edekInfo")) if obj.get("edekInfo") is not None else None,
            "metadata": obj.get("metadata"),
            "get_url": obj.get("getUrl")
        })
        return _obj


