# coding: utf-8

"""
    VaultFileSystem

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr

class UpdateAccountInput(BaseModel):
    """
    UpdateAccountInput
    """
    name: StrictStr = Field(default=..., description="Name of the account")
    description: StrictStr = Field(default=..., description="Description of the account")
    alias: Optional[StrictStr] = Field(default=None, description="Alias of the account")
    did_proof: StrictStr = Field(default=..., alias="didProof", description="JWT that proves ownership of profile DID by requester")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Description of metadata")
    account_did: StrictStr = Field(default=..., alias="accountDid", description="DID that is associated with the account number")
    __properties = ["name", "description", "alias", "didProof", "metadata", "accountDid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UpdateAccountInput:
        """Create an instance of UpdateAccountInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateAccountInput:
        """Create an instance of UpdateAccountInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UpdateAccountInput.parse_obj(obj)

        _obj = UpdateAccountInput.parse_obj({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "alias": obj.get("alias"),
            "did_proof": obj.get("didProof"),
            "metadata": obj.get("metadata"),
            "account_did": obj.get("accountDid")
        })
        return _obj


