"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyEcsConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// ${FileBase.PROJEN_MARKER}
const ec2 = require("aws-cdk-lib/aws-ec2");
const ecs = require("aws-cdk-lib/aws-ecs");
const ecs_patterns = require("aws-cdk-lib/aws-ecs-patterns");
const constructs_1 = require("constructs");
class MyEcsConstruct extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'MyVpc', {
            maxAzs: props.numberOfAzs,
        });
        const cluster = new ecs.Cluster(this, 'MyCluster', {
            vpc: vpc,
        });
        new ecs_patterns.ApplicationLoadBalancedFargateService(this, 'MyFargateService', {
            cluster: cluster,
            cpu: 512,
            desiredCount: 6,
            taskImageOptions: {
                image: ecs.ContainerImage.fromAsset(props.dockerfileAsset),
            },
            memoryLimitMiB: 2048,
            publicLoadBalancer: true,
        });
    }
}
exports.MyEcsConstruct = MyEcsConstruct;
_a = JSII_RTTI_SYMBOL_1;
MyEcsConstruct[_a] = { fqn: "ecs-package.MyEcsConstruct", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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