# vrt_lss_studio
LSS Studio Tool API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.8.168904
- Package version: 3.8.168904
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_studio
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_studio
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import vrt_lss_studio
from vrt_lss_studio.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.veeroute.tech/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_lss_studio.Configuration(
    host = "https://api.veeroute.tech/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_lss_studio.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_lss_studio.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = vrt_lss_studio.ReportsApi(api_client)
    user_report_filter = vrt_lss_studio.UserReportFilter() # UserReportFilter | Report filter.

    try:
        # Reporting.
        api_response = api_instance.generate_report(user_report_filter)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ReportsApi->generate_report: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ReportsApi* | [**generate_report**](docs/ReportsApi.md#generate_report) | **POST** /logistics/report | Reporting.
*StatisticsApi* | [**generate_statistics**](docs/StatisticsApi.md#generate_statistics) | **POST** /logistics/statistics | User statistics for the period.
*SystemApi* | [**check**](docs/SystemApi.md#check) | **GET** /logistics/check | Checking the service availability.
*SystemApi* | [**version**](docs/SystemApi.md#version) | **GET** /logistics/version | Getting the service version.


## Documentation For Models

 - [CheckResult](docs/CheckResult.md)
 - [DateStatistics](docs/DateStatistics.md)
 - [DateWindow](docs/DateWindow.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse400Validations](docs/InlineResponse400Validations.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse403](docs/InlineResponse403.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [MethodName](docs/MethodName.md)
 - [MethodStatistics](docs/MethodStatistics.md)
 - [ServiceName](docs/ServiceName.md)
 - [ServiceStatistics](docs/ServiceStatistics.md)
 - [TraceData](docs/TraceData.md)
 - [UserReportFilter](docs/UserReportFilter.md)
 - [UserStatistics](docs/UserStatistics.md)
 - [UserStatisticsFilter](docs/UserStatisticsFilter.md)
 - [VersionResult](docs/VersionResult.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


