# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceAccountArgs', 'ServiceAccount']

@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingestion_policy: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ServiceAccount resource.
        :param pulumi.Input[str] identifier: The unique identifier of the service account to create. Must have the prefix `sa::`.
        :param pulumi.Input[bool] active: Whether or not the service account is active.
        :param pulumi.Input[str] description: The description of the service account.
        :param pulumi.Input[str] ingestion_policy: ID of ingestion policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this service account.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, and `user_management`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups for this service account.
        """
        pulumi.set(__self__, "identifier", identifier)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ingestion_policy is not None:
            pulumi.set(__self__, "ingestion_policy", ingestion_policy)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        The unique identifier of the service account to create. Must have the prefix `sa::`.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service account is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the service account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ingestionPolicy")
    def ingestion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        ID of ingestion policy.
        """
        return pulumi.get(self, "ingestion_policy")

    @ingestion_policy.setter
    def ingestion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingestion_policy", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of permission to grant to this service account.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, and `user_management`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user groups for this service account.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)


@pulumi.input_type
class _ServiceAccountState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 ingestion_policy: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ServiceAccount resources.
        :param pulumi.Input[bool] active: Whether or not the service account is active.
        :param pulumi.Input[str] description: The description of the service account.
        :param pulumi.Input[str] identifier: The unique identifier of the service account to create. Must have the prefix `sa::`.
        :param pulumi.Input[str] ingestion_policy: ID of ingestion policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this service account.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, and `user_management`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups for this service account.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if ingestion_policy is not None:
            pulumi.set(__self__, "ingestion_policy", ingestion_policy)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the service account is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the service account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the service account to create. Must have the prefix `sa::`.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="ingestionPolicy")
    def ingestion_policy(self) -> Optional[pulumi.Input[str]]:
        """
        ID of ingestion policy.
        """
        return pulumi.get(self, "ingestion_policy")

    @ingestion_policy.setter
    def ingestion_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingestion_policy", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of permission to grant to this service account.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, and `user_management`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user groups for this service account.
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)


class ServiceAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 ingestion_policy: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Wavefront Service Account Resource. This allows service accounts to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.ServiceAccount("basic",
            active=True,
            identifier="sa::tftesting")
        ```

        ## Import

        Service accounts can be imported by using `identifier`, e.g.

        ```sh
         $ pulumi import wavefront:index/serviceAccount:ServiceAccount basic sa::tftesting
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether or not the service account is active.
        :param pulumi.Input[str] description: The description of the service account.
        :param pulumi.Input[str] identifier: The unique identifier of the service account to create. Must have the prefix `sa::`.
        :param pulumi.Input[str] ingestion_policy: ID of ingestion policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this service account.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, and `user_management`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups for this service account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Service Account Resource. This allows service accounts to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.ServiceAccount("basic",
            active=True,
            identifier="sa::tftesting")
        ```

        ## Import

        Service accounts can be imported by using `identifier`, e.g.

        ```sh
         $ pulumi import wavefront:index/serviceAccount:ServiceAccount basic sa::tftesting
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 ingestion_policy: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountArgs.__new__(ServiceAccountArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["description"] = description
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["ingestion_policy"] = ingestion_policy
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["user_groups"] = user_groups
        super(ServiceAccount, __self__).__init__(
            'wavefront:index/serviceAccount:ServiceAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            ingestion_policy: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ServiceAccount':
        """
        Get an existing ServiceAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether or not the service account is active.
        :param pulumi.Input[str] description: The description of the service account.
        :param pulumi.Input[str] identifier: The unique identifier of the service account to create. Must have the prefix `sa::`.
        :param pulumi.Input[str] ingestion_policy: ID of ingestion policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this service account.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, and `user_management`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups for this service account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountState.__new__(_ServiceAccountState)

        __props__.__dict__["active"] = active
        __props__.__dict__["description"] = description
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["ingestion_policy"] = ingestion_policy
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["user_groups"] = user_groups
        return ServiceAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the service account is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the service account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        The unique identifier of the service account to create. Must have the prefix `sa::`.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="ingestionPolicy")
    def ingestion_policy(self) -> pulumi.Output[Optional[str]]:
        """
        ID of ingestion policy.
        """
        return pulumi.get(self, "ingestion_policy")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[str]]:
        """
        List of permission to grant to this service account.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, and `user_management`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        List of user groups for this service account.
        """
        return pulumi.get(self, "user_groups")

