"""Repairs platform for the Flu Near You integration."""
from __future__ import annotations

import asyncio

import voluptuous as vol

from homeassistant import data_entry_flow
from homeassistant.components.repairs import RepairsFlow
from homeassistant.core import HomeAssistant

from .const import DOMAIN


class FluNearYouFixFlow(RepairsFlow):
    """Handler for an issue fixing flow."""

    async def async_step_init(
        self, user_input: dict[str, str] | None = None
    ) -> data_entry_flow.FlowResult:
        """Handle the first step of a fix flow."""
        return await self.async_step_confirm()

    async def async_step_confirm(
        self, user_input: dict[str, str] | None = None
    ) -> data_entry_flow.FlowResult:
        """Handle the confirm step of a fix flow."""
        if user_input is not None:
            removal_tasks = [
                self.hass.config_entries.async_remove(entry.entry_id)
                for entry in self.hass.config_entries.async_entries(DOMAIN)
            ]
            await asyncio.gather(*removal_tasks)
            return self.async_create_entry(title="Fixed issue", data={})
        return self.async_show_form(step_id="confirm", data_schema=vol.Schema({}))


async def async_create_fix_flow(
    hass: HomeAssistant, issue_id: str
) -> FluNearYouFixFlow:
    """Create flow."""
    return FluNearYouFixFlow()
