"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an Application Load Balancer as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
class ApplicationLoadBalancerEndpoint {
    /**
     * @stability stable
     */
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_ApplicationLoadBalancerEndpointOptions(options);
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.ApplicationLoadBalancerEndpoint = ApplicationLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancerEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.ApplicationLoadBalancerEndpoint", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,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