"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
class InstanceEndpoint {
    /**
     * @stability stable
     */
    constructor(instance, options = {}) {
        this.instance = instance;
        this.options = options;
        jsiiDeprecationWarnings._aws_cdk_aws_globalaccelerator_endpoints_InstanceEndpointProps(options);
        _util_1.validateWeight(options.weight);
        this.region = instance.env.region;
    }
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.instance.instanceId,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.InstanceEndpoint = InstanceEndpoint;
_a = JSII_RTTI_SYMBOL_1;
InstanceEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.InstanceEndpoint", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,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