"use strict";
const core_1 = require("@aws-cdk/core");
const appscaling = require("../lib");
module.exports = {
    'test utc cron, hour only'(test) {
        test.equals(appscaling.Schedule.cron({ hour: '18', minute: '0' }).expressionString, 'cron(0 18 * * ? *)');
        test.done();
    },
    'test utc cron, hour and minute'(test) {
        test.equals(appscaling.Schedule.cron({ hour: '18', minute: '24' }).expressionString, 'cron(24 18 * * ? *)');
        test.done();
    },
    'rate must be whole number of minutes'(test) {
        test.throws(() => {
            appscaling.Schedule.rate(core_1.Duration.seconds(12345));
        }, /'12345 seconds' cannot be converted into a whole number of minutes/);
        test.done();
    },
    'rate cannot be 0'(test) {
        test.throws(() => {
            appscaling.Schedule.rate(core_1.Duration.days(0));
        }, /Duration cannot be 0/);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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