import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
 *
 * @experimental
 */
export declare class Ec2 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ec2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to accept a Convertible Reserved Instance exchange quote.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptReservedInstancesExchangeQuote.html
     *
     * @experimental
     */
    toAcceptReservedInstancesExchangeQuote(): this;
    /**
     * (experimental) Grants permission to accept a request to associate subnets with a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayMulticastDomainAssociations.html
     *
     * @experimental
     */
    toAcceptTransitGatewayMulticastDomainAssociations(): this;
    /**
     * (experimental) Grants permission to accept a transit gateway peering attachment request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayPeeringAttachment.html
     *
     * @experimental
     */
    toAcceptTransitGatewayPeeringAttachment(): this;
    /**
     * (experimental) Grants permission to accept a request to attach a VPC to a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptTransitGatewayVpcAttachment.html
     *
     * @experimental
     */
    toAcceptTransitGatewayVpcAttachment(): this;
    /**
     * (experimental) Grants permission to accept one or more interface VPC endpoint connections to your VPC endpoint service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcEndpointConnections.html
     *
     * @experimental
     */
    toAcceptVpcEndpointConnections(): this;
    /**
     * (experimental) Grants permission to accept a VPC peering connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AcceptVpcPeeringConnection.html
     *
     * @experimental
     */
    toAcceptVpcPeeringConnection(): this;
    /**
     * (experimental) Grants permission to advertise an IP address range that is provisioned for use in AWS through bring your own IP addresses (BYOIP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html
     *
     * @experimental
     */
    toAdvertiseByoipCidr(): this;
    /**
     * (experimental) Grants permission to allocate an Elastic IP address (EIP) to your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateAddress.html
     *
     * @experimental
     */
    toAllocateAddress(): this;
    /**
     * (experimental) Grants permission to allocate a Dedicated Host to your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AllocateHosts.html
     *
     * @experimental
     */
    toAllocateHosts(): this;
    /**
     * (experimental) Grants permission to apply a security group to the association between a Client VPN endpoint and a target network.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ApplySecurityGroupsToClientVpnTargetNetwork.html
     *
     * @experimental
     */
    toApplySecurityGroupsToClientVpnTargetNetwork(): this;
    /**
     * (experimental) Grants permission to assign one or more IPv6 addresses to a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignIpv6Addresses.html
     *
     * @experimental
     */
    toAssignIpv6Addresses(): this;
    /**
     * (experimental) Grants permission to assign one or more secondary private IP addresses to a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssignPrivateIpAddresses.html
     *
     * @experimental
     */
    toAssignPrivateIpAddresses(): this;
    /**
     * (experimental) Grants permission to associate an Elastic IP address (EIP) with an instance or a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateAddress.html
     *
     * @experimental
     */
    toAssociateAddress(): this;
    /**
     * (experimental) Grants permission to associate a target network with a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateClientVpnTargetNetwork.html
     *
     * @experimental
     */
    toAssociateClientVpnTargetNetwork(): this;
    /**
     * (experimental) Grants permission to associate or disassociate a set of DHCP options with a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateDhcpOptions.html
     *
     * @experimental
     */
    toAssociateDhcpOptions(): this;
    /**
     * (experimental) Grants permission to associate an ACM certificate with an IAM role to be used in an EC2 Enclave.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateEnclaveCertificateIamRole.html
     *
     * @experimental
     */
    toAssociateEnclaveCertificateIamRole(): this;
    /**
     * (experimental) Grants permission to associate an IAM instance profile with a running or stopped instance.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html
     *
     * @experimental
     */
    toAssociateIamInstanceProfile(): this;
    /**
     * (experimental) Grants permission to associate a subnet or gateway with a route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateRouteTable.html
     *
     * @experimental
     */
    toAssociateRouteTable(): this;
    /**
     * (experimental) Grants permission to associate a CIDR block with a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateSubnetCidrBlock.html
     *
     * @experimental
     */
    toAssociateSubnetCidrBlock(): this;
    /**
     * (experimental) Grants permission to associate an attachment and list of subnets with a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayMulticastDomain.html
     *
     * @experimental
     */
    toAssociateTransitGatewayMulticastDomain(): this;
    /**
     * (experimental) Grants permission to associate an attachment with a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateTransitGatewayRouteTable.html
     *
     * @experimental
     */
    toAssociateTransitGatewayRouteTable(): this;
    /**
     * (experimental) Grants permission to associate a CIDR block with a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateVpcCidrBlock.html
     *
     * @experimental
     */
    toAssociateVpcCidrBlock(): this;
    /**
     * (experimental) Grants permission to link an EC2-Classic instance to a ClassicLink-enabled VPC through one or more of the VPC's security groups.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachClassicLinkVpc.html
     *
     * @experimental
     */
    toAttachClassicLinkVpc(): this;
    /**
     * (experimental) Grants permission to attach an internet gateway to a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachInternetGateway.html
     *
     * @experimental
     */
    toAttachInternetGateway(): this;
    /**
     * (experimental) Grants permission to attach a network interface to an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachNetworkInterface.html
     *
     * @experimental
     */
    toAttachNetworkInterface(): this;
    /**
     * (experimental) Grants permission to attach an EBS volume to a running or stopped instance and expose it to the instance with the specified device name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVolume.html
     *
     * @experimental
     */
    toAttachVolume(): this;
    /**
     * (experimental) Grants permission to attach a virtual private gateway to a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AttachVpnGateway.html
     *
     * @experimental
     */
    toAttachVpnGateway(): this;
    /**
     * (experimental) Grants permission to add an inbound authorization rule to a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeClientVpnIngress.html
     *
     * @experimental
     */
    toAuthorizeClientVpnIngress(): this;
    /**
     * (experimental) Grants permission to add one or more outbound rules to a VPC security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupEgress.html
     *
     * @experimental
     */
    toAuthorizeSecurityGroupEgress(): this;
    /**
     * (experimental) Grants permission to add one or more inbound rules to a security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AuthorizeSecurityGroupIngress.html
     *
     * @experimental
     */
    toAuthorizeSecurityGroupIngress(): this;
    /**
     * (experimental) Grants permission to bundle an instance store-backed Windows instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BundleInstance.html
     *
     * @experimental
     */
    toBundleInstance(): this;
    /**
     * (experimental) Grants permission to cancel a bundling operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelBundleTask.html
     *
     * @experimental
     */
    toCancelBundleTask(): this;
    /**
     * (experimental) Grants permission to cancel a Capacity Reservation and release the reserved capacity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelCapacityReservation.html
     *
     * @experimental
     */
    toCancelCapacityReservation(): this;
    /**
     * (experimental) Grants permission to cancel an active conversion task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelConversionTask.html
     *
     * @experimental
     */
    toCancelConversionTask(): this;
    /**
     * (experimental) Grants permission to cancel an active export task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelExportTask.html
     *
     * @experimental
     */
    toCancelExportTask(): this;
    /**
     * (experimental) Grants permission to cancel an in-process import virtual machine or import snapshot task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelImportTask.html
     *
     * @experimental
     */
    toCancelImportTask(): this;
    /**
     * (experimental) Grants permission to cancel a Reserved Instance listing on the Reserved Instance Marketplace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelReservedInstancesListing.html
     *
     * @experimental
     */
    toCancelReservedInstancesListing(): this;
    /**
     * (experimental) Grants permission to cancel one or more Spot Fleet requests.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotFleetRequests.html
     *
     * @experimental
     */
    toCancelSpotFleetRequests(): this;
    /**
     * (experimental) Grants permission to cancel one or more Spot Instance requests.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CancelSpotInstanceRequests.html
     *
     * @experimental
     */
    toCancelSpotInstanceRequests(): this;
    /**
     * (experimental) Grants permission to determine whether an owned product code is associated with an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ConfirmProductInstance.html
     *
     * @experimental
     */
    toConfirmProductInstance(): this;
    /**
     * (experimental) Grants permission to copy a source Amazon FPGA image (AFI) to the current Region.
     *
     * Resource-level permissions specified for this action apply to the new AFI only. They do not apply to the source AFI
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyFpgaImage.html
     *
     * @experimental
     */
    toCopyFpgaImage(): this;
    /**
     * (experimental) Grants permission to copy an Amazon Machine Image (AMI) from a source Region to the current Region.
     *
     * Resource-level permissions specified for this action apply to the new AMI only. They do not apply to the source AMI
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopyImage.html
     *
     * @experimental
     */
    toCopyImage(): this;
    /**
     * (experimental) Grants permission to copy a point-in-time snapshot of an EBS volume and store it in Amazon S3.
     *
     * Resource-level permissions specified for this action apply to the new snapshot only. They do not apply to the source snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html
     *
     * @experimental
     */
    toCopySnapshot(): this;
    /**
     * (experimental) Grants permission to create a Capacity Reservation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCapacityReservation.html
     *
     * @experimental
     */
    toCreateCapacityReservation(): this;
    /**
     * (experimental) Grants permission to create a carrier gateway and provides CSP connectivity to VPC customers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCarrierGateway.html
     *
     * @experimental
     */
    toCreateCarrierGateway(): this;
    /**
     * (experimental) Grants permission to create a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnEndpoint.html
     *
     * @experimental
     */
    toCreateClientVpnEndpoint(): this;
    /**
     * (experimental) Grants permission to add a network route to a Client VPN endpoint's route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateClientVpnRoute.html
     *
     * @experimental
     */
    toCreateClientVpnRoute(): this;
    /**
     * (experimental) Grants permission to create a customer gateway, which provides information to AWS about your customer gateway device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateCustomerGateway.html
     *
     * @experimental
     */
    toCreateCustomerGateway(): this;
    /**
     * (experimental) Grants permission to create a default subnet in a specified Availability Zone in a default VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultSubnet.html
     *
     * @experimental
     */
    toCreateDefaultSubnet(): this;
    /**
     * (experimental) Grants permission to create a default VPC with a default subnet in each Availability Zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDefaultVpc.html
     *
     * @experimental
     */
    toCreateDefaultVpc(): this;
    /**
     * (experimental) Grants permission to create a set of DHCP options for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateDhcpOptions.html
     *
     * @experimental
     */
    toCreateDhcpOptions(): this;
    /**
     * (experimental) Grants permission to create an egress-only internet gateway for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateEgressOnlyInternetGateway.html
     *
     * @experimental
     */
    toCreateEgressOnlyInternetGateway(): this;
    /**
     * (experimental) Grants permission to launch an EC2 Fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet.html
     *
     * @experimental
     */
    toCreateFleet(): this;
    /**
     * (experimental) Grants permission to create one or more flow logs to capture IP traffic for a network interface.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFlowLogs.html
     *
     * @experimental
     */
    toCreateFlowLogs(): this;
    /**
     * (experimental) Grants permission to create an Amazon FPGA Image (AFI) from a design checkpoint (DCP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFpgaImage.html
     *
     * @experimental
     */
    toCreateFpgaImage(): this;
    /**
     * (experimental) Grants permission to create an Amazon EBS-backed AMI from a stopped or running Amazon EBS-backed instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateImage.html
     *
     * @experimental
     */
    toCreateImage(): this;
    /**
     * (experimental) Grants permission to export a running or stopped instance to an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInstanceExportTask.html
     *
     * @experimental
     */
    toCreateInstanceExportTask(): this;
    /**
     * (experimental) Grants permission to create an internet gateway for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateInternetGateway.html
     *
     * @experimental
     */
    toCreateInternetGateway(): this;
    /**
     * (experimental) Grants permission to create a 2048-bit RSA key pair.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateKeyPair.html
     *
     * @experimental
     */
    toCreateKeyPair(): this;
    /**
     * (experimental) Grants permission to create a launch template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html
     *
     * @experimental
     */
    toCreateLaunchTemplate(): this;
    /**
     * (experimental) Grants permission to create a new version of a launch template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html
     *
     * @experimental
     */
    toCreateLaunchTemplateVersion(): this;
    /**
     * (experimental) Grants permission to create a static route for a local gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRoute.html
     *
     * @experimental
     */
    toCreateLocalGatewayRoute(): this;
    /**
     * (experimental) Grants permission to associate a VPC with a local gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLocalGatewayRouteTableVpcAssociation.html
     *
     * @experimental
     */
    toCreateLocalGatewayRouteTableVpcAssociation(): this;
    /**
     * (experimental) Grants permission to create a managed prefix list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateManagedPrefixList.html
     *
     * @experimental
     */
    toCreateManagedPrefixList(): this;
    /**
     * (experimental) Grants permission to create a NAT gateway in a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNatGateway.html
     *
     * @experimental
     */
    toCreateNatGateway(): this;
    /**
     * (experimental) Grants permission to create a network ACL in a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAcl.html
     *
     * @experimental
     */
    toCreateNetworkAcl(): this;
    /**
     * (experimental) Grants permission to create a numbered entry (a rule) in a network ACL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkAclEntry.html
     *
     * @experimental
     */
    toCreateNetworkAclEntry(): this;
    /**
     * (experimental) Grants permission to create a path to analyze for reachability.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInsightsPath.html
     *
     * @experimental
     */
    toCreateNetworkInsightsPath(): this;
    /**
     * (experimental) Grants permission to create a network interface in a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
     *
     * @experimental
     */
    toCreateNetworkInterface(): this;
    /**
     * (experimental) Grants permission to create a permission for an AWS-authorized user to perform certain operations on a network interface.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterfacePermission.html
     *
     * @experimental
     */
    toCreateNetworkInterfacePermission(): this;
    /**
     * (experimental) Grants permission to create a placement group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreatePlacementGroup.html
     *
     * @experimental
     */
    toCreatePlacementGroup(): this;
    /**
     * (experimental) Grants permission to create a listing for Standard Reserved Instances to be sold in the Reserved Instance Marketplace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateReservedInstancesListing.html
     *
     * @experimental
     */
    toCreateReservedInstancesListing(): this;
    /**
     * (experimental) Grants permission to create a route in a VPC route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRoute.html
     *
     * @experimental
     */
    toCreateRoute(): this;
    /**
     * (experimental) Grants permission to create a route table for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateRouteTable.html
     *
     * @experimental
     */
    toCreateRouteTable(): this;
    /**
     * (experimental) Grants permission to create a security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSecurityGroup.html
     *
     * @experimental
     */
    toCreateSecurityGroup(): this;
    /**
     * (experimental) Grants permission to create a snapshot of an EBS volume and store it in Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshot.html
     *
     * @experimental
     */
    toCreateSnapshot(): this;
    /**
     * (experimental) Grants permission to create crash-consistent snapshots of multiple EBS volumes and store them in Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSnapshots.html
     *
     * @experimental
     */
    toCreateSnapshots(): this;
    /**
     * (experimental) Grants permission to create a data feed for Spot Instances to view Spot Instance usage logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSpotDatafeedSubscription.html
     *
     * @experimental
     */
    toCreateSpotDatafeedSubscription(): this;
    /**
     * (experimental) Grants permission to create a subnet in a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateSubnet.html
     *
     * @experimental
     */
    toCreateSubnet(): this;
    /**
     * (experimental) Grants permission to add or overwrite one or more tags for Amazon EC2 resources.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifCreateAction()
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
     *
     * @experimental
     */
    toCreateTags(): this;
    /**
     * (experimental) Grants permission to create a traffic mirror filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html
     *
     * @experimental
     */
    toCreateTrafficMirrorFilter(): this;
    /**
     * (experimental) Grants permission to create a traffic mirror filter rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.html
     *
     * @experimental
     */
    toCreateTrafficMirrorFilterRule(): this;
    /**
     * (experimental) Grants permission to create a traffic mirror session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.html
     *
     * @experimental
     */
    toCreateTrafficMirrorSession(): this;
    /**
     * (experimental) Grants permission to create a traffic mirror target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorTarget.html
     *
     * @experimental
     */
    toCreateTrafficMirrorTarget(): this;
    /**
     * (experimental) Grants permission to create a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGateway.html
     *
     * @experimental
     */
    toCreateTransitGateway(): this;
    /**
     * (experimental) Grants permission to create a Connect attachment from a specified transit gateway attachment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayConnect.html
     *
     * @experimental
     */
    toCreateTransitGatewayConnect(): this;
    /**
     * (experimental) Grants permission to create a Connect peer between a transit gateway and an appliance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayConnectPeer.html
     *
     * @experimental
     */
    toCreateTransitGatewayConnectPeer(): this;
    /**
     * (experimental) Grants permission to create a multicast domain for a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayMulticastDomain.html
     *
     * @experimental
     */
    toCreateTransitGatewayMulticastDomain(): this;
    /**
     * (experimental) Grants permission to request a transit gateway peering attachment between a requester and accepter transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPeeringAttachment.html
     *
     * @experimental
     */
    toCreateTransitGatewayPeeringAttachment(): this;
    /**
     * (experimental) Grants permission to create a transit gateway prefix list reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayPrefixListReference.html
     *
     * @experimental
     */
    toCreateTransitGatewayPrefixListReference(): this;
    /**
     * (experimental) Grants permission to create a static route for a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRoute.html
     *
     * @experimental
     */
    toCreateTransitGatewayRoute(): this;
    /**
     * (experimental) Grants permission to create a route table for a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayRouteTable.html
     *
     * @experimental
     */
    toCreateTransitGatewayRouteTable(): this;
    /**
     * (experimental) Grants permission to attach a VPC to a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTransitGatewayVpcAttachment.html
     *
     * @experimental
     */
    toCreateTransitGatewayVpcAttachment(): this;
    /**
     * (experimental) Grants permission to create an EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html
     *
     * @experimental
     */
    toCreateVolume(): this;
    /**
     * (experimental) Grants permission to create a VPC with a specified CIDR block.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpc.html
     *
     * @experimental
     */
    toCreateVpc(): this;
    /**
     * (experimental) Grants permission to create a VPC endpoint for an AWS service.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - route53:AssociateVPCWithHostedZone
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpoint.html
     *
     * @experimental
     */
    toCreateVpcEndpoint(): this;
    /**
     * (experimental) Grants permission to create a connection notification for a VPC endpoint or VPC endpoint service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointConnectionNotification.html
     *
     * @experimental
     */
    toCreateVpcEndpointConnectionNotification(): this;
    /**
     * (experimental) Grants permission to create a VPC endpoint service configuration to which service consumers (AWS accounts, IAM users, and IAM roles) can connect.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcEndpointServiceConfiguration.html
     *
     * @experimental
     */
    toCreateVpcEndpointServiceConfiguration(): this;
    /**
     * (experimental) Grants permission to request a VPC peering connection between two VPCs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpcPeeringConnection.html
     *
     * @experimental
     */
    toCreateVpcPeeringConnection(): this;
    /**
     * (experimental) Grants permission to create a VPN connection between a virtual private gateway or transit gateway and a customer gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnection.html
     *
     * @experimental
     */
    toCreateVpnConnection(): this;
    /**
     * (experimental) Grants permission to create a static route for a VPN connection between a virtual private gateway and a customer gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnConnectionRoute.html
     *
     * @experimental
     */
    toCreateVpnConnectionRoute(): this;
    /**
     * (experimental) Grants permission to create a virtual private gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVpnGateway.html
     *
     * @experimental
     */
    toCreateVpnGateway(): this;
    /**
     * (experimental) Grants permission to delete a carrier gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCarrierGateway.html
     *
     * @experimental
     */
    toDeleteCarrierGateway(): this;
    /**
     * (experimental) Grants permission to delete a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnEndpoint.html
     *
     * @experimental
     */
    toDeleteClientVpnEndpoint(): this;
    /**
     * (experimental) Grants permission to delete a route from a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteClientVpnRoute.html
     *
     * @experimental
     */
    toDeleteClientVpnRoute(): this;
    /**
     * (experimental) Grants permission to delete a customer gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteCustomerGateway.html
     *
     * @experimental
     */
    toDeleteCustomerGateway(): this;
    /**
     * (experimental) Grants permission to delete a set of DHCP options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteDhcpOptions.html
     *
     * @experimental
     */
    toDeleteDhcpOptions(): this;
    /**
     * (experimental) Grants permission to delete an egress-only internet gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteEgressOnlyInternetGateway.html
     *
     * @experimental
     */
    toDeleteEgressOnlyInternetGateway(): this;
    /**
     * (experimental) Grants permission to delete one or more EC2 Fleets.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFleets.html
     *
     * @experimental
     */
    toDeleteFleets(): this;
    /**
     * (experimental) Grants permission to delete one or more flow logs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFlowLogs.html
     *
     * @experimental
     */
    toDeleteFlowLogs(): this;
    /**
     * (experimental) Grants permission to delete an Amazon FPGA Image (AFI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteFpgaImage.html
     *
     * @experimental
     */
    toDeleteFpgaImage(): this;
    /**
     * (experimental) Grants permission to delete an internet gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteInternetGateway.html
     *
     * @experimental
     */
    toDeleteInternetGateway(): this;
    /**
     * (experimental) Grants permission to delete a key pair by removing the public key from Amazon EC2.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteKeyPair.html
     *
     * @experimental
     */
    toDeleteKeyPair(): this;
    /**
     * (experimental) Grants permission to delete a launch template and its associated versions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplate.html
     *
     * @experimental
     */
    toDeleteLaunchTemplate(): this;
    /**
     * (experimental) Grants permission to delete one or more versions of a launch template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLaunchTemplateVersions.html
     *
     * @experimental
     */
    toDeleteLaunchTemplateVersions(): this;
    /**
     * (experimental) Grants permission to delete a route from a local gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRoute.html
     *
     * @experimental
     */
    toDeleteLocalGatewayRoute(): this;
    /**
     * (experimental) Grants permission to delete an association between a VPC and local gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteLocalGatewayRouteTableVpcAssociation.html
     *
     * @experimental
     */
    toDeleteLocalGatewayRouteTableVpcAssociation(): this;
    /**
     * (experimental) Grants permission to delete a managed prefix list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteManagedPrefixList.html
     *
     * @experimental
     */
    toDeleteManagedPrefixList(): this;
    /**
     * (experimental) Grants permission to delete a NAT gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNatGateway.html
     *
     * @experimental
     */
    toDeleteNatGateway(): this;
    /**
     * (experimental) Grants permission to delete a network ACL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAcl.html
     *
     * @experimental
     */
    toDeleteNetworkAcl(): this;
    /**
     * (experimental) Grants permission to delete an inbound or outbound entry (rule) from a network ACL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkAclEntry.html
     *
     * @experimental
     */
    toDeleteNetworkAclEntry(): this;
    /**
     * (experimental) Grants permission to delete a network insights analysis.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsAnalysis.html
     *
     * @experimental
     */
    toDeleteNetworkInsightsAnalysis(): this;
    /**
     * (experimental) Grants permission to delete a network insights path.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInsightsPath.html
     *
     * @experimental
     */
    toDeleteNetworkInsightsPath(): this;
    /**
     * (experimental) Grants permission to delete a detached network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterface.html
     *
     * @experimental
     */
    toDeleteNetworkInterface(): this;
    /**
     * (experimental) Grants permission to delete a permission that is associated with a network interface.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteNetworkInterfacePermission.html
     *
     * @experimental
     */
    toDeleteNetworkInterfacePermission(): this;
    /**
     * (experimental) Grants permission to delete a placement group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeletePlacementGroup.html
     *
     * @experimental
     */
    toDeletePlacementGroup(): this;
    /**
     * (experimental) Grants permission to delete the queued purchases for the specified Reserved Instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteQueuedReservedInstances.html
     *
     * @experimental
     */
    toDeleteQueuedReservedInstances(): this;
    /**
     * (experimental) Grants permission to delete a route from a route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRoute.html
     *
     * @experimental
     */
    toDeleteRoute(): this;
    /**
     * (experimental) Grants permission to delete a route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteRouteTable.html
     *
     * @experimental
     */
    toDeleteRouteTable(): this;
    /**
     * (experimental) Grants permission to delete a security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSecurityGroup.html
     *
     * @experimental
     */
    toDeleteSecurityGroup(): this;
    /**
     * (experimental) Grants permission to delete a snapshot of an EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSnapshot.html
     *
     * @experimental
     */
    toDeleteSnapshot(): this;
    /**
     * (experimental) Grants permission to delete a data feed for Spot Instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSpotDatafeedSubscription.html
     *
     * @experimental
     */
    toDeleteSpotDatafeedSubscription(): this;
    /**
     * (experimental) Grants permission to delete a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteSubnet.html
     *
     * @experimental
     */
    toDeleteSubnet(): this;
    /**
     * (experimental) Grants permission to delete one or more tags from Amazon EC2 resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTags.html
     *
     * @experimental
     */
    toDeleteTags(): this;
    /**
     * (experimental) Grants permission to delete a traffic mirror filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilter.html
     *
     * @experimental
     */
    toDeleteTrafficMirrorFilter(): this;
    /**
     * (experimental) Grants permission to delete a traffic mirror filter rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorFilterRule.html
     *
     * @experimental
     */
    toDeleteTrafficMirrorFilterRule(): this;
    /**
     * (experimental) Grants permission to delete a traffic mirror session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorSession.html
     *
     * @experimental
     */
    toDeleteTrafficMirrorSession(): this;
    /**
     * (experimental) Grants permission to delete a traffic mirror target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTrafficMirrorTarget.html
     *
     * @experimental
     */
    toDeleteTrafficMirrorTarget(): this;
    /**
     * (experimental) Grants permission to delete a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGateway.html
     *
     * @experimental
     */
    toDeleteTransitGateway(): this;
    /**
     * (experimental) Grants permission to delete a transit gateway connect attachment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayConnect.html
     *
     * @experimental
     */
    toDeleteTransitGatewayConnect(): this;
    /**
     * (experimental) Grants permission to delete a transit gateway connect peer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayConnectPeer.html
     *
     * @experimental
     */
    toDeleteTransitGatewayConnectPeer(): this;
    /**
     * (experimental) Grants permissions to delete a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayMulticastDomain.html
     *
     * @experimental
     */
    toDeleteTransitGatewayMulticastDomain(): this;
    /**
     * (experimental) Grants permission to delete a peering attachment from a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPeeringAttachment.html
     *
     * @experimental
     */
    toDeleteTransitGatewayPeeringAttachment(): this;
    /**
     * (experimental) Grants permission to delete a transit gateway prefix list reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayPrefixListReference.html
     *
     * @experimental
     */
    toDeleteTransitGatewayPrefixListReference(): this;
    /**
     * (experimental) Grants permission to delete a route from a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRoute.html
     *
     * @experimental
     */
    toDeleteTransitGatewayRoute(): this;
    /**
     * (experimental) Grants permission to delete a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayRouteTable.html
     *
     * @experimental
     */
    toDeleteTransitGatewayRouteTable(): this;
    /**
     * (experimental) Grants permission to delete a VPC attachment from a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteTransitGatewayVpcAttachment.html
     *
     * @experimental
     */
    toDeleteTransitGatewayVpcAttachment(): this;
    /**
     * (experimental) Grants permission to delete an EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVolume.html
     *
     * @experimental
     */
    toDeleteVolume(): this;
    /**
     * (experimental) Grants permission to delete a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpc.html
     *
     * @experimental
     */
    toDeleteVpc(): this;
    /**
     * (experimental) Grants permission to delete one or more VPC endpoint connection notifications.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointConnectionNotifications.html
     *
     * @experimental
     */
    toDeleteVpcEndpointConnectionNotifications(): this;
    /**
     * (experimental) Grants permission to delete one or more VPC endpoint service configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpointServiceConfigurations.html
     *
     * @experimental
     */
    toDeleteVpcEndpointServiceConfigurations(): this;
    /**
     * (experimental) Grants permission to delete one or more VPC endpoints.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcEndpoints.html
     *
     * @experimental
     */
    toDeleteVpcEndpoints(): this;
    /**
     * (experimental) Grants permission to delete a VPC peering connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpcPeeringConnection.html
     *
     * @experimental
     */
    toDeleteVpcPeeringConnection(): this;
    /**
     * (experimental) Grants permission to delete a VPN connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnection.html
     *
     * @experimental
     */
    toDeleteVpnConnection(): this;
    /**
     * (experimental) Grants permission to delete a static route for a VPN connection between a virtual private gateway and a customer gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnConnectionRoute.html
     *
     * @experimental
     */
    toDeleteVpnConnectionRoute(): this;
    /**
     * (experimental) Grants permission to delete a virtual private gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeleteVpnGateway.html
     *
     * @experimental
     */
    toDeleteVpnGateway(): this;
    /**
     * (experimental) Grants permission to release an IP address range that was provisioned through bring your own IP addresses (BYOIP), and to delete the corresponding address pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionByoipCidr.html
     *
     * @experimental
     */
    toDeprovisionByoipCidr(): this;
    /**
     * (experimental) Grants permission to deregister an Amazon Machine Image (AMI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterImage.html
     *
     * @experimental
     */
    toDeregisterImage(): this;
    /**
     * (experimental) Grants permission to remove tags from the set of tags to include in notifications about scheduled events for your instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterInstanceEventNotificationAttributes.html
     *
     * @experimental
     */
    toDeregisterInstanceEventNotificationAttributes(): this;
    /**
     * (experimental) Grants permission to deregister one or more network interface members from a group IP address in a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupMembers.html
     *
     * @experimental
     */
    toDeregisterTransitGatewayMulticastGroupMembers(): this;
    /**
     * (experimental) Grants permission to deregister one or more network interface sources from a group IP address in a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeregisterTransitGatewayMulticastGroupSources.html
     *
     * @experimental
     */
    toDeregisterTransitGatewayMulticastGroupSources(): this;
    /**
     * (experimental) Grants permission to describe the attributes of the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAccountAttributes.html
     *
     * @experimental
     */
    toDescribeAccountAttributes(): this;
    /**
     * (experimental) Grants permission to describe one or more Elastic IP addresses.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html
     *
     * @experimental
     */
    toDescribeAddresses(): this;
    /**
     * (experimental) Grants permission to describe the longer ID format settings for all resource types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAggregateIdFormat.html
     *
     * @experimental
     */
    toDescribeAggregateIdFormat(): this;
    /**
     * (experimental) Grants permission to describe one or more of the Availability Zones that are available to you.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html
     *
     * @experimental
     */
    toDescribeAvailabilityZones(): this;
    /**
     * (experimental) Grants permission to describe one or more bundling tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeBundleTasks.html
     *
     * @experimental
     */
    toDescribeBundleTasks(): this;
    /**
     * (experimental) Grants permission to describe the IP address ranges that were provisioned through bring your own IP addresses (BYOIP).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html
     *
     * @experimental
     */
    toDescribeByoipCidrs(): this;
    /**
     * (experimental) Grants permission to describe one or more Capacity Reservations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCapacityReservations.html
     *
     * @experimental
     */
    toDescribeCapacityReservations(): this;
    /**
     * (experimental) Grants permission to describe one or more Carrier Gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCarrierGateways.html
     *
     * @experimental
     */
    toDescribeCarrierGateways(): this;
    /**
     * (experimental) Grants permission to describe one or more linked EC2-Classic instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClassicLinkInstances.html
     *
     * @experimental
     */
    toDescribeClassicLinkInstances(): this;
    /**
     * (experimental) Grants permission to describe the authorization rules for a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnAuthorizationRules.html
     *
     * @experimental
     */
    toDescribeClientVpnAuthorizationRules(): this;
    /**
     * (experimental) Grants permission to describe active client connections and connections that have been terminated within the last 60 minutes for a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnConnections.html
     *
     * @experimental
     */
    toDescribeClientVpnConnections(): this;
    /**
     * (experimental) Grants permission to describe one or more Client VPN endpoints.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnEndpoints.html
     *
     * @experimental
     */
    toDescribeClientVpnEndpoints(): this;
    /**
     * (experimental) Grants permission to describe the routes for a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnRoutes.html
     *
     * @experimental
     */
    toDescribeClientVpnRoutes(): this;
    /**
     * (experimental) Grants permission to describe the target networks that are associated with a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeClientVpnTargetNetworks.html
     *
     * @experimental
     */
    toDescribeClientVpnTargetNetworks(): this;
    /**
     * (experimental) Grants permission to describe the specified customer-owned address pools or all of your customer-owned address pools.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCoipPools.html
     *
     * @experimental
     */
    toDescribeCoipPools(): this;
    /**
     * (experimental) Grants permission to describe one or more conversion tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeConversionTasks.html
     *
     * @experimental
     */
    toDescribeConversionTasks(): this;
    /**
     * (experimental) Grants permission to describe one or more customer gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     *
     * @experimental
     */
    toDescribeCustomerGateways(): this;
    /**
     * (experimental) Grants permission to describe one or more DHCP options sets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeDhcpOptions.html
     *
     * @experimental
     */
    toDescribeDhcpOptions(): this;
    /**
     * (experimental) Grants permission to describe one or more egress-only internet gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeEgressOnlyInternetGateways.html
     *
     * @experimental
     */
    toDescribeEgressOnlyInternetGateways(): this;
    /**
     * (experimental) Grants permission to describe an Elastic Graphics accelerator that is associated with an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeElasticGpus.html
     *
     * @experimental
     */
    toDescribeElasticGpus(): this;
    /**
     * (experimental) Grants permission to describe one or more export image tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportImageTasks.html
     *
     * @experimental
     */
    toDescribeExportImageTasks(): this;
    /**
     * (experimental) Grants permission to describe one or more export instance tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeExportTasks.html
     *
     * @experimental
     */
    toDescribeExportTasks(): this;
    /**
     * (experimental) Grants permission to describe the state of fast snapshot restores for snapshots.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFastSnapshotRestores.html
     *
     * @experimental
     */
    toDescribeFastSnapshotRestores(): this;
    /**
     * (experimental) Grants permission to describe the events for an EC2 Fleet during a specified time.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetHistory.html
     *
     * @experimental
     */
    toDescribeFleetHistory(): this;
    /**
     * (experimental) Grants permission to describe the running instances for an EC2 Fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleetInstances.html
     *
     * @experimental
     */
    toDescribeFleetInstances(): this;
    /**
     * (experimental) Grants permission to describe one or more EC2 Fleets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFleets.html
     *
     * @experimental
     */
    toDescribeFleets(): this;
    /**
     * (experimental) Grants permission to describe one or more flow logs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFlowLogs.html
     *
     * @experimental
     */
    toDescribeFlowLogs(): this;
    /**
     * (experimental) Grants permission to describe the attributes of an Amazon FPGA Image (AFI).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImageAttribute.html
     *
     * @experimental
     */
    toDescribeFpgaImageAttribute(): this;
    /**
     * (experimental) Grants permission to describe one or more Amazon FPGA Images (AFIs).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeFpgaImages.html
     *
     * @experimental
     */
    toDescribeFpgaImages(): this;
    /**
     * (experimental) Grants permission to describe the Dedicated Host Reservations that are available to purchase.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservationOfferings.html
     *
     * @experimental
     */
    toDescribeHostReservationOfferings(): this;
    /**
     * (experimental) Grants permission to describe the Dedicated Host Reservations that are associated with Dedicated Hosts in the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHostReservations.html
     *
     * @experimental
     */
    toDescribeHostReservations(): this;
    /**
     * (experimental) Grants permission to describe one or more Dedicated Hosts.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeHosts.html
     *
     * @experimental
     */
    toDescribeHosts(): this;
    /**
     * (experimental) Grants permission to describe the IAM instance profile associations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIamInstanceProfileAssociations.html
     *
     * @experimental
     */
    toDescribeIamInstanceProfileAssociations(): this;
    /**
     * (experimental) Grants permission to describe the ID format settings for resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdFormat.html
     *
     * @experimental
     */
    toDescribeIdFormat(): this;
    /**
     * (experimental) Grants permission to describe the ID format settings for resources for an IAM user, IAM role, or root user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIdentityIdFormat.html
     *
     * @experimental
     */
    toDescribeIdentityIdFormat(): this;
    /**
     * (experimental) Grants permission to describe an attribute of an Amazon Machine Image (AMI).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImageAttribute.html
     *
     * @experimental
     */
    toDescribeImageAttribute(): this;
    /**
     * (experimental) Grants permission to describe one or more images (AMIs, AKIs, and ARIs).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImages.html
     *
     * @experimental
     */
    toDescribeImages(): this;
    /**
     * (experimental) Grants permission to describe import virtual machine or import snapshot tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportImageTasks.html
     *
     * @experimental
     */
    toDescribeImportImageTasks(): this;
    /**
     * (experimental) Grants permission to describe import snapshot tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeImportSnapshotTasks.html
     *
     * @experimental
     */
    toDescribeImportSnapshotTasks(): this;
    /**
     * (experimental) Grants permission to describe the attributes of an instance.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceAttribute.html
     *
     * @experimental
     */
    toDescribeInstanceAttribute(): this;
    /**
     * (experimental) Grants permission to describe the credit option for CPU usage of one or more burstable performance instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceCreditSpecifications.html
     *
     * @experimental
     */
    toDescribeInstanceCreditSpecifications(): this;
    /**
     * (experimental) Grants permission to describe the set of tags to include in notifications about scheduled events for your instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceEventNotificationAttributes.html
     *
     * @experimental
     */
    toDescribeInstanceEventNotificationAttributes(): this;
    /**
     * (experimental) Grants permission to describe the status of one or more instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceStatus.html
     *
     * @experimental
     */
    toDescribeInstanceStatus(): this;
    /**
     * (experimental) Grants permission to describe the set of instance types that are offered in a location.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html
     *
     * @experimental
     */
    toDescribeInstanceTypeOfferings(): this;
    /**
     * (experimental) Grants permission to describe the details of instance types that are offered in a location.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html
     *
     * @experimental
     */
    toDescribeInstanceTypes(): this;
    /**
     * (experimental) Grants permission to describe one or more instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html
     *
     * @experimental
     */
    toDescribeInstances(): this;
    /**
     * (experimental) Grants permission to describe one or more internet gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInternetGateways.html
     *
     * @experimental
     */
    toDescribeInternetGateways(): this;
    /**
     * (experimental) Grants permission to describe one or more IPv6 address pools.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeIpv6Pools.html
     *
     * @experimental
     */
    toDescribeIpv6Pools(): this;
    /**
     * (experimental) Grants permission to describe one or more key pairs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeKeyPairs.html
     *
     * @experimental
     */
    toDescribeKeyPairs(): this;
    /**
     * (experimental) Grants permission to describe one or more launch template versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html
     *
     * @experimental
     */
    toDescribeLaunchTemplateVersions(): this;
    /**
     * (experimental) Grants permission to describe one or more launch templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html
     *
     * @experimental
     */
    toDescribeLaunchTemplates(): this;
    /**
     * (experimental) Grants permission to describe the associations between virtual interface groups and local gateway route tables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations.html
     *
     * @experimental
     */
    toDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(): this;
    /**
     * (experimental) Grants permission to describe an association between VPCs and local gateway route tables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTableVpcAssociations.html
     *
     * @experimental
     */
    toDescribeLocalGatewayRouteTableVpcAssociations(): this;
    /**
     * (experimental) Grants permission to describe one or more local gateway route tables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayRouteTables.html
     *
     * @experimental
     */
    toDescribeLocalGatewayRouteTables(): this;
    /**
     * (experimental) Grants permission to describe local gateway virtual interface groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html
     *
     * @experimental
     */
    toDescribeLocalGatewayVirtualInterfaceGroups(): this;
    /**
     * (experimental) Grants permission to describe local gateway virtual interfaces.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html
     *
     * @experimental
     */
    toDescribeLocalGatewayVirtualInterfaces(): this;
    /**
     * (experimental) Grants permission to describe one or more local gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGateways.html
     *
     * @experimental
     */
    toDescribeLocalGateways(): this;
    /**
     * (experimental) Grants permission to describe your managed prefix lists and any AWS-managed prefix lists.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeManagedPrefixLists.html
     *
     * @experimental
     */
    toDescribeManagedPrefixLists(): this;
    /**
     * (experimental) Grants permission to describe Elastic IP addresses that are being moved to the EC2-VPC platform.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeMovingAddresses.html
     *
     * @experimental
     */
    toDescribeMovingAddresses(): this;
    /**
     * (experimental) Grants permission to describe one or more NAT gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNatGateways.html
     *
     * @experimental
     */
    toDescribeNatGateways(): this;
    /**
     * (experimental) Grants permission to describe one or more network ACLs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkAcls.html
     *
     * @experimental
     */
    toDescribeNetworkAcls(): this;
    /**
     * (experimental) Grants permission to describe one or more network insights analyses.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsAnalyses.html
     *
     * @experimental
     */
    toDescribeNetworkInsightsAnalyses(): this;
    /**
     * (experimental) Grants permission to describe one or more network insights paths.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInsightsPaths.html
     *
     * @experimental
     */
    toDescribeNetworkInsightsPaths(): this;
    /**
     * (experimental) Grants permission to describe a network interface attribute.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaceAttribute.html
     *
     * @experimental
     */
    toDescribeNetworkInterfaceAttribute(): this;
    /**
     * (experimental) Grants permission to describe the permissions that are associated with a network interface.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfacePermissions.html
     *
     * @experimental
     */
    toDescribeNetworkInterfacePermissions(): this;
    /**
     * (experimental) Grants permission to describe one or more network interfaces.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeNetworkInterfaces.html
     *
     * @experimental
     */
    toDescribeNetworkInterfaces(): this;
    /**
     * (experimental) Grants permission to describe one or more placement groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePlacementGroups.html
     *
     * @experimental
     */
    toDescribePlacementGroups(): this;
    /**
     * (experimental) Grants permission to describe available AWS services in a prefix list format.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrefixLists.html
     *
     * @experimental
     */
    toDescribePrefixLists(): this;
    /**
     * (experimental) Grants permission to describe the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePrincipalIdFormat.html
     *
     * @experimental
     */
    toDescribePrincipalIdFormat(): this;
    /**
     * (experimental) Grants permission to describe one or more IPv4 address pools.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html
     *
     * @experimental
     */
    toDescribePublicIpv4Pools(): this;
    /**
     * (experimental) Grants permission to describe one or more AWS Regions that are currently available in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html
     *
     * @experimental
     */
    toDescribeRegions(): this;
    /**
     * (experimental) Grants permission to describe one or more purchased Reserved Instances in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstances.html
     *
     * @experimental
     */
    toDescribeReservedInstances(): this;
    /**
     * (experimental) Grants permission to describe your account's Reserved Instance listings in the Reserved Instance Marketplace.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesListings.html
     *
     * @experimental
     */
    toDescribeReservedInstancesListings(): this;
    /**
     * (experimental) Grants permission to describe the modifications made to one or more Reserved Instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesModifications.html
     *
     * @experimental
     */
    toDescribeReservedInstancesModifications(): this;
    /**
     * (experimental) Grants permission to describe the Reserved Instance offerings that are available for purchase.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeReservedInstancesOfferings.html
     *
     * @experimental
     */
    toDescribeReservedInstancesOfferings(): this;
    /**
     * (experimental) Grants permission to describe one or more route tables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRouteTables.html
     *
     * @experimental
     */
    toDescribeRouteTables(): this;
    /**
     * (experimental) Grants permission to find available schedules for Scheduled Instances.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstanceAvailability.html
     *
     * @experimental
     */
    toDescribeScheduledInstanceAvailability(): this;
    /**
     * (experimental) Grants permission to describe one or more Scheduled Instances in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeScheduledInstances.html
     *
     * @experimental
     */
    toDescribeScheduledInstances(): this;
    /**
     * (experimental) Grants permission to describe the VPCs on the other side of a VPC peering connection that are referencing specified VPC security groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroupReferences.html
     *
     * @experimental
     */
    toDescribeSecurityGroupReferences(): this;
    /**
     * (experimental) Grants permission to describe one or more security groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html
     *
     * @experimental
     */
    toDescribeSecurityGroups(): this;
    /**
     * (experimental) Grants permission to describe an attribute of a snapshot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshotAttribute.html
     *
     * @experimental
     */
    toDescribeSnapshotAttribute(): this;
    /**
     * (experimental) Grants permission to describe one or more EBS snapshots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html
     *
     * @experimental
     */
    toDescribeSnapshots(): this;
    /**
     * (experimental) Grants permission to describe the data feed for Spot Instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotDatafeedSubscription.html
     *
     * @experimental
     */
    toDescribeSpotDatafeedSubscription(): this;
    /**
     * (experimental) Grants permission to describe the running instances for a Spot Fleet.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetInstances.html
     *
     * @experimental
     */
    toDescribeSpotFleetInstances(): this;
    /**
     * (experimental) Grants permission to describe the events for a Spot Fleet request during a specified time.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequestHistory.html
     *
     * @experimental
     */
    toDescribeSpotFleetRequestHistory(): this;
    /**
     * (experimental) Grants permission to describe one or more Spot Fleet requests.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotFleetRequests.html
     *
     * @experimental
     */
    toDescribeSpotFleetRequests(): this;
    /**
     * (experimental) Grants permission to describe one or more Spot Instance requests.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotInstanceRequests.html
     *
     * @experimental
     */
    toDescribeSpotInstanceRequests(): this;
    /**
     * (experimental) Grants permission to describe the Spot Instance price history.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html
     *
     * @experimental
     */
    toDescribeSpotPriceHistory(): this;
    /**
     * (experimental) Grants permission to describe the stale security group rules for security groups in a specified VPC.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeStaleSecurityGroups.html
     *
     * @experimental
     */
    toDescribeStaleSecurityGroups(): this;
    /**
     * (experimental) Grants permission to describe one or more subnets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSubnets.html
     *
     * @experimental
     */
    toDescribeSubnets(): this;
    /**
     * (experimental) Grants permission to describe one or more tags for an Amazon EC2 resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Grants permission to describe one or more traffic mirror filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorFilters.html
     *
     * @experimental
     */
    toDescribeTrafficMirrorFilters(): this;
    /**
     * (experimental) Grants permission to describe one or more traffic mirror sessions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorSessions.html
     *
     * @experimental
     */
    toDescribeTrafficMirrorSessions(): this;
    /**
     * (experimental) Grants permission to describe one or more traffic mirror targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTrafficMirrorTargets.html
     *
     * @experimental
     */
    toDescribeTrafficMirrorTargets(): this;
    /**
     * (experimental) Grants permission to describe one or more attachments between resources and transit gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html
     *
     * @experimental
     */
    toDescribeTransitGatewayAttachments(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateway connect peers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayConnectPeers.html
     *
     * @experimental
     */
    toDescribeTransitGatewayConnectPeers(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateway connect attachments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayConnects.html
     *
     * @experimental
     */
    toDescribeTransitGatewayConnects(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateway multicast domains.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayMulticastDomains.html
     *
     * @experimental
     */
    toDescribeTransitGatewayMulticastDomains(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateway peering attachments.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayPeeringAttachments.html
     *
     * @experimental
     */
    toDescribeTransitGatewayPeeringAttachments(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateway route tables.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayRouteTables.html
     *
     * @experimental
     */
    toDescribeTransitGatewayRouteTables(): this;
    /**
     * (experimental) Grants permission to describe one or more VPC attachments on a transit gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayVpcAttachments.html
     *
     * @experimental
     */
    toDescribeTransitGatewayVpcAttachments(): this;
    /**
     * (experimental) Grants permission to describe one or more transit gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html
     *
     * @experimental
     */
    toDescribeTransitGateways(): this;
    /**
     * (experimental) Grants permission to describe an attribute of an EBS volume.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeAttribute.html
     *
     * @experimental
     */
    toDescribeVolumeAttribute(): this;
    /**
     * (experimental) Grants permission to describe the status of one or more EBS volumes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumeStatus.html
     *
     * @experimental
     */
    toDescribeVolumeStatus(): this;
    /**
     * (experimental) Grants permission to describe one or more EBS volumes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumes.html
     *
     * @experimental
     */
    toDescribeVolumes(): this;
    /**
     * (experimental) Grants permission to describe the current modification status of one or more EBS volumes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVolumesModifications.html
     *
     * @experimental
     */
    toDescribeVolumesModifications(): this;
    /**
     * (experimental) Grants permission to describe an attribute of a VPC.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcAttribute.html
     *
     * @experimental
     */
    toDescribeVpcAttribute(): this;
    /**
     * (experimental) Grants permission to describe the ClassicLink status of one or more VPCs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLink.html
     *
     * @experimental
     */
    toDescribeVpcClassicLink(): this;
    /**
     * (experimental) Grants permission to describe the ClassicLink DNS support status of one or more VPCs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcClassicLinkDnsSupport.html
     *
     * @experimental
     */
    toDescribeVpcClassicLinkDnsSupport(): this;
    /**
     * (experimental) Grants permission to describe the connection notifications for VPC endpoints and VPC endpoint services.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnectionNotifications.html
     *
     * @experimental
     */
    toDescribeVpcEndpointConnectionNotifications(): this;
    /**
     * (experimental) Grants permission to describe the VPC endpoint connections to your VPC endpoint services.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointConnections.html
     *
     * @experimental
     */
    toDescribeVpcEndpointConnections(): this;
    /**
     * (experimental) Grants permission to describe VPC endpoint service configurations (your services).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServiceConfigurations.html
     *
     * @experimental
     */
    toDescribeVpcEndpointServiceConfigurations(): this;
    /**
     * (experimental) Grants permission to describe the principals (service consumers) that are permitted to discover your VPC endpoint service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServicePermissions.html
     *
     * @experimental
     */
    toDescribeVpcEndpointServicePermissions(): this;
    /**
     * (experimental) Grants permission to describe all supported AWS services that can be specified when creating a VPC endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpointServices.html
     *
     * @experimental
     */
    toDescribeVpcEndpointServices(): this;
    /**
     * (experimental) Grants permission to describe one or more VPC endpoints.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcEndpoints.html
     *
     * @experimental
     */
    toDescribeVpcEndpoints(): this;
    /**
     * (experimental) Grants permission to describe one or more VPC peering connections.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcPeeringConnections.html
     *
     * @experimental
     */
    toDescribeVpcPeeringConnections(): this;
    /**
     * (experimental) Grants permission to describe one or more VPCs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html
     *
     * @experimental
     */
    toDescribeVpcs(): this;
    /**
     * (experimental) Grants permission to describe one or more VPN connections.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html
     *
     * @experimental
     */
    toDescribeVpnConnections(): this;
    /**
     * (experimental) Grants permission to describe one or more virtual private gateways.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnGateways.html
     *
     * @experimental
     */
    toDescribeVpnGateways(): this;
    /**
     * (experimental) Grants permission to unlink (detach) a linked EC2-Classic instance from a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachClassicLinkVpc.html
     *
     * @experimental
     */
    toDetachClassicLinkVpc(): this;
    /**
     * (experimental) Grants permission to detach an internet gateway from a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachInternetGateway.html
     *
     * @experimental
     */
    toDetachInternetGateway(): this;
    /**
     * (experimental) Grants permission to detach a network interface from an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachNetworkInterface.html
     *
     * @experimental
     */
    toDetachNetworkInterface(): this;
    /**
     * (experimental) Grants permission to detach an EBS volume from an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVolume.html
     *
     * @experimental
     */
    toDetachVolume(): this;
    /**
     * (experimental) Grants permission to detach a virtual private gateway from a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DetachVpnGateway.html
     *
     * @experimental
     */
    toDetachVpnGateway(): this;
    /**
     * (experimental) Grants permission to disable EBS encryption by default for your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableEbsEncryptionByDefault.html
     *
     * @experimental
     */
    toDisableEbsEncryptionByDefault(): this;
    /**
     * (experimental) Grants permission to disable fast snapshot restores for one or more snapshots in specified Availability Zones.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableFastSnapshotRestores.html
     *
     * @experimental
     */
    toDisableFastSnapshotRestores(): this;
    /**
     * (experimental) Grants permission to disable a resource attachment from propagating routes to the specified propagation route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableTransitGatewayRouteTablePropagation.html
     *
     * @experimental
     */
    toDisableTransitGatewayRouteTablePropagation(): this;
    /**
     * (experimental) Grants permission to disable a virtual private gateway from propagating routes to a specified route table of a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVgwRoutePropagation.html
     *
     * @experimental
     */
    toDisableVgwRoutePropagation(): this;
    /**
     * (experimental) Grants permission to disable ClassicLink for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLink.html
     *
     * @experimental
     */
    toDisableVpcClassicLink(): this;
    /**
     * (experimental) Grants permission to disable ClassicLink DNS support for a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisableVpcClassicLinkDnsSupport.html
     *
     * @experimental
     */
    toDisableVpcClassicLinkDnsSupport(): this;
    /**
     * (experimental) Grants permission to disassociate an Elastic IP address from an instance or network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateAddress.html
     *
     * @experimental
     */
    toDisassociateAddress(): this;
    /**
     * (experimental) Grants permission to disassociate a target network from a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateClientVpnTargetNetwork.html
     *
     * @experimental
     */
    toDisassociateClientVpnTargetNetwork(): this;
    /**
     * (experimental) Grants permission to disassociate an ACM certificate from a IAM role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateEnclaveCertificateIamRole.html
     *
     * @experimental
     */
    toDisassociateEnclaveCertificateIamRole(): this;
    /**
     * (experimental) Grants permission to disassociate an IAM instance profile from a running or stopped instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html
     *
     * @experimental
     */
    toDisassociateIamInstanceProfile(): this;
    /**
     * (experimental) Grants permission to disassociate a subnet from a route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateRouteTable.html
     *
     * @experimental
     */
    toDisassociateRouteTable(): this;
    /**
     * (experimental) Grants permission to disassociate a CIDR block from a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateSubnetCidrBlock.html
     *
     * @experimental
     */
    toDisassociateSubnetCidrBlock(): this;
    /**
     * (experimental) Grants permission to disassociate one or more subnets from a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayMulticastDomain.html
     *
     * @experimental
     */
    toDisassociateTransitGatewayMulticastDomain(): this;
    /**
     * (experimental) Grants permission to disassociate a resource attachment from a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateTransitGatewayRouteTable.html
     *
     * @experimental
     */
    toDisassociateTransitGatewayRouteTable(): this;
    /**
     * (experimental) Grants permission to disassociate a CIDR block from a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateVpcCidrBlock.html
     *
     * @experimental
     */
    toDisassociateVpcCidrBlock(): this;
    /**
     * (experimental) Grants permission to enable EBS encryption by default for your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableEbsEncryptionByDefault.html
     *
     * @experimental
     */
    toEnableEbsEncryptionByDefault(): this;
    /**
     * (experimental) Grants permission to enable fast snapshot restores for one or more snapshots in specified Availability Zones.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableFastSnapshotRestores.html
     *
     * @experimental
     */
    toEnableFastSnapshotRestores(): this;
    /**
     * (experimental) Grants permission to enable an attachment to propagate routes to a propagation route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableTransitGatewayRouteTablePropagation.html
     *
     * @experimental
     */
    toEnableTransitGatewayRouteTablePropagation(): this;
    /**
     * (experimental) Grants permission to enable a virtual private gateway to propagate routes to a VPC route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVgwRoutePropagation.html
     *
     * @experimental
     */
    toEnableVgwRoutePropagation(): this;
    /**
     * (experimental) Grants permission to enable I/O operations for a volume that had I/O operations disabled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVolumeIO.html
     *
     * @experimental
     */
    toEnableVolumeIO(): this;
    /**
     * (experimental) Grants permission to enable a VPC for ClassicLink.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLink.html
     *
     * @experimental
     */
    toEnableVpcClassicLink(): this;
    /**
     * (experimental) Grants permission to enable a VPC to support DNS hostname resolution for ClassicLink.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableVpcClassicLinkDnsSupport.html
     *
     * @experimental
     */
    toEnableVpcClassicLinkDnsSupport(): this;
    /**
     * (experimental) Grants permission to download the client certificate revocation list for a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientCertificateRevocationList.html
     *
     * @experimental
     */
    toExportClientVpnClientCertificateRevocationList(): this;
    /**
     * (experimental) Grants permission to download the contents of the Client VPN endpoint configuration file for a Client VPN endpoint.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportClientVpnClientConfiguration.html
     *
     * @experimental
     */
    toExportClientVpnClientConfiguration(): this;
    /**
     * (experimental) Grants permission to export an Amazon Machine Image (AMI) to a VM file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportImage.html
     *
     * @experimental
     */
    toExportImage(): this;
    /**
     * (experimental) Grants permission to export routes from a transit gateway route table to an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ExportTransitGatewayRoutes.html
     *
     * @experimental
     */
    toExportTransitGatewayRoutes(): this;
    /**
     * (experimental) Grants permission to get the list of roles associated with an ACM certificate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetAssociatedEnclaveCertificateIamRoles.html
     *
     * @experimental
     */
    toGetAssociatedEnclaveCertificateIamRoles(): this;
    /**
     * (experimental) Grants permission to get information about the IPv6 CIDR block associations for a specified IPv6 address pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetAssociatedIpv6PoolCidrs.html
     *
     * @experimental
     */
    toGetAssociatedIpv6PoolCidrs(): this;
    /**
     * (experimental) Grants permission to get usage information about a Capacity Reservation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCapacityReservationUsage.html
     *
     * @experimental
     */
    toGetCapacityReservationUsage(): this;
    /**
     * (experimental) Grants permission to describe the allocations from the specified customer-owned address pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetCoipPoolUsage.html
     *
     * @experimental
     */
    toGetCoipPoolUsage(): this;
    /**
     * (experimental) Grants permission to get the console output for an instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleOutput.html
     *
     * @experimental
     */
    toGetConsoleOutput(): this;
    /**
     * (experimental) Grants permission to retrieve a JPG-format screenshot of a running instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetConsoleScreenshot.html
     *
     * @experimental
     */
    toGetConsoleScreenshot(): this;
    /**
     * (experimental) Grants permission to get the default credit option for CPU usage of a burstable performance instance family.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetDefaultCreditSpecification.html
     *
     * @experimental
     */
    toGetDefaultCreditSpecification(): this;
    /**
     * (experimental) Grants permission to get the ID of the default customer master key (CMK) for EBS encryption by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsDefaultKmsKeyId.html
     *
     * @experimental
     */
    toGetEbsDefaultKmsKeyId(): this;
    /**
     * (experimental) Grants permission to describe whether EBS encryption by default is enabled for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetEbsEncryptionByDefault.html
     *
     * @experimental
     */
    toGetEbsEncryptionByDefault(): this;
    /**
     * (experimental) Grants permission to list the resource groups to which a Capacity Reservation has been added.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetGroupsForCapacityReservation.html
     *
     * @experimental
     */
    toGetGroupsForCapacityReservation(): this;
    /**
     * (experimental) Grants permission to preview a reservation purchase with configurations that match those of a Dedicated Host.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetHostReservationPurchasePreview.html
     *
     * @experimental
     */
    toGetHostReservationPurchasePreview(): this;
    /**
     * (experimental) Grants permission to get the configuration data of the specified instance for use with a new launch template or launch template version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetLaunchTemplateData.html
     *
     * @experimental
     */
    toGetLaunchTemplateData(): this;
    /**
     * (experimental) Grants permission to get information about the resources that are associated with the specified managed prefix list.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListAssociations.html
     *
     * @experimental
     */
    toGetManagedPrefixListAssociations(): this;
    /**
     * (experimental) Grants permission to get information about the entries for a specified managed prefix list.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetManagedPrefixListEntries.html
     *
     * @experimental
     */
    toGetManagedPrefixListEntries(): this;
    /**
     * (experimental) Grants permission to retrieve the encrypted administrator password for a running Windows instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html
     *
     * @experimental
     */
    toGetPasswordData(): this;
    /**
     * (experimental) Grants permission to return a quote and exchange information for exchanging one or more Convertible Reserved Instances for a new Convertible Reserved Instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetReservedInstancesExchangeQuote.html
     *
     * @experimental
     */
    toGetReservedInstancesExchangeQuote(): this;
    /**
     * (experimental) Grants permission to list the route tables to which a resource attachment propagates routes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayAttachmentPropagations.html
     *
     * @experimental
     */
    toGetTransitGatewayAttachmentPropagations(): this;
    /**
     * (experimental) Grants permission to get information about the associations for a transit gateway multicast domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayMulticastDomainAssociations.html
     *
     * @experimental
     */
    toGetTransitGatewayMulticastDomainAssociations(): this;
    /**
     * (experimental) Grants permission to get information about prefix list references for a transit gateway route table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayPrefixListReference.html
     *
     * @experimental
     */
    toGetTransitGatewayPrefixListReferences(): this;
    /**
     * (experimental) Grants permission to get information about associations for a transit gateway route table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTableAssociations.html
     *
     * @experimental
     */
    toGetTransitGatewayRouteTableAssociations(): this;
    /**
     * (experimental) Grants permission to get information about the route table propagations for a transit gateway route table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetTransitGatewayRouteTablePropagations.html
     *
     * @experimental
     */
    toGetTransitGatewayRouteTablePropagations(): this;
    /**
     * (experimental) Grants permission to upload a client certificate revocation list to a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportClientVpnClientCertificateRevocationList.html
     *
     * @experimental
     */
    toImportClientVpnClientCertificateRevocationList(): this;
    /**
     * (experimental) Grants permission to import single or multi-volume disk images or EBS snapshots into an Amazon Machine Image (AMI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportImage.html
     *
     * @experimental
     */
    toImportImage(): this;
    /**
     * (experimental) Grants permission to create an import instance task using metadata from a disk image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportInstance.html
     *
     * @experimental
     */
    toImportInstance(): this;
    /**
     * (experimental) Grants permission to import a public key from an RSA key pair that was created with a third-party tool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportKeyPair.html
     *
     * @experimental
     */
    toImportKeyPair(): this;
    /**
     * (experimental) Grants permission to import a disk into an EBS snapshot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportSnapshot.html
     *
     * @experimental
     */
    toImportSnapshot(): this;
    /**
     * (experimental) Grants permission to create an import volume task using metadata from a disk image.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ImportVolume.html
     *
     * @experimental
     */
    toImportVolume(): this;
    /**
     * (experimental) Grants permission to modify the opt-in status of the Local Zone and Wavelength Zone group for your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyAvailabilityZoneGroup.html
     *
     * @experimental
     */
    toModifyAvailabilityZoneGroup(): this;
    /**
     * (experimental) Grants permission to modify a Capacity Reservation's capacity and the conditions under which it is to be released.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyCapacityReservation.html
     *
     * @experimental
     */
    toModifyCapacityReservation(): this;
    /**
     * (experimental) Grants permission to modify a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyClientVpnEndpoint.html
     *
     * @experimental
     */
    toModifyClientVpnEndpoint(): this;
    /**
     * (experimental) Grants permission to change the account level default credit option for CPU usage of burstable performance instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyDefaultCreditSpecification.html
     *
     * @experimental
     */
    toModifyDefaultCreditSpecification(): this;
    /**
     * (experimental) Grants permission to change the default customer master key (CMK) for EBS encryption by default for your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html
     *
     * @experimental
     */
    toModifyEbsDefaultKmsKeyId(): this;
    /**
     * (experimental) Grants permission to modify an EC2 Fleet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet.html
     *
     * @experimental
     */
    toModifyFleet(): this;
    /**
     * (experimental) Grants permission to modify an attribute of an Amazon FPGA Image (AFI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFpgaImageAttribute.html
     *
     * @experimental
     */
    toModifyFpgaImageAttribute(): this;
    /**
     * (experimental) Grants permission to modify a Dedicated Host.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyHosts.html
     *
     * @experimental
     */
    toModifyHosts(): this;
    /**
     * (experimental) Grants permission to modify the ID format for a resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdFormat.html
     *
     * @experimental
     */
    toModifyIdFormat(): this;
    /**
     * (experimental) Grants permission to modify the ID format of a resource for a specific principal in your account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyIdentityIdFormat.html
     *
     * @experimental
     */
    toModifyIdentityIdFormat(): this;
    /**
     * (experimental) Grants permission to modify an attribute of an Amazon Machine Image (AMI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html
     *
     * @experimental
     */
    toModifyImageAttribute(): this;
    /**
     * (experimental) Grants permission to modify an attribute of an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html
     *
     * @experimental
     */
    toModifyInstanceAttribute(): this;
    /**
     * (experimental) Grants permission to modify the Capacity Reservation settings for a stopped instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCapacityReservationAttributes.html
     *
     * @experimental
     */
    toModifyInstanceCapacityReservationAttributes(): this;
    /**
     * (experimental) Grants permission to modify the credit option for CPU usage on an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceCreditSpecification.html
     *
     * @experimental
     */
    toModifyInstanceCreditSpecification(): this;
    /**
     * (experimental) Grants permission to modify the start time for a scheduled EC2 instance event.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceEventStartTime.html
     *
     * @experimental
     */
    toModifyInstanceEventStartTime(): this;
    /**
     * (experimental) Grants permission to modify the metadata options for an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceMetadataOptions.html
     *
     * @experimental
     */
    toModifyInstanceMetadataOptions(): this;
    /**
     * (experimental) Grants permission to modify the placement attributes for an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstancePlacement.html
     *
     * @experimental
     */
    toModifyInstancePlacement(): this;
    /**
     * (experimental) Grants permission to modify a launch template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyLaunchTemplate.html
     *
     * @experimental
     */
    toModifyLaunchTemplate(): this;
    /**
     * (experimental) Grants permission to modify a managed prefix list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyManagedPrefixList.html
     *
     * @experimental
     */
    toModifyManagedPrefixList(): this;
    /**
     * (experimental) Grants permission to modify an attribute of a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyNetworkInterfaceAttribute.html
     *
     * @experimental
     */
    toModifyNetworkInterfaceAttribute(): this;
    /**
     * (experimental) Grants permission to modify attributes of one or more Reserved Instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyReservedInstances.html
     *
     * @experimental
     */
    toModifyReservedInstances(): this;
    /**
     * (experimental) Grants permission to add or remove permission settings for a snapshot.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySnapshotAttribute.html
     *
     * @experimental
     */
    toModifySnapshotAttribute(): this;
    /**
     * (experimental) Grants permission to modify a Spot Fleet request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest.html
     *
     * @experimental
     */
    toModifySpotFleetRequest(): this;
    /**
     * (experimental) Grants permission to modify an attribute of a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySubnetAttribute.html
     *
     * @experimental
     */
    toModifySubnetAttribute(): this;
    /**
     * (experimental) Grants permission to allow or restrict mirroring network services.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html
     *
     * @experimental
     */
    toModifyTrafficMirrorFilterNetworkServices(): this;
    /**
     * (experimental) Grants permission to modify a traffic mirror rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterRule.html
     *
     * @experimental
     */
    toModifyTrafficMirrorFilterRule(): this;
    /**
     * (experimental) Grants permission to modify a traffic mirror session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorSession.html
     *
     * @experimental
     */
    toModifyTrafficMirrorSession(): this;
    /**
     * (experimental) Grants permission to modify a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGateway.html
     *
     * @experimental
     */
    toModifyTransitGateway(): this;
    /**
     * (experimental) Grants permission to modify a transit gateway prefix list reference.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayPrefixListReference.html
     *
     * @experimental
     */
    toModifyTransitGatewayPrefixListReference(): this;
    /**
     * (experimental) Grants permission to modify a VPC attachment on a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTransitGatewayVpcAttachment.html
     *
     * @experimental
     */
    toModifyTransitGatewayVpcAttachment(): this;
    /**
     * (experimental) Grants permission to modify the parameters of an EBS volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolume.html
     *
     * @experimental
     */
    toModifyVolume(): this;
    /**
     * (experimental) Grants permission to modify an attribute of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVolumeAttribute.html
     *
     * @experimental
     */
    toModifyVolumeAttribute(): this;
    /**
     * (experimental) Grants permission to modify an attribute of a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcAttribute.html
     *
     * @experimental
     */
    toModifyVpcAttribute(): this;
    /**
     * (experimental) Grants permission to modify an attribute of a VPC endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html
     *
     * @experimental
     */
    toModifyVpcEndpoint(): this;
    /**
     * (experimental) Grants permission to modify a connection notification for a VPC endpoint or VPC endpoint service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointConnectionNotification.html
     *
     * @experimental
     */
    toModifyVpcEndpointConnectionNotification(): this;
    /**
     * (experimental) Grants permission to modify the attributes of a VPC endpoint service configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServiceConfiguration.html
     *
     * @experimental
     */
    toModifyVpcEndpointServiceConfiguration(): this;
    /**
     * (experimental) Grants permission to modify the permissions for a VPC endpoint service.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpointServicePermissions.html
     *
     * @experimental
     */
    toModifyVpcEndpointServicePermissions(): this;
    /**
     * (experimental) Grants permission to modify the VPC peering connection options on one side of a VPC peering connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcPeeringConnectionOptions.html
     *
     * @experimental
     */
    toModifyVpcPeeringConnectionOptions(): this;
    /**
     * (experimental) Grants permission to modify the instance tenancy attribute of a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcTenancy.html
     *
     * @experimental
     */
    toModifyVpcTenancy(): this;
    /**
     * (experimental) Grants permission to modify the target gateway of a Site-to-Site VPN connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnConnection.html
     *
     * @experimental
     */
    toModifyVpnConnection(): this;
    /**
     * (experimental) Grants permission to modify the connection options for your Site-to-Site VPN connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnConnectionOptions.html
     *
     * @experimental
     */
    toModifyVpnConnectionOptions(): this;
    /**
     * (experimental) Grants permission to modify the certificate for a Site-to-Site VPN connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelCertificate
     *
     * @experimental
     */
    toModifyVpnTunnelCertificate(): this;
    /**
     * (experimental) Grants permission to modify the options for a Site-to-Site VPN connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpnTunnelOptions.html
     *
     * @experimental
     */
    toModifyVpnTunnelOptions(): this;
    /**
     * (experimental) Grants permission to enable detailed monitoring for a running instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MonitorInstances.html
     *
     * @experimental
     */
    toMonitorInstances(): this;
    /**
     * (experimental) Grants permission to move an Elastic IP address from the EC2-Classic platform to the EC2-VPC platform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_MoveAddressToVpc.html
     *
     * @experimental
     */
    toMoveAddressToVpc(): this;
    /**
     * (experimental) Grants permission to provision an address range for use in AWS through bring your own IP addresses (BYOIP), and to create a corresponding address pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ProvisionByoipCidr.html
     *
     * @experimental
     */
    toProvisionByoipCidr(): this;
    /**
     * (experimental) Grants permission to purchase a reservation with configurations that match those of a Dedicated Host.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseHostReservation.html
     *
     * @experimental
     */
    toPurchaseHostReservation(): this;
    /**
     * (experimental) Grants permission to purchase a Reserved Instance offering.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseReservedInstancesOffering.html
     *
     * @experimental
     */
    toPurchaseReservedInstancesOffering(): this;
    /**
     * (experimental) Grants permission to purchase one or more Scheduled Instances with a specified schedule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_PurchaseScheduledInstances.html
     *
     * @experimental
     */
    toPurchaseScheduledInstances(): this;
    /**
     * (experimental) Grants permission to request a reboot of one or more instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RebootInstances.html
     *
     * @experimental
     */
    toRebootInstances(): this;
    /**
     * (experimental) Grants permission to register an Amazon Machine Image (AMI).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterImage.html
     *
     * @experimental
     */
    toRegisterImage(): this;
    /**
     * (experimental) Grants permission to add tags to the set of tags to include in notifications about scheduled events for your instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterInstanceEventNotificationAttributes.html
     *
     * @experimental
     */
    toRegisterInstanceEventNotificationAttributes(): this;
    /**
     * (experimental) Grants permission to register one or more network interfaces as a member of a group IP address in a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupMembers.html
     *
     * @experimental
     */
    toRegisterTransitGatewayMulticastGroupMembers(): this;
    /**
     * (experimental) Grants permission to register one or more network interfaces as a source of a group IP address in a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RegisterTransitGatewayMulticastGroupSources.html
     *
     * @experimental
     */
    toRegisterTransitGatewayMulticastGroupSources(): this;
    /**
     * (experimental) Grants permission to reject requests to associate cross-account subnets with a transit gateway multicast domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayMulticastDomainAssociations.html
     *
     * @experimental
     */
    toRejectTransitGatewayMulticastDomainAssociations(): this;
    /**
     * (experimental) Grants permission to reject a transit gateway peering attachment request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayPeeringAttachment.html
     *
     * @experimental
     */
    toRejectTransitGatewayPeeringAttachment(): this;
    /**
     * (experimental) Grants permission to reject a request to attach a VPC to a transit gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectTransitGatewayVpcAttachment.html
     *
     * @experimental
     */
    toRejectTransitGatewayVpcAttachment(): this;
    /**
     * (experimental) Grants permission to reject one or more VPC endpoint connection requests to a VPC endpoint service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcEndpointConnections.html
     *
     * @experimental
     */
    toRejectVpcEndpointConnections(): this;
    /**
     * (experimental) Grants permission to reject a VPC peering connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RejectVpcPeeringConnection.html
     *
     * @experimental
     */
    toRejectVpcPeeringConnection(): this;
    /**
     * (experimental) Grants permission to release an Elastic IP address.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseAddress.html
     *
     * @experimental
     */
    toReleaseAddress(): this;
    /**
     * (experimental) Grants permission to release one or more On-Demand Dedicated Hosts.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseHosts.html
     *
     * @experimental
     */
    toReleaseHosts(): this;
    /**
     * (experimental) Grants permission to replace an IAM instance profile for an instance.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceIamInstanceProfileAssociation.html
     *
     * @experimental
     */
    toReplaceIamInstanceProfileAssociation(): this;
    /**
     * (experimental) Grants permission to change which network ACL a subnet is associated with.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclAssociation.html
     *
     * @experimental
     */
    toReplaceNetworkAclAssociation(): this;
    /**
     * (experimental) Grants permission to replace an entry (rule) in a network ACL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceNetworkAclEntry.html
     *
     * @experimental
     */
    toReplaceNetworkAclEntry(): this;
    /**
     * (experimental) Grants permission to replace a route within a route table in a VPC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRoute.html
     *
     * @experimental
     */
    toReplaceRoute(): this;
    /**
     * (experimental) Grants permission to change the route table that is associated with a subnet.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceRouteTableAssociation.html
     *
     * @experimental
     */
    toReplaceRouteTableAssociation(): this;
    /**
     * (experimental) Grants permission to replace a route in a transit gateway route table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReplaceTransitGatewayRoute.html
     *
     * @experimental
     */
    toReplaceTransitGatewayRoute(): this;
    /**
     * (experimental) Grants permission to submit feedback about the status of an instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReportInstanceStatus.html
     *
     * @experimental
     */
    toReportInstanceStatus(): this;
    /**
     * (experimental) Grants permission to create a Spot Fleet request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet.html
     *
     * @experimental
     */
    toRequestSpotFleet(): this;
    /**
     * (experimental) Grants permission to create a Spot Instance request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html
     *
     * @experimental
     */
    toRequestSpotInstances(): this;
    /**
     * (experimental) Grants permission to reset the default customer master key (CMK) for EBS encryption for your account to use the AWS-managed CMK for EBS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetEbsDefaultKmsKeyId.html
     *
     * @experimental
     */
    toResetEbsDefaultKmsKeyId(): this;
    /**
     * (experimental) Grants permission to reset an attribute of an Amazon FPGA Image (AFI) to its default value.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetFpgaImageAttribute.html
     *
     * @experimental
     */
    toResetFpgaImageAttribute(): this;
    /**
     * (experimental) Grants permission to reset an attribute of an Amazon Machine Image (AMI) to its default value.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetImageAttribute.html
     *
     * @experimental
     */
    toResetImageAttribute(): this;
    /**
     * (experimental) Grants permission to reset an attribute of an instance to its default value.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetInstanceAttribute.html
     *
     * @experimental
     */
    toResetInstanceAttribute(): this;
    /**
     * (experimental) Grants permission to reset an attribute of a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetNetworkInterfaceAttribute.html
     *
     * @experimental
     */
    toResetNetworkInterfaceAttribute(): this;
    /**
     * (experimental) Grants permission to reset permission settings for a snapshot.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ResetSnapshotAttribute.html
     *
     * @experimental
     */
    toResetSnapshotAttribute(): this;
    /**
     * (experimental) Grants permission to restore an Elastic IP address that was previously moved to the EC2-VPC platform back to the EC2-Classic platform.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreAddressToClassic.html
     *
     * @experimental
     */
    toRestoreAddressToClassic(): this;
    /**
     * (experimental) Grants permission to restore the entries from a previous version of a managed prefix list to a new version of the prefix list.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RestoreManagedPrefixListVersion.html
     *
     * @experimental
     */
    toRestoreManagedPrefixListVersion(): this;
    /**
     * (experimental) Grants permission to remove an inbound authorization rule from a Client VPN endpoint.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeClientVpnIngress.html
     *
     * @experimental
     */
    toRevokeClientVpnIngress(): this;
    /**
     * (experimental) Grants permission to remove one or more outbound rules from a VPC security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupEgress.html
     *
     * @experimental
     */
    toRevokeSecurityGroupEgress(): this;
    /**
     * (experimental) Grants permission to remove one or more inbound rules from a security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupIngress.html
     *
     * @experimental
     */
    toRevokeSecurityGroupIngress(): this;
    /**
     * (experimental) Grants permission to launch one or more instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunInstances.html
     *
     * @experimental
     */
    toRunInstances(): this;
    /**
     * (experimental) Grants permission to launch one or more Scheduled Instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RunScheduledInstances.html
     *
     * @experimental
     */
    toRunScheduledInstances(): this;
    /**
     * (experimental) Grants permission to search for routes in a local gateway route table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchLocalGatewayRoutes.html
     *
     * @experimental
     */
    toSearchLocalGatewayRoutes(): this;
    /**
     * (experimental) Grants permission to search for groups, sources, and members in a transit gateway multicast domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayMulticastGroups.html
     *
     * @experimental
     */
    toSearchTransitGatewayMulticastGroups(): this;
    /**
     * (experimental) Grants permission to search for routes in a transit gateway route table.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SearchTransitGatewayRoutes.html
     *
     * @experimental
     */
    toSearchTransitGatewayRoutes(): this;
    /**
     * (experimental) Grants permission to send a diagnostic interrupt to an Amazon EC2 instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SendDiagnosticInterrupt.html
     *
     * @experimental
     */
    toSendDiagnosticInterrupt(): this;
    /**
     * (experimental) Grants permission to start a stopped instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartInstances.html
     *
     * @experimental
     */
    toStartInstances(): this;
    /**
     * (experimental) Grants permission to start analyzing a specified path.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartNetworkInsightsAnalysis.html
     *
     * @experimental
     */
    toStartNetworkInsightsAnalysis(): this;
    /**
     * (experimental) Grants permission to start the private DNS verification process for a VPC endpoint service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StartVpcEndpointServicePrivateDnsVerification.html
     *
     * @experimental
     */
    toStartVpcEndpointServicePrivateDnsVerification(): this;
    /**
     * (experimental) Grants permission to stop an Amazon EBS-backed instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StopInstances.html
     *
     * @experimental
     */
    toStopInstances(): this;
    /**
     * (experimental) Grants permission to terminate active Client VPN endpoint connections.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateClientVpnConnections.html
     *
     * @experimental
     */
    toTerminateClientVpnConnections(): this;
    /**
     * (experimental) Grants permission to shut down one or more instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html
     *
     * @experimental
     */
    toTerminateInstances(): this;
    /**
     * (experimental) Grants permission to unassign one or more IPv6 addresses from a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignIpv6Addresses.html
     *
     * @experimental
     */
    toUnassignIpv6Addresses(): this;
    /**
     * (experimental) Grants permission to unassign one or more secondary private IP addresses from a network interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnassignPrivateIpAddresses.html
     *
     * @experimental
     */
    toUnassignPrivateIpAddresses(): this;
    /**
     * (experimental) Grants permission to disable detailed monitoring for a running instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UnmonitorInstances.html
     *
     * @experimental
     */
    toUnmonitorInstances(): this;
    /**
     * (experimental) Grants permission to update descriptions for one or more outbound rules in a VPC security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsEgress.html
     *
     * @experimental
     */
    toUpdateSecurityGroupRuleDescriptionsEgress(): this;
    /**
     * (experimental) Grants permission to update descriptions for one or more inbound rules in a security group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_UpdateSecurityGroupRuleDescriptionsIngress.html
     *
     * @experimental
     */
    toUpdateSecurityGroupRuleDescriptionsIngress(): this;
    /**
     * (experimental) Grants permission to stop advertising an address range that was provisioned for use in AWS through bring your own IP addresses (BYOIP).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_WithdrawByoipCidr.html
     *
     * @experimental
     */
    toWithdrawByoipCidr(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type elastic-ip to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
     *
     * @param allocationId - Identifier for the allocationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onElasticIp(allocationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type capacity-reservation to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
     *
     * @param capacityReservationId - Identifier for the capacityReservationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCapacityReservation(capacityReservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type carrier-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/Carrier_Gateway.html
     *
     * @param carrierGatewayId - Identifier for the carrierGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCarrierGateway(carrierGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type certificate to the statement.
     *
     * https://docs.aws.amazon.com/acm/latest/userguide/authen-overview.html#acm-resources-operations
     *
     * @param certificateId - Identifier for the certificateId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCertificate(certificateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type client-vpn-endpoint to the statement.
     *
     * https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/what-is.html
     *
     * @param clientVpnEndpointId - Identifier for the clientVpnEndpointId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onClientVpnEndpoint(clientVpnEndpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type customer-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param customerGatewayId - Identifier for the customerGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCustomerGateway(customerGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dedicated-host to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html
     *
     * @param dedicatedHostId - Identifier for the dedicatedHostId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDedicatedHost(dedicatedHostId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dhcp-options to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
     *
     * @param dhcpOptionsId - Identifier for the dhcpOptionsId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDhcpOptions(dhcpOptionsId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type egress-only-internet-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/egress-only-internet-gateway.html
     *
     * @param egressOnlyInternetGatewayId - Identifier for the egressOnlyInternetGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEgressOnlyInternetGateway(egressOnlyInternetGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type elastic-gpu to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-gpus.html
     *
     * @param elasticGpuId - Identifier for the elasticGpuId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onElasticGpu(elasticGpuId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type elastic-inference to the statement.
     *
     * https://docs.aws.amazon.com/elastic-inference/latest/developerguide/what-is-ei.html
     *
     * @param elasticInferenceAcceleratorId - Identifier for the elasticInferenceAcceleratorId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onElasticInference(elasticInferenceAcceleratorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type export-image-task to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vmimport-image-import.html#export-vm-image
     *
     * @param exportImageTaskId - Identifier for the exportImageTaskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExportImageTask(exportImageTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type export-instance-task to the statement.
     *
     * https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
     *
     * @param exportTaskId - Identifier for the exportTaskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onExportInstanceTask(exportTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type fleet to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type fpga-image to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param fpgaImageId - Identifier for the fpgaImageId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFpgaImage(fpgaImageId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type host-reservation to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param hostReservationId - Identifier for the hostReservationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onHostReservation(hostReservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type image to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIs.html
     *
     * @param imageId - Identifier for the imageId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImage(imageId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type import-image-task to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vmimport-image-import.html#import-vm-image
     *
     * @param importImageTaskId - Identifier for the importImageTaskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImportImageTask(importImageTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type import-snapshot-task to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vmimport-import-snapshot.html
     *
     * @param importSnapshotTaskId - Identifier for the importSnapshotTaskId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onImportSnapshotTask(importSnapshotTaskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type instance to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInstance(instanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type internet-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html
     *
     * @param internetGatewayId - Identifier for the internetGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInternetGateway(internetGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ipv4pool-ec2 to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#ip-addressing-eips
     *
     * @param ipv4PoolEc2Id - Identifier for the ipv4PoolEc2Id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIpv4poolEc2(ipv4PoolEc2Id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ipv6pool-ec2 to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#ipv6-addressing
     *
     * @param ipv6PoolEc2Id - Identifier for the ipv6PoolEc2Id.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIpv6poolEc2(ipv6PoolEc2Id: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type key-pair to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
     *
     * @param keyPairName - Identifier for the keyPairName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onKeyPair(keyPairName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type launch-template to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
     *
     * @param launchTemplateId - Identifier for the launchTemplateId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLaunchTemplate(launchTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#lgw
     *
     * @param localGatewayId - Identifier for the localGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGateway(localGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway-route-table-virtual-interface-group-association to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId - Identifier for the localGatewayRouteTableVirtualInterfaceGroupAssociationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGatewayRouteTableVirtualInterfaceGroupAssociation(localGatewayRouteTableVirtualInterfaceGroupAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway-route-table-vpc-association to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#vpc-associations
     *
     * @param localGatewayRouteTableVpcAssociationId - Identifier for the localGatewayRouteTableVpcAssociationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGatewayRouteTableVpcAssociation(localGatewayRouteTableVpcAssociationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway-route-table to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html#route-tables
     *
     * @param localGatewayRoutetableId - Identifier for the localGatewayRoutetableId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGatewayRouteTable(localGatewayRoutetableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway-virtual-interface-group to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceGroupId - Identifier for the localGatewayVirtualInterfaceGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGatewayVirtualInterfaceGroup(localGatewayVirtualInterfaceGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type local-gateway-virtual-interface to the statement.
     *
     * https://docs.aws.amazon.com/outposts/latest/userguide/outposts-local-gateways.html
     *
     * @param localGatewayVirtualInterfaceId - Identifier for the localGatewayVirtualInterfaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLocalGatewayVirtualInterface(localGatewayVirtualInterfaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type natgateway to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
     *
     * @param natGatewayId - Identifier for the natGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNatgateway(natGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type network-acl to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
     *
     * @param naclId - Identifier for the naclId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkAcl(naclId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type network-insights-analysis to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsAnalysisId - Identifier for the networkInsightsAnalysisId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkInsightsAnalysis(networkInsightsAnalysisId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type network-insights-path to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param networkInsightsPathId - Identifier for the networkInsightsPathId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkInsightsPath(networkInsightsPathId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type network-interface to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
     *
     * @param networkInterfaceId - Identifier for the networkInterfaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkInterface(networkInterfaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type placement-group to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
     *
     * @param placementGroupName - Identifier for the placementGroupName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPlacementGroup(placementGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type prefix-list to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html
     *
     * @param prefixListId - Identifier for the prefixListId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onPrefixList(prefixListId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type reserved-instances to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html
     *
     * @param reservationId - Identifier for the reservationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReservedInstances(reservationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type role to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
     *
     * @param roleNameWithPath - Identifier for the roleNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRole(roleNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type route-table to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
     *
     * @param routeTableId - Identifier for the routeTableId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRouteTable(routeTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type security-group to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-security-groups.html
     *
     * @param securityGroupId - Identifier for the securityGroupId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSecurityGroup(securityGroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type snapshot to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html
     *
     * @param snapshotId - Identifier for the snapshotId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSnapshot(snapshotId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type spot-fleet-request to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param spotFleetRequestId - Identifier for the spotFleetRequestId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSpotFleetRequest(spotFleetRequestId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type spot-instances-request to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html
     *
     * @param spotInstanceRequestId - Identifier for the spotInstanceRequestId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSpotInstancesRequest(spotInstanceRequestId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type subnet to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param subnetId - Identifier for the subnetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSubnet(subnetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type traffic-mirror-filter to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterId - Identifier for the trafficMirrorFilterId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrafficMirrorFilter(trafficMirrorFilterId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type traffic-mirror-filter-rule to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-filter.html
     *
     * @param trafficMirrorFilterRuleId - Identifier for the trafficMirrorFilterRuleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrafficMirrorFilterRule(trafficMirrorFilterRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type traffic-mirror-session to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-session.html
     *
     * @param trafficMirrorSessionId - Identifier for the trafficMirrorSessionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrafficMirrorSession(trafficMirrorSessionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type traffic-mirror-target to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-target.html
     *
     * @param trafficMirrorTargetId - Identifier for the trafficMirrorTargetId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTrafficMirrorTarget(trafficMirrorTargetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type transit-gateway-attachment to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayAttachmentId - Identifier for the transitGatewayAttachmentId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTransitGatewayAttachment(transitGatewayAttachmentId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type transit-gateway-connect-peer to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#EC2_ARN_Format
     *
     * @param transitGatewayConnectPeerId - Identifier for the transitGatewayConnectPeerId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTransitGatewayConnectPeer(transitGatewayConnectPeerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type transit-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayId - Identifier for the transitGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTransitGateway(transitGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type transit-gateway-multicast-domain to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/tgw-multicast-overview.html
     *
     * @param transitGatewayMulticastDomainId - Identifier for the transitGatewayMulticastDomainId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTransitGatewayMulticastDomain(transitGatewayMulticastDomainId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type transit-gateway-route-table to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/tgw/how-transit-gateways-work.html
     *
     * @param transitGatewayRouteTableId - Identifier for the transitGatewayRouteTableId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTransitGatewayRouteTable(transitGatewayRouteTableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type volume to the statement.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes.html
     *
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVolume(volumeId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc-endpoint to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpcEndpointId - Identifier for the vpcEndpointId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpcEndpoint(vpcEndpointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc-endpoint-service to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-overview.html
     *
     * @param vpcEndpointServiceId - Identifier for the vpcEndpointServiceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpcEndpointService(vpcEndpointServiceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc-flow-log to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
     *
     * @param vpcFlowLogId - Identifier for the vpcFlowLogId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpcFlowLog(vpcFlowLogId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param vpcId - Identifier for the vpcId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpc(vpcId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc-peering-connection to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/what-is-vpc-peering.html
     *
     * @param vpcPeeringConnectionId - Identifier for the vpcPeeringConnectionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpcPeeringConnection(vpcPeeringConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpn-connection to the statement.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnConnectionId - Identifier for the vpnConnectionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpnConnection(vpnConnectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpn-gateway to the statement.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
     *
     * @param vpnGatewayId - Identifier for the vpnGatewayId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpnGateway(vpnGatewayId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the ARN of an accepter VPC in a VPC peering connection.
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteTags()
     * - .toDeleteVpcPeeringConnection()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toRejectVpcPeeringConnection()
     * - .toReplaceRoute()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifAccepterVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether the user wants to associate a public IP address with the instance.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAttachNetworkInterface()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toDeleteNetworkInterface()
     * - .toDeleteTags()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisassociateAddress()
     * - .toModifyFleet()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toReplaceRoute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifAssociatePublicIpAddress(value?: boolean): this;
    /**
     * (experimental) Filters access by an attribute being set on a resource.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param attributeName The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAttribute(attributeName: string, value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the authentication type for the VPN tunnel endpoints.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAuthenticationType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the AWS service that has permission to use a resource.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAttachNetworkInterface()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toDeleteNetworkInterface()
     * - .toDeleteTags()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisassociateAddress()
     * - .toModifyFleet()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toReplaceRoute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAuthorizedService(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by an IAM principal that has permission to use a resource.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAuthorizedUser(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the Auto Placement properties of a Dedicated Host.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toGetHostReservationPurchasePreview()
     * - .toModifyHosts()
     * - .toModifyInstancePlacement()
     * - .toPurchaseHostReservation()
     * - .toReleaseHosts()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAutoPlacement(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the name of an Availability Zone in an AWS Region.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toAllocateHosts()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateClientVpnRoute()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateNatGateway()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRoute()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVolume()
     * - .toCreateVpcEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteNetworkInterface()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteSubnet()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toEnableVolumeIO()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetHostReservationPurchasePreview()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toImportInstance()
     * - .toModifyFleet()
     * - .toModifyHosts()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyReservedInstances()
     * - .toModifySubnetAttribute()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcEndpoint()
     * - .toMonitorInstances()
     * - .toPurchaseHostReservation()
     * - .toPurchaseReservedInstancesOffering()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toReleaseHosts()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toRequestSpotInstances()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - network-interface
     * - reserved-instances
     * - subnet
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAvailabilityZone(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the client root certificate chain.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifClientRootCertificateChainArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the CloudWatch Logs log group.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifCloudwatchLogGroupArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the CloudWatch Logs log stream.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifCloudwatchLogStreamArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the name of a resource-creating API action.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/supported-iam-actions-tagging.html
     *
     * Applies to actions:
     * - .toCreateTags()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCreateAction(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the duration after which DPD timeout occurs on a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifDPDTimeoutSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the directory.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifDirectoryArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether the instance is enabled for EBS optimization.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateRoute()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifEbsOptimized(value?: boolean): this;
    /**
     * (experimental) Filters access by the type of Elastic Graphics accelerator.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - elastic-gpu
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifElasticGpuType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether the EBS volume is encrypted.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifEncrypted(value?: boolean): this;
    /**
     * (experimental) Filters access by the gateway type for a VPN endpoint on the AWS side of a VPN connection.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifGatewayType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether host recovery is enabled for a Dedicated Host.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toGetHostReservationPurchasePreview()
     * - .toModifyHosts()
     * - .toModifyInstancePlacement()
     * - .toPurchaseHostReservation()
     * - .toReleaseHosts()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifHostRecovery(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the internet key exchange (IKE) versions that are permitted for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifIKEVersions(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the type of image (machine, aki, or ari).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toDeregisterImage()
     * - .toExportImage()
     * - .toImportImage()
     * - .toModifyFleet()
     * - .toModifyImageAttribute()
     * - .toRequestSpotInstances()
     * - .toResetImageAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - image
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifImageType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the range of inside IP addresses for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifInsideTunnelCidr(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the market or purchasing option of an instance (on-demand or spot).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifInstanceMarketType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of an instance profile.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateRoute()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifInstanceProfile(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the type of instance.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAllocateHosts()
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRoute()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetHostReservationPurchasePreview()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toModifyHosts()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyReservedInstances()
     * - .toMonitorInstances()
     * - .toPurchaseHostReservation()
     * - .toPurchaseReservedInstancesOffering()
     * - .toRebootInstances()
     * - .toReleaseHosts()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - dedicated-host
     * - instance
     * - reserved-instances
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifInstanceType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether users are able to override resources that are specified in the launch template.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifIsLaunchTemplateResource(value?: boolean): this;
    /**
     * (experimental) Filters access by key pair name.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateKeyPair()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteKeyPair()
     * - .toDeleteTags()
     * - .toImportKeyPair()
     * - .toModifyFleet()
     * - .toRequestSpotInstances()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - key-pair
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifKeyPairName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of a launch template.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifLaunchTemplate(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether the HTTP endpoint is enabled for the instance metadata service.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifMetadataHttpEndpoint(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the allowed number of hops when calling the instance metadata service.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifMetadataHttpPutResponseHopLimit(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether tokens are required when calling the instance metadata service (optional or required).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifMetadataHttpTokens(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the owner of the resource (amazon, aws-marketplace, or an AWS account ID).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteFpgaImage()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDeregisterImage()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toExportImage()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyImageAttribute()
     * - .toModifySnapshotAttribute()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     * - snapshot
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOwner(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the parent snapshot.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifParentSnapshot(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the parent volume from which the snapshot was created.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toModifyFleet()
     * - .toModifySnapshotAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifParentVolume(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the type of permission for a resource (INSTANCE-ATTACH or EIP-ASSOCIATE).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPermission(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 1 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifPhase1DHGroupNumbers(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPhase1EncryptionAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 1 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPhase1IntegrityAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the lifetime in seconds for phase 1 of the IKE negotiations for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifPhase1LifetimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the Diffie-Hellman group numbers that are permitted for a VPN tunnel for the phase 2 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifPhase2DHGroupNumbers(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the encryption algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPhase2EncryptionAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the integrity algorithms that are permitted for a VPN tunnel for the phase 2 IKE negotiations.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPhase2IntegrityAlgorithms(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the lifetime in seconds for phase 2 of the IKE negotiations for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifPhase2LifetimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the placement group.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateRoute()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - instance
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifPlacementGroup(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the instance placement strategy used by the placement group (cluster, spread, or partition).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreatePlacementGroup()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toModifyInstancePlacement()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - placement-group
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPlacementGroupStrategy(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the pre-shared key (PSK) used to establish the initial IKE security association between a virtual private gateway and a customer gateway.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPresharedKeys(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the product code that is associated with the AMI.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifProductCode(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by whether the image has public launch permissions.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteFpgaImage()
     * - .toDeleteTags()
     * - .toDeregisterImage()
     * - .toExportImage()
     * - .toImportImage()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyImageAttribute()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - fpga-image
     * - image
     *
     * @param value `true` or `false`.
     * @experimental
     */
    ifPublic(value?: boolean): this;
    /**
     * (experimental) Filters access by the number of Dedicated Hosts in a request.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAllocateHosts()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toGetHostReservationPurchasePreview()
     * - .toModifyHosts()
     * - .toModifyInstancePlacement()
     * - .toPurchaseHostReservation()
     * - .toReleaseHosts()
     *
     * Applies to resource types:
     * - dedicated-host
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifQuantity(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the name of the AWS Region.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toAllocateAddress()
     * - .toAllocateHosts()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateDhcpOptions()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toBundleInstance()
     * - .toCancelCapacityReservation()
     * - .toCancelExportTask()
     * - .toCancelImportTask()
     * - .toCancelSpotFleetRequests()
     * - .toCancelSpotInstanceRequests()
     * - .toConfirmProductInstance()
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCopySnapshot()
     * - .toCreateCapacityReservation()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateCustomerGateway()
     * - .toCreateDhcpOptions()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateInternetGateway()
     * - .toCreateKeyPair()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateManagedPrefixList()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreatePlacementGroup()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilter()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGateway()
     * - .toCreateTransitGatewayConnect()
     * - .toCreateTransitGatewayConnectPeer()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVolume()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcEndpointConnectionNotification()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toCreateVpcPeeringConnection()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toCreateVpnGateway()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteEgressOnlyInternetGateway()
     * - .toDeleteFleets()
     * - .toDeleteFlowLogs()
     * - .toDeleteFpgaImage()
     * - .toDeleteInternetGateway()
     * - .toDeleteKeyPair()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNatGateway()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInsightsAnalysis()
     * - .toDeleteNetworkInsightsPath()
     * - .toDeleteNetworkInterface()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteSubnet()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorFilterRule()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayConnect()
     * - .toDeleteTransitGatewayConnectPeer()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVolume()
     * - .toDeleteVpc()
     * - .toDeleteVpcEndpointConnectionNotifications()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toDeleteVpnGateway()
     * - .toDeregisterImage()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVgwRoutePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateAddress()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVgwRoutePropagation()
     * - .toEnableVolumeIO()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toExportImage()
     * - .toExportTransitGatewayRoutes()
     * - .toGetAssociatedIpv6PoolCidrs()
     * - .toGetCapacityReservationUsage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetGroupsForCapacityReservation()
     * - .toGetHostReservationPurchasePreview()
     * - .toGetLaunchTemplateData()
     * - .toGetManagedPrefixListAssociations()
     * - .toGetManagedPrefixListEntries()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toGetTransitGatewayAttachmentPropagations()
     * - .toGetTransitGatewayMulticastDomainAssociations()
     * - .toGetTransitGatewayPrefixListReferences()
     * - .toGetTransitGatewayRouteTableAssociations()
     * - .toGetTransitGatewayRouteTablePropagations()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toImportImage()
     * - .toImportInstance()
     * - .toImportKeyPair()
     * - .toImportSnapshot()
     * - .toModifyCapacityReservation()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyReservedInstances()
     * - .toModifySnapshotAttribute()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointConnectionNotification()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toMonitorInstances()
     * - .toPurchaseHostReservation()
     * - .toPurchaseReservedInstancesOffering()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReleaseAddress()
     * - .toReleaseHosts()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toReplaceTransitGatewayRoute()
     * - .toReportInstanceStatus()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toSearchLocalGatewayRoutes()
     * - .toSearchTransitGatewayMulticastGroups()
     * - .toSearchTransitGatewayRoutes()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStartNetworkInsightsAnalysis()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dedicated-host
     * - dhcp-options
     * - egress-only-internet-gateway
     * - elastic-gpu
     * - export-image-task
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - host-reservation
     * - image
     * - import-image-task
     * - import-snapshot-task
     * - instance
     * - internet-gateway
     * - ipv4pool-ec2
     * - ipv6pool-ec2
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-route-table
     * - local-gateway-virtual-interface-group
     * - local-gateway-virtual-interface
     * - natgateway
     * - network-acl
     * - network-insights-analysis
     * - network-insights-path
     * - network-interface
     * - placement-group
     * - prefix-list
     * - reserved-instances
     * - route-table
     * - security-group
     * - snapshot
     * - spot-fleet-request
     * - spot-instances-request
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-filter-rule
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - transit-gateway-attachment
     * - transit-gateway-connect-peer
     * - transit-gateway
     * - transit-gateway-multicast-domain
     * - transit-gateway-route-table
     * - volume
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-flow-log
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection
     * - vpn-gateway
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRegion(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the percentage of increase of the rekey window (determined by the rekey margin time) within which the rekey time is randomly selected for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifRekeyFuzzPercentage(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the margin time before the phase 2 lifetime expires for a VPN tunnel.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifRekeyMarginTimeSeconds(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of a requester VPC in a VPC peering connection.
     *
     * https://docs.aws.amazon.com/vpc/latest/peering/security-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcPeeringConnection()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteTags()
     * - .toDeleteVpcPeeringConnection()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toRejectVpcPeeringConnection()
     * - .toReplaceRoute()
     *
     * Applies to resource types:
     * - vpc-peering-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifRequesterVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the payment option of the Reserved Instance offering (No Upfront, Partial Upfront, or All Upfront).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-reserved-instances.html#ri-payment-options
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toCreateReservedInstancesListing()
     * - .toCreateTags()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteTags()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toModifyReservedInstances()
     * - .toPurchaseReservedInstancesOffering()
     *
     * Applies to resource types:
     * - reserved-instances
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifReservedInstancesOfferingType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the preface string for a tag key and value pair that are attached to a resource.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/control-access-with-tags.html
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTagExists(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a tag key and value pair of a resource.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/control-access-with-tags.html
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toAcceptTransitGatewayPeeringAttachment()
     * - .toAcceptTransitGatewayVpcAttachment()
     * - .toAcceptVpcEndpointConnections()
     * - .toAcceptVpcPeeringConnection()
     * - .toAllocateAddress()
     * - .toAllocateHosts()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateDhcpOptions()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAssociateTransitGatewayRouteTable()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toAuthorizeClientVpnIngress()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toBundleInstance()
     * - .toCancelCapacityReservation()
     * - .toCancelExportTask()
     * - .toCancelImportTask()
     * - .toCancelSpotFleetRequests()
     * - .toCancelSpotInstanceRequests()
     * - .toConfirmProductInstance()
     * - .toCopyFpgaImage()
     * - .toCopyImage()
     * - .toCreateCapacityReservation()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateCustomerGateway()
     * - .toCreateDhcpOptions()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateFpgaImage()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateInternetGateway()
     * - .toCreateKeyPair()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateLocalGatewayRoute()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateManagedPrefixList()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreatePlacementGroup()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorFilter()
     * - .toCreateTrafficMirrorFilterRule()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGateway()
     * - .toCreateTransitGatewayConnect()
     * - .toCreateTransitGatewayConnectPeer()
     * - .toCreateTransitGatewayMulticastDomain()
     * - .toCreateTransitGatewayPeeringAttachment()
     * - .toCreateTransitGatewayPrefixListReference()
     * - .toCreateTransitGatewayRoute()
     * - .toCreateTransitGatewayRouteTable()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVolume()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcEndpointConnectionNotification()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toCreateVpcPeeringConnection()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toCreateVpnGateway()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteCustomerGateway()
     * - .toDeleteDhcpOptions()
     * - .toDeleteEgressOnlyInternetGateway()
     * - .toDeleteFleets()
     * - .toDeleteFlowLogs()
     * - .toDeleteFpgaImage()
     * - .toDeleteInternetGateway()
     * - .toDeleteKeyPair()
     * - .toDeleteLaunchTemplate()
     * - .toDeleteLaunchTemplateVersions()
     * - .toDeleteLocalGatewayRoute()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteManagedPrefixList()
     * - .toDeleteNatGateway()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInsightsAnalysis()
     * - .toDeleteNetworkInsightsPath()
     * - .toDeleteNetworkInterface()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSnapshot()
     * - .toDeleteSubnet()
     * - .toDeleteTags()
     * - .toDeleteTrafficMirrorFilter()
     * - .toDeleteTrafficMirrorSession()
     * - .toDeleteTrafficMirrorTarget()
     * - .toDeleteTransitGateway()
     * - .toDeleteTransitGatewayConnect()
     * - .toDeleteTransitGatewayConnectPeer()
     * - .toDeleteTransitGatewayMulticastDomain()
     * - .toDeleteTransitGatewayPeeringAttachment()
     * - .toDeleteTransitGatewayPrefixListReference()
     * - .toDeleteTransitGatewayRoute()
     * - .toDeleteTransitGatewayRouteTable()
     * - .toDeleteTransitGatewayVpcAttachment()
     * - .toDeleteVolume()
     * - .toDeleteVpc()
     * - .toDeleteVpcEndpointConnectionNotifications()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toDeleteVpcEndpoints()
     * - .toDeleteVpcPeeringConnection()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toDeleteVpnGateway()
     * - .toDeregisterImage()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableFastSnapshotRestores()
     * - .toDisableTransitGatewayRouteTablePropagation()
     * - .toDisableVgwRoutePropagation()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateAddress()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toDisassociateIamInstanceProfile()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toDisassociateTransitGatewayRouteTable()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableTransitGatewayRouteTablePropagation()
     * - .toEnableVgwRoutePropagation()
     * - .toEnableVolumeIO()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toExportImage()
     * - .toExportTransitGatewayRoutes()
     * - .toGetAssociatedIpv6PoolCidrs()
     * - .toGetCapacityReservationUsage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetGroupsForCapacityReservation()
     * - .toGetHostReservationPurchasePreview()
     * - .toGetLaunchTemplateData()
     * - .toGetManagedPrefixListAssociations()
     * - .toGetManagedPrefixListEntries()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toGetTransitGatewayAttachmentPropagations()
     * - .toGetTransitGatewayMulticastDomainAssociations()
     * - .toGetTransitGatewayPrefixListReferences()
     * - .toGetTransitGatewayRouteTableAssociations()
     * - .toGetTransitGatewayRouteTablePropagations()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toImportImage()
     * - .toImportInstance()
     * - .toImportKeyPair()
     * - .toImportSnapshot()
     * - .toModifyCapacityReservation()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyFpgaImageAttribute()
     * - .toModifyHosts()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyLaunchTemplate()
     * - .toModifyManagedPrefixList()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyReservedInstances()
     * - .toModifySnapshotAttribute()
     * - .toModifySpotFleetRequest()
     * - .toModifySubnetAttribute()
     * - .toModifyTrafficMirrorFilterNetworkServices()
     * - .toModifyTrafficMirrorFilterRule()
     * - .toModifyTrafficMirrorSession()
     * - .toModifyTransitGateway()
     * - .toModifyTransitGatewayPrefixListReference()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcEndpoint()
     * - .toModifyVpcEndpointConnectionNotification()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toModifyVpcPeeringConnectionOptions()
     * - .toModifyVpcTenancy()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toMonitorInstances()
     * - .toPurchaseHostReservation()
     * - .toPurchaseReservedInstancesOffering()
     * - .toRebootInstances()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toRejectTransitGatewayPeeringAttachment()
     * - .toRejectTransitGatewayVpcAttachment()
     * - .toRejectVpcEndpointConnections()
     * - .toRejectVpcPeeringConnection()
     * - .toReleaseAddress()
     * - .toReleaseHosts()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toReplaceTransitGatewayRoute()
     * - .toReportInstanceStatus()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetFpgaImageAttribute()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRestoreManagedPrefixListVersion()
     * - .toRevokeClientVpnIngress()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toSearchLocalGatewayRoutes()
     * - .toSearchTransitGatewayMulticastGroups()
     * - .toSearchTransitGatewayRoutes()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStartNetworkInsightsAnalysis()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     * - .toStopInstances()
     * - .toTerminateClientVpnConnections()
     * - .toTerminateInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUnmonitorInstances()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - elastic-ip
     * - capacity-reservation
     * - carrier-gateway
     * - client-vpn-endpoint
     * - customer-gateway
     * - dedicated-host
     * - dhcp-options
     * - egress-only-internet-gateway
     * - elastic-gpu
     * - export-image-task
     * - export-instance-task
     * - fleet
     * - fpga-image
     * - host-reservation
     * - image
     * - import-image-task
     * - import-snapshot-task
     * - instance
     * - internet-gateway
     * - ipv4pool-ec2
     * - ipv6pool-ec2
     * - key-pair
     * - launch-template
     * - local-gateway
     * - local-gateway-route-table-virtual-interface-group-association
     * - local-gateway-route-table-vpc-association
     * - local-gateway-route-table
     * - local-gateway-virtual-interface-group
     * - local-gateway-virtual-interface
     * - natgateway
     * - network-acl
     * - network-insights-analysis
     * - network-insights-path
     * - network-interface
     * - placement-group
     * - prefix-list
     * - reserved-instances
     * - route-table
     * - security-group
     * - snapshot
     * - spot-fleet-request
     * - spot-instances-request
     * - subnet
     * - traffic-mirror-filter
     * - traffic-mirror-session
     * - traffic-mirror-target
     * - transit-gateway-attachment
     * - transit-gateway-connect-peer
     * - transit-gateway
     * - transit-gateway-multicast-domain
     * - transit-gateway-route-table
     * - volume
     * - vpc-endpoint
     * - vpc-endpoint-service
     * - vpc-flow-log
     * - vpc
     * - vpc-peering-connection
     * - vpn-connection
     * - vpn-gateway
     *
     * @param tagKey The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the version of the instance metadata service for retrieving IAM role credentials for EC2.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifRoleDelivery(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the root device type of the instance (ebs or instance-store).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssociateAddress()
     * - .toAssociateIamInstanceProfile()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCopyImage()
     * - .toCreateFleet()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateRoute()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toDeleteTags()
     * - .toDeregisterImage()
     * - .toDetachClassicLinkVpc()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toExportImage()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toImportImage()
     * - .toModifyFleet()
     * - .toModifyImageAttribute()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toMonitorInstances()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toRequestSpotInstances()
     * - .toResetImageAttribute()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - image
     * - instance
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRootDeviceType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the routing type for the VPN connection.
     *
     * https://docs.aws.amazon.com/vpn/latest/s2svpn/vpn-authentication-access-control.html
     *
     * Applies to actions:
     * - .toCreateTags()
     * - .toCreateVpnConnection()
     * - .toCreateVpnConnectionRoute()
     * - .toDeleteTags()
     * - .toDeleteVpnConnection()
     * - .toDeleteVpnConnectionRoute()
     * - .toModifyVpnConnection()
     * - .toModifyVpnConnectionOptions()
     * - .toModifyVpnTunnelCertificate()
     * - .toModifyVpnTunnelOptions()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - vpn-connection
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRoutingType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the IAM SAML identity provider.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifSamlProviderArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the server certificate.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAuthorizeClientVpnIngress()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateTags()
     * - .toDeleteClientVpnEndpoint()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteTags()
     * - .toDisassociateClientVpnTargetNetwork()
     * - .toExportClientVpnClientCertificateRevocationList()
     * - .toExportClientVpnClientConfiguration()
     * - .toImportClientVpnClientCertificateRevocationList()
     * - .toModifyClientVpnEndpoint()
     * - .toRevokeClientVpnIngress()
     * - .toTerminateClientVpnConnections()
     *
     * Applies to resource types:
     * - client-vpn-endpoint
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifServerCertificateArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the initiation time of a snapshot.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toCreateFleet()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toModifyFleet()
     * - .toModifySnapshotAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - snapshot
     *
     * @param value The value(s) to check.
     * @param operator Works with [date operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Date). **Default:** `DateEquals`.
     * @experimental
     */
    ifSnapshotTime(value: Date | string | (Date | string)[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the instance from which the request originated.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifSourceInstanceARN(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the subnet.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAttachNetworkInterface()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toDeleteNetworkInterface()
     * - .toDeleteTags()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisassociateAddress()
     * - .toModifyFleet()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toReplaceRoute()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     *
     * Applies to resource types:
     * - network-interface
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifSubnet(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the tenancy of the VPC or instance (default, dedicated, or host).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptReservedInstancesExchangeQuote()
     * - .toAcceptVpcPeeringConnection()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssociateAddress()
     * - .toAssociateDhcpOptions()
     * - .toAssociateIamInstanceProfile()
     * - .toAssociateVpcCidrBlock()
     * - .toAttachClassicLinkVpc()
     * - .toAttachInternetGateway()
     * - .toAttachNetworkInterface()
     * - .toAttachVolume()
     * - .toAttachVpnGateway()
     * - .toBundleInstance()
     * - .toConfirmProductInstance()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateEgressOnlyInternetGateway()
     * - .toCreateFlowLogs()
     * - .toCreateImage()
     * - .toCreateInstanceExportTask()
     * - .toCreateLocalGatewayRouteTableVpcAssociation()
     * - .toCreateNetworkAcl()
     * - .toCreateReservedInstancesListing()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSnapshots()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVpc()
     * - .toCreateVpcEndpoint()
     * - .toCreateVpcPeeringConnection()
     * - .toDeleteCarrierGateway()
     * - .toDeleteLocalGatewayRouteTableVpcAssociation()
     * - .toDeleteQueuedReservedInstances()
     * - .toDeleteTags()
     * - .toDeleteVpc()
     * - .toDetachClassicLinkVpc()
     * - .toDetachInternetGateway()
     * - .toDetachNetworkInterface()
     * - .toDetachVolume()
     * - .toDetachVpnGateway()
     * - .toDisableVpcClassicLink()
     * - .toDisableVpcClassicLinkDnsSupport()
     * - .toDisassociateAddress()
     * - .toDisassociateIamInstanceProfile()
     * - .toEnableVpcClassicLink()
     * - .toEnableVpcClassicLinkDnsSupport()
     * - .toGetConsoleOutput()
     * - .toGetConsoleScreenshot()
     * - .toGetLaunchTemplateData()
     * - .toGetPasswordData()
     * - .toGetReservedInstancesExchangeQuote()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyInstanceAttribute()
     * - .toModifyInstanceCapacityReservationAttributes()
     * - .toModifyInstanceCreditSpecification()
     * - .toModifyInstanceEventStartTime()
     * - .toModifyInstanceMetadataOptions()
     * - .toModifyInstancePlacement()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifyReservedInstances()
     * - .toModifyVpcAttribute()
     * - .toModifyVpcTenancy()
     * - .toMonitorInstances()
     * - .toPurchaseReservedInstancesOffering()
     * - .toRebootInstances()
     * - .toReplaceIamInstanceProfileAssociation()
     * - .toReplaceRoute()
     * - .toReportInstanceStatus()
     * - .toResetInstanceAttribute()
     * - .toRunInstances()
     * - .toSendDiagnosticInterrupt()
     * - .toStartInstances()
     * - .toStopInstances()
     * - .toTerminateInstances()
     * - .toUnmonitorInstances()
     *
     * Applies to resource types:
     * - carrier-gateway
     * - instance
     * - local-gateway-route-table-vpc-association
     * - reserved-instances
     * - vpc
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifTenancy(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the the number of input/output operations per second (IOPS) provisioned for the volume.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifVolumeIops(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the size of the volume, in GiB.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateFleet()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteSnapshot()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toDisableFastSnapshotRestores()
     * - .toEnableFastSnapshotRestores()
     * - .toEnableVolumeIO()
     * - .toImportImage()
     * - .toImportSnapshot()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifySnapshotAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toResetSnapshotAttribute()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     *
     * Applies to resource types:
     * - snapshot
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifVolumeSize(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the throughput of the volume, in MiBps.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifVolumeThroughput(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the type of volume (gp2, gp3, io1, io2, st1, sc1, or standard).
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAttachVolume()
     * - .toCreateSnapshot()
     * - .toCreateSnapshots()
     * - .toCreateTags()
     * - .toCreateVolume()
     * - .toDeleteTags()
     * - .toDeleteVolume()
     * - .toDetachVolume()
     * - .toEnableVolumeIO()
     * - .toModifyInstanceAttribute()
     * - .toModifyVolume()
     * - .toModifyVolumeAttribute()
     * - .toRunInstances()
     *
     * Applies to resource types:
     * - volume
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVolumeType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of the VPC.
     *
     * https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-policy-structure.html#amazon-ec2-keys
     *
     * Applies to actions:
     * - .toAcceptTransitGatewayMulticastDomainAssociations()
     * - .toApplySecurityGroupsToClientVpnTargetNetwork()
     * - .toAssignIpv6Addresses()
     * - .toAssignPrivateIpAddresses()
     * - .toAssociateAddress()
     * - .toAssociateClientVpnTargetNetwork()
     * - .toAssociateRouteTable()
     * - .toAssociateSubnetCidrBlock()
     * - .toAssociateTransitGatewayMulticastDomain()
     * - .toAttachClassicLinkVpc()
     * - .toAttachNetworkInterface()
     * - .toAuthorizeSecurityGroupEgress()
     * - .toAuthorizeSecurityGroupIngress()
     * - .toCreateCarrierGateway()
     * - .toCreateClientVpnEndpoint()
     * - .toCreateClientVpnRoute()
     * - .toCreateFleet()
     * - .toCreateFlowLogs()
     * - .toCreateLaunchTemplate()
     * - .toCreateLaunchTemplateVersion()
     * - .toCreateNatGateway()
     * - .toCreateNetworkAcl()
     * - .toCreateNetworkAclEntry()
     * - .toCreateNetworkInterface()
     * - .toCreateNetworkInterfacePermission()
     * - .toCreateRoute()
     * - .toCreateRouteTable()
     * - .toCreateSecurityGroup()
     * - .toCreateSubnet()
     * - .toCreateTags()
     * - .toCreateTrafficMirrorSession()
     * - .toCreateTrafficMirrorTarget()
     * - .toCreateTransitGatewayVpcAttachment()
     * - .toCreateVpcEndpoint()
     * - .toDeleteCarrierGateway()
     * - .toDeleteClientVpnRoute()
     * - .toDeleteNetworkAcl()
     * - .toDeleteNetworkAclEntry()
     * - .toDeleteNetworkInsightsAnalysis()
     * - .toDeleteNetworkInsightsPath()
     * - .toDeleteNetworkInterface()
     * - .toDeleteRoute()
     * - .toDeleteRouteTable()
     * - .toDeleteSecurityGroup()
     * - .toDeleteSubnet()
     * - .toDeleteTags()
     * - .toDeregisterTransitGatewayMulticastGroupMembers()
     * - .toDeregisterTransitGatewayMulticastGroupSources()
     * - .toDetachNetworkInterface()
     * - .toDisableVgwRoutePropagation()
     * - .toDisassociateAddress()
     * - .toDisassociateRouteTable()
     * - .toDisassociateSubnetCidrBlock()
     * - .toDisassociateTransitGatewayMulticastDomain()
     * - .toEnableVgwRoutePropagation()
     * - .toImportInstance()
     * - .toModifyClientVpnEndpoint()
     * - .toModifyFleet()
     * - .toModifyInstanceAttribute()
     * - .toModifyNetworkInterfaceAttribute()
     * - .toModifySubnetAttribute()
     * - .toModifyTransitGatewayVpcAttachment()
     * - .toModifyVpcEndpoint()
     * - .toRegisterTransitGatewayMulticastGroupMembers()
     * - .toRegisterTransitGatewayMulticastGroupSources()
     * - .toRejectTransitGatewayMulticastDomainAssociations()
     * - .toReplaceNetworkAclAssociation()
     * - .toReplaceNetworkAclEntry()
     * - .toReplaceRoute()
     * - .toReplaceRouteTableAssociation()
     * - .toRequestSpotFleet()
     * - .toRequestSpotInstances()
     * - .toResetNetworkInterfaceAttribute()
     * - .toRevokeSecurityGroupEgress()
     * - .toRevokeSecurityGroupIngress()
     * - .toRunInstances()
     * - .toRunScheduledInstances()
     * - .toStartNetworkInsightsAnalysis()
     * - .toUnassignIpv6Addresses()
     * - .toUnassignPrivateIpAddresses()
     * - .toUpdateSecurityGroupRuleDescriptionsEgress()
     * - .toUpdateSecurityGroupRuleDescriptionsIngress()
     *
     * Applies to resource types:
     * - carrier-gateway
     * - network-acl
     * - network-interface
     * - route-table
     * - security-group
     * - subnet
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifVpc(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the name of the VPC endpoint service.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpceServiceName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the service owner of the VPC endpoint service (amazon, aws-marketplace, or an AWS account ID).
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpceServiceOwner(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the private DNS name of the VPC endpoint service.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-iam.html
     *
     * Applies to actions:
     * - .toAcceptVpcEndpointConnections()
     * - .toCreateTags()
     * - .toCreateVpcEndpointConnectionNotification()
     * - .toCreateVpcEndpointServiceConfiguration()
     * - .toDeleteTags()
     * - .toDeleteVpcEndpointConnectionNotifications()
     * - .toDeleteVpcEndpointServiceConfigurations()
     * - .toModifyVpcEndpointConnectionNotification()
     * - .toModifyVpcEndpointServiceConfiguration()
     * - .toModifyVpcEndpointServicePermissions()
     * - .toRejectVpcEndpointConnections()
     * - .toStartVpcEndpointServicePrivateDnsVerification()
     *
     * Applies to resource types:
     * - vpc-endpoint-service
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpceServicePrivateDnsName(value: string | string[], operator?: Operator | string): this;
}
