# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Project']


class Project(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 available_credits: Optional[pulumi.Input[str]] = None,
                 billing_address: Optional[pulumi.Input[str]] = None,
                 billing_currency: Optional[pulumi.Input[str]] = None,
                 billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 billing_extra_text: Optional[pulumi.Input[str]] = None,
                 billing_group: Optional[pulumi.Input[str]] = None,
                 ca_cert: Optional[pulumi.Input[str]] = None,
                 card_id: Optional[pulumi.Input[str]] = None,
                 copy_from_project: Optional[pulumi.Input[str]] = None,
                 country_code: Optional[pulumi.Input[str]] = None,
                 default_cloud: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vat_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Project Resource

        The Project resource allows the creation and management of Aiven Projects.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: is an optional property to link a project to already an existing account by 
               using account ID.
        :param pulumi.Input[str] available_credits: Available credits
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[str] billing_currency: Billing currency
        :param pulumi.Input[Sequence[pulumi.Input[str]]] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] billing_extra_text: Extra text to be included in all project invoices, e.g. purchase order or cost center number
        :param pulumi.Input[str] billing_group: Billing group Id
        :param pulumi.Input[str] ca_cert: is a computed property that can be used to read the CA certificate of the
               project. This is required for configuring clients that connect to certain services like
               Kafka. This value cannot be set, only read.
        :param pulumi.Input[str] card_id: is either the full card UUID or the last 4 digits of the card. As the full
               UUID is not shown in the UI it is typically easier to use the last 4 digits to identify
               the card. This can be omitted if `copy_from_project` is used to copy billing info from
               another project.
        :param pulumi.Input[str] copy_from_project: is the name of another project used to copy billing information and
               some other project attributes like technical contacts from. This is mostly relevant when
               an existing project has billing type set to invoice and that needs to be copied over to a
               new project. (Setting billing is otherwise not allowed over the API.) This only has
               effect when the project is created.
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] default_cloud: Default cloud for new services
        :param pulumi.Input[str] project: defines the name of the project. Name must be globally unique (between all
               Aiven customers) and cannot be changed later without destroying and re-creating the
               project, including all sub-resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] technical_emails: Technical contact emails of the project
        :param pulumi.Input[str] vat_id: EU VAT Identification Number
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_id'] = account_id
            __props__['available_credits'] = available_credits
            if billing_address is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("billing_address is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['billing_address'] = billing_address
            if billing_currency is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("billing_currency is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['billing_currency'] = billing_currency
            if billing_emails is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("billing_emails is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['billing_emails'] = billing_emails
            if billing_extra_text is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("billing_extra_text is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['billing_extra_text'] = billing_extra_text
            __props__['billing_group'] = billing_group
            __props__['ca_cert'] = ca_cert
            if card_id is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("card_id is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['card_id'] = card_id
            __props__['copy_from_project'] = copy_from_project
            if country_code is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("country_code is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['country_code'] = country_code
            __props__['default_cloud'] = default_cloud
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['technical_emails'] = technical_emails
            if vat_id is not None and not opts.urn:
                warnings.warn("""Please use aiven_billing_group resource to set this value.""", DeprecationWarning)
                pulumi.log.warn("vat_id is deprecated: Please use aiven_billing_group resource to set this value.")
            __props__['vat_id'] = vat_id
            __props__['country'] = None
            __props__['estimated_balance'] = None
            __props__['payment_method'] = None
        super(Project, __self__).__init__(
            'aiven:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            available_credits: Optional[pulumi.Input[str]] = None,
            billing_address: Optional[pulumi.Input[str]] = None,
            billing_currency: Optional[pulumi.Input[str]] = None,
            billing_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            billing_extra_text: Optional[pulumi.Input[str]] = None,
            billing_group: Optional[pulumi.Input[str]] = None,
            ca_cert: Optional[pulumi.Input[str]] = None,
            card_id: Optional[pulumi.Input[str]] = None,
            copy_from_project: Optional[pulumi.Input[str]] = None,
            country: Optional[pulumi.Input[str]] = None,
            country_code: Optional[pulumi.Input[str]] = None,
            default_cloud: Optional[pulumi.Input[str]] = None,
            estimated_balance: Optional[pulumi.Input[str]] = None,
            payment_method: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            technical_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vat_id: Optional[pulumi.Input[str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: is an optional property to link a project to already an existing account by 
               using account ID.
        :param pulumi.Input[str] available_credits: Available credits
        :param pulumi.Input[str] billing_address: Billing name and address of the project
        :param pulumi.Input[str] billing_currency: Billing currency
        :param pulumi.Input[Sequence[pulumi.Input[str]]] billing_emails: Billing contact emails of the project
        :param pulumi.Input[str] billing_extra_text: Extra text to be included in all project invoices, e.g. purchase order or cost center number
        :param pulumi.Input[str] billing_group: Billing group Id
        :param pulumi.Input[str] ca_cert: is a computed property that can be used to read the CA certificate of the
               project. This is required for configuring clients that connect to certain services like
               Kafka. This value cannot be set, only read.
        :param pulumi.Input[str] card_id: is either the full card UUID or the last 4 digits of the card. As the full
               UUID is not shown in the UI it is typically easier to use the last 4 digits to identify
               the card. This can be omitted if `copy_from_project` is used to copy billing info from
               another project.
        :param pulumi.Input[str] copy_from_project: is the name of another project used to copy billing information and
               some other project attributes like technical contacts from. This is mostly relevant when
               an existing project has billing type set to invoice and that needs to be copied over to a
               new project. (Setting billing is otherwise not allowed over the API.) This only has
               effect when the project is created.
        :param pulumi.Input[str] country: Billing country
        :param pulumi.Input[str] country_code: Billing country code of the project
        :param pulumi.Input[str] default_cloud: Default cloud for new services
        :param pulumi.Input[str] estimated_balance: Estimated balance
        :param pulumi.Input[str] payment_method: Payment method
        :param pulumi.Input[str] project: defines the name of the project. Name must be globally unique (between all
               Aiven customers) and cannot be changed later without destroying and re-creating the
               project, including all sub-resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] technical_emails: Technical contact emails of the project
        :param pulumi.Input[str] vat_id: EU VAT Identification Number
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["available_credits"] = available_credits
        __props__["billing_address"] = billing_address
        __props__["billing_currency"] = billing_currency
        __props__["billing_emails"] = billing_emails
        __props__["billing_extra_text"] = billing_extra_text
        __props__["billing_group"] = billing_group
        __props__["ca_cert"] = ca_cert
        __props__["card_id"] = card_id
        __props__["copy_from_project"] = copy_from_project
        __props__["country"] = country
        __props__["country_code"] = country_code
        __props__["default_cloud"] = default_cloud
        __props__["estimated_balance"] = estimated_balance
        __props__["payment_method"] = payment_method
        __props__["project"] = project
        __props__["technical_emails"] = technical_emails
        __props__["vat_id"] = vat_id
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[str]]:
        """
        is an optional property to link a project to already an existing account by 
        using account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> pulumi.Output[str]:
        """
        Available credits
        """
        return pulumi.get(self, "available_credits")

    @property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> pulumi.Output[Optional[str]]:
        """
        Billing name and address of the project
        """
        return pulumi.get(self, "billing_address")

    @property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> pulumi.Output[Optional[str]]:
        """
        Billing currency
        """
        return pulumi.get(self, "billing_currency")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Billing contact emails of the project
        """
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> pulumi.Output[Optional[str]]:
        """
        Extra text to be included in all project invoices, e.g. purchase order or cost center number
        """
        return pulumi.get(self, "billing_extra_text")

    @property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> pulumi.Output[Optional[str]]:
        """
        Billing group Id
        """
        return pulumi.get(self, "billing_group")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[str]:
        """
        is a computed property that can be used to read the CA certificate of the
        project. This is required for configuring clients that connect to certain services like
        Kafka. This value cannot be set, only read.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> pulumi.Output[Optional[str]]:
        """
        is either the full card UUID or the last 4 digits of the card. As the full
        UUID is not shown in the UI it is typically easier to use the last 4 digits to identify
        the card. This can be omitted if `copy_from_project` is used to copy billing info from
        another project.
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> pulumi.Output[Optional[str]]:
        """
        is the name of another project used to copy billing information and
        some other project attributes like technical contacts from. This is mostly relevant when
        an existing project has billing type set to invoice and that needs to be copied over to a
        new project. (Setting billing is otherwise not allowed over the API.) This only has
        effect when the project is created.
        """
        return pulumi.get(self, "copy_from_project")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[str]:
        """
        Billing country
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[Optional[str]]:
        """
        Billing country code of the project
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> pulumi.Output[Optional[str]]:
        """
        Default cloud for new services
        """
        return pulumi.get(self, "default_cloud")

    @property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> pulumi.Output[str]:
        """
        Estimated balance
        """
        return pulumi.get(self, "estimated_balance")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> pulumi.Output[str]:
        """
        Payment method
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        defines the name of the project. Name must be globally unique (between all
        Aiven customers) and cannot be changed later without destroying and re-creating the
        project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Technical contact emails of the project
        """
        return pulumi.get(self, "technical_emails")

    @property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> pulumi.Output[Optional[str]]:
        """
        EU VAT Identification Number
        """
        return pulumi.get(self, "vat_id")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

