import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::FMS::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 * @external
 */
export interface CfnNotificationChannelProps {
    /**
     * `AWS::FMS::NotificationChannel.SnsRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html#cfn-fms-notificationchannel-snsrolename
     * @external
     */
    readonly snsRoleName: string;
    /**
     * `AWS::FMS::NotificationChannel.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html#cfn-fms-notificationchannel-snstopicarn
     * @external
     */
    readonly snsTopicArn: string;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 * @external
 * @cloudformationResource AWS::FMS::NotificationChannel
 */
export declare class CfnNotificationChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNotificationChannel;
    /**
     * `AWS::FMS::NotificationChannel.SnsRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html#cfn-fms-notificationchannel-snsrolename
     * @external
     */
    snsRoleName: string;
    /**
     * `AWS::FMS::NotificationChannel.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html#cfn-fms-notificationchannel-snstopicarn
     * @external
     */
    snsTopicArn: string;
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotificationChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::FMS::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 * @external
 */
export interface CfnPolicyProps {
    /**
     * `AWS::FMS::Policy.ExcludeResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excluderesourcetags
     * @external
     */
    readonly excludeResourceTags: boolean | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policyname
     * @external
     */
    readonly policyName: string;
    /**
     * `AWS::FMS::Policy.RemediationEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-remediationenabled
     * @external
     */
    readonly remediationEnabled: boolean | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetype
     * @external
     */
    readonly resourceType: string;
    /**
     * `AWS::FMS::Policy.SecurityServicePolicyData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-securityservicepolicydata
     * @external
     */
    readonly securityServicePolicyData: any | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.DeleteAllPolicyResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-deleteallpolicyresources
     * @external
     */
    readonly deleteAllPolicyResources?: boolean | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.ExcludeMap`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excludemap
     * @external
     */
    readonly excludeMap?: CfnPolicy.IEMapProperty | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.IncludeMap`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-includemap
     * @external
     */
    readonly includeMap?: CfnPolicy.IEMapProperty | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.ResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetags
     * @external
     */
    readonly resourceTags?: Array<CfnPolicy.ResourceTagProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.ResourceTypeList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetypelist
     * @external
     */
    readonly resourceTypeList?: string[];
    /**
     * `AWS::FMS::Policy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-tags
     * @external
     */
    readonly tags?: CfnPolicy.PolicyTagProperty[];
}
/**
 * A CloudFormation `AWS::FMS::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 * @external
 * @cloudformationResource AWS::FMS::Policy
 */
export declare class CfnPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPolicy;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::FMS::Policy.ExcludeResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excluderesourcetags
     * @external
     */
    excludeResourceTags: boolean | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-policyname
     * @external
     */
    policyName: string;
    /**
     * `AWS::FMS::Policy.RemediationEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-remediationenabled
     * @external
     */
    remediationEnabled: boolean | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetype
     * @external
     */
    resourceType: string;
    /**
     * `AWS::FMS::Policy.SecurityServicePolicyData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-securityservicepolicydata
     * @external
     */
    securityServicePolicyData: any | cdk.IResolvable;
    /**
     * `AWS::FMS::Policy.DeleteAllPolicyResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-deleteallpolicyresources
     * @external
     */
    deleteAllPolicyResources: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::FMS::Policy.ExcludeMap`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-excludemap
     * @external
     */
    excludeMap: CfnPolicy.IEMapProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FMS::Policy.IncludeMap`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-includemap
     * @external
     */
    includeMap: CfnPolicy.IEMapProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FMS::Policy.ResourceTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetags
     * @external
     */
    resourceTags: Array<CfnPolicy.ResourceTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::FMS::Policy.ResourceTypeList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-resourcetypelist
     * @external
     */
    resourceTypeList: string[] | undefined;
    /**
     * `AWS::FMS::Policy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html#cfn-fms-policy-tags
     * @external
     */
    tags: CfnPolicy.PolicyTagProperty[] | undefined;
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::FMS::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 * @external
 * @cloudformationResource AWS::FMS::Policy
 */
export declare namespace CfnPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-iemap.html
     * @external
     */
    interface IEMapProperty {
        /**
         * `CfnPolicy.IEMapProperty.ACCOUNT`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-iemap.html#cfn-fms-policy-iemap-account
         * @external
         */
        readonly account?: string[];
        /**
         * `CfnPolicy.IEMapProperty.ORGUNIT`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-iemap.html#cfn-fms-policy-iemap-orgunit
         * @external
         */
        readonly orgunit?: string[];
    }
}
/**
 * A CloudFormation `AWS::FMS::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 * @external
 * @cloudformationResource AWS::FMS::Policy
 */
export declare namespace CfnPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-policytag.html
     * @external
     */
    interface PolicyTagProperty {
        /**
         * `CfnPolicy.PolicyTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-policytag.html#cfn-fms-policy-policytag-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnPolicy.PolicyTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-policytag.html#cfn-fms-policy-policytag-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::FMS::Policy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 * @external
 * @cloudformationResource AWS::FMS::Policy
 */
export declare namespace CfnPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-resourcetag.html
     * @external
     */
    interface ResourceTagProperty {
        /**
         * `CfnPolicy.ResourceTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-resourcetag.html#cfn-fms-policy-resourcetag-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnPolicy.ResourceTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fms-policy-resourcetag.html#cfn-fms-policy-resourcetag-value
         * @external
         */
        readonly value?: string;
    }
}
