"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ListenerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "ListenerProperty", { enumerable: true, get: function () { return slb_generated_1.RosListener; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::Listener`
 */
class Listener extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::Listener`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosListener = new slb_generated_1.RosListener(this, id, {
            requestTimeout: props.requestTimeout,
            vServerGroupId: props.vServerGroupId,
            listenerPort: props.listenerPort,
            description: props.description,
            caCertificateId: props.caCertificateId,
            scheduler: props.scheduler === undefined || props.scheduler === null ? 'wrr' : props.scheduler,
            aclId: props.aclId,
            healthCheck: props.healthCheck,
            idleTimeout: props.idleTimeout,
            loadBalancerId: props.loadBalancerId,
            backendServerPort: props.backendServerPort,
            persistence: props.persistence,
            portRange: props.portRange,
            aclStatus: props.aclStatus === undefined || props.aclStatus === null ? 'off' : props.aclStatus,
            bandwidth: props.bandwidth,
            serverCertificateId: props.serverCertificateId,
            masterSlaveServerGroupId: props.masterSlaveServerGroupId,
            startListener: props.startListener === undefined || props.startListener === null ? true : props.startListener,
            aclType: props.aclType,
            httpConfig: props.httpConfig,
            enableHttp2: props.enableHttp2,
            protocol: props.protocol,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosListener;
        this.attrListenerPortsAndProtocol = rosListener.attrListenerPortsAndProtocol;
        this.attrLoadBalancerId = rosListener.attrLoadBalancerId;
    }
}
exports.Listener = Listener;
//# sourceMappingURL=data:application/json;base64,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