"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const slb_generated_1 = require("./slb.generated");
Object.defineProperty(exports, "LoadBalancerProperty", { enumerable: true, get: function () { return slb_generated_1.RosLoadBalancer; } });
/**
 * A ROS resource type:  `ALIYUN::SLB::LoadBalancer`
 */
class LoadBalancer extends ros.Resource {
    /**
     * Create a new `ALIYUN::SLB::LoadBalancer`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosLoadBalancer = new slb_generated_1.RosLoadBalancer(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            resourceGroupId: props.resourceGroupId,
            instanceChargeType: props.instanceChargeType,
            pricingCycle: props.pricingCycle === undefined || props.pricingCycle === null ? 'month' : props.pricingCycle,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            addressIpVersion: props.addressIpVersion,
            duration: props.duration === undefined || props.duration === null ? 1 : props.duration,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            deletionProtection: props.deletionProtection === undefined || props.deletionProtection === null ? false : props.deletionProtection,
            payType: props.payType,
            slaveZoneId: props.slaveZoneId,
            modificationProtectionStatus: props.modificationProtectionStatus,
            internetChargeType: props.internetChargeType === undefined || props.internetChargeType === null ? 'paybytraffic' : props.internetChargeType,
            loadBalancerSpec: props.loadBalancerSpec,
            loadBalancerName: props.loadBalancerName,
            vpcId: props.vpcId,
            bandwidth: props.bandwidth === undefined || props.bandwidth === null ? 1 : props.bandwidth,
            modificationProtectionReason: props.modificationProtectionReason,
            addressType: props.addressType === undefined || props.addressType === null ? 'internet' : props.addressType,
            tags: props.tags,
            masterZoneId: props.masterZoneId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosLoadBalancer;
        this.attrAddressIpVersion = rosLoadBalancer.attrAddressIpVersion;
        this.attrAddressType = rosLoadBalancer.attrAddressType;
        this.attrBandwidth = rosLoadBalancer.attrBandwidth;
        this.attrIpAddress = rosLoadBalancer.attrIpAddress;
        this.attrLoadBalancerId = rosLoadBalancer.attrLoadBalancerId;
        this.attrLoadBalancerName = rosLoadBalancer.attrLoadBalancerName;
        this.attrLoadBalancerSpec = rosLoadBalancer.attrLoadBalancerSpec;
        this.attrMasterZoneId = rosLoadBalancer.attrMasterZoneId;
        this.attrNetworkType = rosLoadBalancer.attrNetworkType;
        this.attrOrderId = rosLoadBalancer.attrOrderId;
        this.attrPayType = rosLoadBalancer.attrPayType;
        this.attrResourceGroupId = rosLoadBalancer.attrResourceGroupId;
        this.attrSlaveZoneId = rosLoadBalancer.attrSlaveZoneId;
        this.attrVSwitchId = rosLoadBalancer.attrVSwitchId;
        this.attrVpcId = rosLoadBalancer.attrVpcId;
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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