[Developing the Glean SDK](README.md)

- [Testing](testing.md)
- [Continuous Integration](ci.md)
- [Release process](cut-a-new-release.md)
- [Contributing](contributing.md)
    - [Code coverage](code_coverage.md)
- [Developing documentation](docs.md)
- [Upgrading glean_parser](upgrading-glean-parser.md)
- [Android bindings](android/index.md)
    - [Setup Build Environment](android/setup-android-build-environment.md)
    - [Android SDK/NDK versions](android/sdk-ndk-versions.md)
    - [Development with android-components](android/development-with-android-components.md)
    - [Locally-published components in Fenix](android/locally-published-components-in-fenix.md)
- [iOS bindings](ios/index.md)
    - [Setup Build Environment](ios/setup-ios-build-environment.md)
    - [Debugging Different Versions of Glean](ios/debug-glean-on-ios.md)
- [Python bindings](python/index.md)
    - [Setup Build Environment](python/setting-up-python-build-environment.md)
- [Rust Component](core/index.md)
    - [Documentation guidelines](core/documentation-guidelines.md)
    - [Dependency Management](core/dependency-management.md)
    - [Adding a new metric type](core/new-metric-type.md)
        - [FFI](core/new-metric-type/ffi.md)
        - [Kotlin](core/new-metric-type/kotlin.md)
        - [Swift](core/new-metric-type/swift.md)
        - [Python](core/new-metric-type/python.md)
        - [Rust](core/new-metric-type/rust.md)
        - [Platform](core/new-metric-type/platform.md)
- [FFI Layer](ffi/index.md)
    - [When/How FFI](ffi/when-to-use-what-in-the-ffi.md)
- [Internal implementation details](core/internal/index.md)
    - [Reserved ping names](core/internal/reserved-ping-names.md).
    - [Clearing metrics when disabling/enabling Glean](core/internal/clearing.md).
    - [Database format](core/internal/database.md)
    - [Payload format](core/internal/payload.md).
    - [Directory & file structure](core/internal/directory-structure.md)
    - [Debug Pings](core/internal/debug-pings.md)
    - [Upload mechanism](core/internal/upload.md)
    - [Implementations](core/internal/implementations.md)
- [API Documentation](api/index.md)
