# coding: utf-8

"""
    ORY Keto

    Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.  # noqa: E501

    The version of the OpenAPI document: Latest
    Contact: hi@ory.sh
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ory_keto_client.api_client import ApiClient
from ory_keto_client.exceptions import (
    ApiTypeError,
    ApiValueError
)


class EnginesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_ory_access_control_policy_role_members(self, flavor, id, **kwargs):  # noqa: E501
        """Add a member to an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ory_access_control_policy_role_members(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param AddOryAccessControlPolicyRoleMembersBody body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OryAccessControlPolicyRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_ory_access_control_policy_role_members_with_http_info(flavor, id, **kwargs)  # noqa: E501

    def add_ory_access_control_policy_role_members_with_http_info(self, flavor, id, **kwargs):  # noqa: E501
        """Add a member to an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_ory_access_control_policy_role_members_with_http_info(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param AddOryAccessControlPolicyRoleMembersBody body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OryAccessControlPolicyRole, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_ory_access_control_policy_role_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `add_ory_access_control_policy_role_members`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `add_ory_access_control_policy_role_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles/{id}/members', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OryAccessControlPolicyRole',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ory_access_control_policy(self, flavor, id, **kwargs):  # noqa: E501
        """delete_ory_access_control_policy  # noqa: E501

        Delete an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ory_access_control_policy(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ory_access_control_policy_with_http_info(flavor, id, **kwargs)  # noqa: E501

    def delete_ory_access_control_policy_with_http_info(self, flavor, id, **kwargs):  # noqa: E501
        """delete_ory_access_control_policy  # noqa: E501

        Delete an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ory_access_control_policy_with_http_info(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ory_access_control_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `delete_ory_access_control_policy`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_ory_access_control_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/policies/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_ory_access_control_policy_role(self, flavor, id, **kwargs):  # noqa: E501
        """Delete an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ory_access_control_policy_role(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_ory_access_control_policy_role_with_http_info(flavor, id, **kwargs)  # noqa: E501

    def delete_ory_access_control_policy_role_with_http_info(self, flavor, id, **kwargs):  # noqa: E501
        """Delete an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_ory_access_control_policy_role_with_http_info(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_ory_access_control_policy_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `delete_ory_access_control_policy_role`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_ory_access_control_policy_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def do_ory_access_control_policies_allow(self, flavor, **kwargs):  # noqa: E501
        """Check if a request is allowed  # noqa: E501

        Use this endpoint to check if a request is allowed or not. If the request is allowed, a 200 response with `{\"allowed\":\"true\"}` will be sent. If the request is denied, a 403 response with `{\"allowed\":\"false\"}` will be sent instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_ory_access_control_policies_allow(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicyAllowedInput body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AuthorizationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.do_ory_access_control_policies_allow_with_http_info(flavor, **kwargs)  # noqa: E501

    def do_ory_access_control_policies_allow_with_http_info(self, flavor, **kwargs):  # noqa: E501
        """Check if a request is allowed  # noqa: E501

        Use this endpoint to check if a request is allowed or not. If the request is allowed, a 200 response with `{\"allowed\":\"true\"}` will be sent. If the request is denied, a 403 response with `{\"allowed\":\"false\"}` will be sent instead.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_ory_access_control_policies_allow_with_http_info(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicyAllowedInput body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AuthorizationResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_ory_access_control_policies_allow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `do_ory_access_control_policies_allow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/allowed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthorizationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ory_access_control_policy(self, flavor, id, **kwargs):  # noqa: E501
        """get_ory_access_control_policy  # noqa: E501

        Get an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ory_access_control_policy(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OryAccessControlPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ory_access_control_policy_with_http_info(flavor, id, **kwargs)  # noqa: E501

    def get_ory_access_control_policy_with_http_info(self, flavor, id, **kwargs):  # noqa: E501
        """get_ory_access_control_policy  # noqa: E501

        Get an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ory_access_control_policy_with_http_info(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OryAccessControlPolicy, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ory_access_control_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `get_ory_access_control_policy`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_ory_access_control_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/policies/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OryAccessControlPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ory_access_control_policy_role(self, flavor, id, **kwargs):  # noqa: E501
        """Get an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ory_access_control_policy_role(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OryAccessControlPolicyRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_ory_access_control_policy_role_with_http_info(flavor, id, **kwargs)  # noqa: E501

    def get_ory_access_control_policy_role_with_http_info(self, flavor, id, **kwargs):  # noqa: E501
        """Get an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ory_access_control_policy_role_with_http_info(flavor, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OryAccessControlPolicyRole, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ory_access_control_policy_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `get_ory_access_control_policy_role`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_ory_access_control_policy_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OryAccessControlPolicyRole',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ory_access_control_policies(self, flavor, **kwargs):  # noqa: E501
        """list_ory_access_control_policies  # noqa: E501

        List ORY Access Control Policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ory_access_control_policies(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\" (required)
        :param int limit: The maximum amount of policies returned.
        :param int offset: The offset from where to start looking.
        :param str subject: The subject for whom the policies are to be listed.
        :param str resource: The resource for which the policies are to be listed.
        :param str action: The action for which policies are to be listed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OryAccessControlPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_ory_access_control_policies_with_http_info(flavor, **kwargs)  # noqa: E501

    def list_ory_access_control_policies_with_http_info(self, flavor, **kwargs):  # noqa: E501
        """list_ory_access_control_policies  # noqa: E501

        List ORY Access Control Policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ory_access_control_policies_with_http_info(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\" (required)
        :param int limit: The maximum amount of policies returned.
        :param int offset: The offset from where to start looking.
        :param str subject: The subject for whom the policies are to be listed.
        :param str resource: The resource for which the policies are to be listed.
        :param str action: The action for which policies are to be listed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OryAccessControlPolicy], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'limit', 'offset', 'subject', 'resource', 'action']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ory_access_control_policies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `list_ory_access_control_policies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'subject' in local_var_params and local_var_params['subject'] is not None:  # noqa: E501
            query_params.append(('subject', local_var_params['subject']))  # noqa: E501
        if 'resource' in local_var_params and local_var_params['resource'] is not None:  # noqa: E501
            query_params.append(('resource', local_var_params['resource']))  # noqa: E501
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OryAccessControlPolicy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_ory_access_control_policy_roles(self, flavor, **kwargs):  # noqa: E501
        """List ORY Access Control Policy Roles  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ory_access_control_policy_roles(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\" (required)
        :param int limit: The maximum amount of policies returned.
        :param int offset: The offset from where to start looking.
        :param str member: The member for which the roles are to be listed.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[OryAccessControlPolicyRole]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_ory_access_control_policy_roles_with_http_info(flavor, **kwargs)  # noqa: E501

    def list_ory_access_control_policy_roles_with_http_info(self, flavor, **kwargs):  # noqa: E501
        """List ORY Access Control Policy Roles  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_ory_access_control_policy_roles_with_http_info(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\" (required)
        :param int limit: The maximum amount of policies returned.
        :param int offset: The offset from where to start looking.
        :param str member: The member for which the roles are to be listed.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[OryAccessControlPolicyRole], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'limit', 'offset', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ory_access_control_policy_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `list_ory_access_control_policy_roles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'member' in local_var_params and local_var_params['member'] is not None:  # noqa: E501
            query_params.append(('member', local_var_params['member']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OryAccessControlPolicyRole]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_ory_access_control_policy_role_members(self, flavor, id, member, **kwargs):  # noqa: E501
        """Remove a member from an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_ory_access_control_policy_role_members(flavor, id, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param str member: The member to be removed. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_ory_access_control_policy_role_members_with_http_info(flavor, id, member, **kwargs)  # noqa: E501

    def remove_ory_access_control_policy_role_members_with_http_info(self, flavor, id, member, **kwargs):  # noqa: E501
        """Remove a member from an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_ory_access_control_policy_role_members_with_http_info(flavor, id, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param str id: The ID of the ORY Access Control Policy Role. (required)
        :param str member: The member to be removed. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'id', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_ory_access_control_policy_role_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `remove_ory_access_control_policy_role_members`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `remove_ory_access_control_policy_role_members`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in local_var_params or  # noqa: E501
                                                        local_var_params['member'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `member` when calling `remove_ory_access_control_policy_role_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501
        if 'member' in local_var_params:
            path_params['member'] = local_var_params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles/{id}/members/{member}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_ory_access_control_policy(self, flavor, **kwargs):  # noqa: E501
        """upsert_ory_access_control_policy  # noqa: E501

        Upsert an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_ory_access_control_policy(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicy body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OryAccessControlPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_ory_access_control_policy_with_http_info(flavor, **kwargs)  # noqa: E501

    def upsert_ory_access_control_policy_with_http_info(self, flavor, **kwargs):  # noqa: E501
        """upsert_ory_access_control_policy  # noqa: E501

        Upsert an ORY Access Control Policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_ory_access_control_policy_with_http_info(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicy body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OryAccessControlPolicy, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_ory_access_control_policy" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `upsert_ory_access_control_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/policies', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OryAccessControlPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsert_ory_access_control_policy_role(self, flavor, **kwargs):  # noqa: E501
        """Upsert an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_ory_access_control_policy_role(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicyRole body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OryAccessControlPolicyRole
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_ory_access_control_policy_role_with_http_info(flavor, **kwargs)  # noqa: E501

    def upsert_ory_access_control_policy_role_with_http_info(self, flavor, **kwargs):  # noqa: E501
        """Upsert an ORY Access Control Policy Role  # noqa: E501

        Roles group several subjects into one. Rules can be assigned to ORY Access Control Policy (OACP) by using the Role ID as subject in the OACP.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsert_ory_access_control_policy_role_with_http_info(flavor, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str flavor: The ORY Access Control Policy flavor. Can be \"regex\", \"glob\", and \"exact\". (required)
        :param OryAccessControlPolicyRole body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OryAccessControlPolicyRole, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['flavor', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_ory_access_control_policy_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'flavor' is set
        if self.api_client.client_side_validation and ('flavor' not in local_var_params or  # noqa: E501
                                                        local_var_params['flavor'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `flavor` when calling `upsert_ory_access_control_policy_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'flavor' in local_var_params:
            path_params['flavor'] = local_var_params['flavor']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/engines/acp/ory/{flavor}/roles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OryAccessControlPolicyRole',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
