# mypy-boto3-workmail

[![PyPI - mypy-boto3-workmail](https://img.shields.io/pypi/v/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.WorkMail 1.14.1](https://boto3.amazonaws.com/v1/documentation/api/1.14.1/reference/services/workmail.html#WorkMail) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkMail` service.

```bash
python -m pip install boto3-stubs[workmail]
```

## How to use

### Client annotations

`WorkMailClient` provides annotations for `boto3.client("workmail")`.

```python
import boto3

from mypy_boto3_workmail import WorkMailClient
from mypy_boto3_workmail.paginator import (
    ListAliasesPaginator,
    ListGroupMembersPaginator,
    ListGroupsPaginator,
    ListMailboxPermissionsPaginator,
    ListOrganizationsPaginator,
    ListResourceDelegatesPaginator,
    ListResourcesPaginator,
    ListUsersPaginator,
)
from mypy_boto3_workmail.type_defs import AccessControlRuleTypeDef, ...

client: WorkMailClient = boto3.client("workmail")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkMailClient = session.client("workmail")
```

### Paginators annotations

`mypy_boto3_workmail.paginator` module contains type annotations for all paginators.

```python

client: WorkMailClient = boto3.client("workmail")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_group_members_paginator: ListGroupMembersPaginator = client.get_paginator("list_group_members")
list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
list_mailbox_permissions_paginator: ListMailboxPermissionsPaginator = client.get_paginator("list_mailbox_permissions")
list_organizations_paginator: ListOrganizationsPaginator = client.get_paginator("list_organizations")
list_resource_delegates_paginator: ListResourceDelegatesPaginator = client.get_paginator("list_resource_delegates")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
```







### Typed dictionations

`mypy_boto3_workmail.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccessControlRuleTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_workmail` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("workmail")

session_client = boto3.Session().client("workmail")
```
