#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-rac-config.json
#
# Do not edit this file manually!
#

from delphixpy.v1_10_1.web.objects.OracleDBConfig import OracleDBConfig
from delphixpy.v1_10_1 import factory
from delphixpy.v1_10_1 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class OracleRACConfig(OracleDBConfig):
    """
    *(extends* :py:class:`v1_10_1.web.vo.OracleDBConfig` *)* Representation of
    the properties specific to a RAC Oracle DB configuration.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("OracleRACConfig", True)
        self._instances = (self.__undef__, True)
        self._crs_database_name = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._instances = []
        for item in data.get("instances") or []:
            obj._instances.append(factory.create_object(item))
            factory.validate_type(obj._instances[-1], "OracleRACInstance")
        obj._instances = (obj._instances, dirty)
        obj._crs_database_name = (data.get("crsDatabaseName", obj.__undef__), dirty)
        if obj._crs_database_name[0] is not None and obj._crs_database_name[0] is not obj.__undef__:
            assert isinstance(obj._crs_database_name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._crs_database_name[0], type(obj._crs_database_name[0])))
            common.validate_format(obj._crs_database_name[0], "None", None, 30)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "instances" == "type" or (self.instances is not self.__undef__ and (not (dirty and not self._instances[1]) or isinstance(self.instances, list) or belongs_to_parent)):
            dct["instances"] = dictify(self.instances, prop_is_list_or_vo=True)
        if "crs_database_name" == "type" or (self.crs_database_name is not self.__undef__ and (not (dirty and not self._crs_database_name[1]) or isinstance(self.crs_database_name, list) or belongs_to_parent)):
            dct["crsDatabaseName"] = dictify(self.crs_database_name)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._instances = (self._instances[0], True)
        self._crs_database_name = (self._crs_database_name[0], True)

    def is_dirty(self):
        return any([self._instances[1], self._crs_database_name[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleRACConfig):
            return False
        return super().__eq__(other) and \
               self.instances == other.instances and \
               self.crs_database_name == other.crs_database_name

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def instances(self):
        """
        The list of RAC instances for this RAC configuration.

        :rtype: ``list`` of :py:class:`v1_10_1.web.vo.OracleRACInstance`
        """
        return self._instances[0]

    @instances.setter
    def instances(self, value):
        self._instances = (value, True)

    @property
    def crs_database_name(self):
        """
        The Oracle Clusterware database name.

        :rtype: ``str``
        """
        return self._crs_database_name[0]

    @crs_database_name.setter
    def crs_database_name(self, value):
        self._crs_database_name = (value, True)

