#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-fluentd-attribute-definition.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_14.web.objects.TypedObject import TypedObject
from delphixpy.v1_11_14 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class FluentdAttributeDefinition(TypedObject):
    """
    *(extends* :py:class:`v1_11_14.web.vo.TypedObject` *)* Fluentd attribute
    definition.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("FluentdAttributeDefinition", True)
        self._name = (self.__undef__, True)
        self._secret = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._name = (data.get("name", obj.__undef__), dirty)
        if obj._name[0] is not None and obj._name[0] is not obj.__undef__:
            assert isinstance(obj._name[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._name[0], type(obj._name[0])))
            common.validate_format(obj._name[0], "None", None, None)
        obj._secret = (data.get("secret", obj.__undef__), dirty)
        if obj._secret[0] is not None and obj._secret[0] is not obj.__undef__:
            assert isinstance(obj._secret[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._secret[0], type(obj._secret[0])))
            common.validate_format(obj._secret[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "name" == "type" or (self.name is not self.__undef__ and (not (dirty and not self._name[1]) or isinstance(self.name, list) or belongs_to_parent)):
            dct["name"] = dictify(self.name)
        if "secret" == "type" or (self.secret is not self.__undef__ and (not (dirty and not self._secret[1]) or isinstance(self.secret, list) or belongs_to_parent)):
            dct["secret"] = dictify(self.secret)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._name = (self._name[0], True)
        self._secret = (self._secret[0], True)

    def is_dirty(self):
        return any([self._name[1], self._secret[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, FluentdAttributeDefinition):
            return False
        return super().__eq__(other) and \
               self.name == other.name and \
               self.secret == other.secret

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def name(self):
        """
        Fluentd attribute name.

        :rtype: ``str``
        """
        return self._name[0]

    @name.setter
    def name(self, value):
        self._name = (value, True)

    @property
    def secret(self):
        """
        Whether to protect attribute as a secret.

        :rtype: ``bool``
        """
        return self._secret[0]

    @secret.setter
    def secret(self, value):
        self._secret = (value, True)

