#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-authorization-config.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_4.web.objects.TypedObject import TypedObject
from delphixpy.v1_11_4 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class AuthorizationConfig(TypedObject):
    """
    *(extends* :py:class:`v1_11_4.web.vo.TypedObject` *)* Configuration of the
    Authorization System.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("AuthorizationConfig", True)
        self._environment_and_host_auth = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._environment_and_host_auth = (data.get("environmentAndHostAuth", obj.__undef__), dirty)
        if obj._environment_and_host_auth[0] is not None and obj._environment_and_host_auth[0] is not obj.__undef__:
            assert isinstance(obj._environment_and_host_auth[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._environment_and_host_auth[0], type(obj._environment_and_host_auth[0])))
            common.validate_format(obj._environment_and_host_auth[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "environment_and_host_auth" == "type" or (self.environment_and_host_auth is not self.__undef__ and (not (dirty and not self._environment_and_host_auth[1]) or isinstance(self.environment_and_host_auth, list) or belongs_to_parent)):
            dct["environmentAndHostAuth"] = dictify(self.environment_and_host_auth)
        elif belongs_to_parent and self.environment_and_host_auth is self.__undef__:
            dct["environmentAndHostAuth"] = False
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._environment_and_host_auth = (self._environment_and_host_auth[0], True)

    def is_dirty(self):
        return any([self._environment_and_host_auth[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AuthorizationConfig):
            return False
        return super().__eq__(other) and \
               self.environment_and_host_auth == other.environment_and_host_auth

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def environment_and_host_auth(self):
        """
        Whether authorization checks are enabled for all environment and host
        operations.

        :rtype: ``bool``
        """
        return self._environment_and_host_auth[0]

    @environment_and_host_auth.setter
    def environment_and_host_auth(self, value):
        self._environment_and_host_auth = (value, True)

