#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-linked-source.json
#
# Do not edit this file manually!
#

from delphixpy.v1_11_8.web.objects.MSSqlSource import MSSqlSource
from delphixpy.v1_11_8 import factory
from delphixpy.v1_11_8 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class MSSqlLinkedSource(MSSqlSource):
    """
    *(extends* :py:class:`v1_11_8.web.vo.MSSqlSource` *)* A linked MSSQL
    source.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("MSSqlLinkedSource", True)
        self._config = (self.__undef__, True)
        self._operations = (self.__undef__, True)
        self._shared_backup_locations = (self.__undef__, True)
        self._staging_source = (self.__undef__, True)
        self._encryption_key = (self.__undef__, True)
        self._ingestion_strategy = (self.__undef__, True)
        self._mssql_netbackup_config = (self.__undef__, True)
        self._mssql_commvault_config = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._config = (data.get("config", obj.__undef__), dirty)
        if obj._config[0] is not None and obj._config[0] is not obj.__undef__:
            assert isinstance(obj._config[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._config[0], type(obj._config[0])))
            common.validate_format(obj._config[0], "objectReference", None, None)
        if "operations" in data and data["operations"] is not None:
            obj._operations = (factory.create_object(data["operations"], "LinkedSourceOperations"), dirty)
            factory.validate_type(obj._operations[0], "LinkedSourceOperations")
        else:
            obj._operations = (obj.__undef__, dirty)
        obj._shared_backup_locations = []
        for item in data.get("sharedBackupLocations") or []:
            assert isinstance(item, str), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, 260)
            obj._shared_backup_locations.append(item)
        obj._shared_backup_locations = (obj._shared_backup_locations, dirty)
        obj._staging_source = (data.get("stagingSource", obj.__undef__), dirty)
        if obj._staging_source[0] is not None and obj._staging_source[0] is not obj.__undef__:
            assert isinstance(obj._staging_source[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._staging_source[0], type(obj._staging_source[0])))
            common.validate_format(obj._staging_source[0], "objectReference", None, None)
        obj._encryption_key = (data.get("encryptionKey", obj.__undef__), dirty)
        if obj._encryption_key[0] is not None and obj._encryption_key[0] is not obj.__undef__:
            assert isinstance(obj._encryption_key[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._encryption_key[0], type(obj._encryption_key[0])))
            common.validate_format(obj._encryption_key[0], "password", None, None)
        if "ingestionStrategy" in data and data["ingestionStrategy"] is not None:
            obj._ingestion_strategy = (factory.create_object(data["ingestionStrategy"], "IngestionStrategy"), dirty)
            factory.validate_type(obj._ingestion_strategy[0], "IngestionStrategy")
        else:
            obj._ingestion_strategy = (obj.__undef__, dirty)
        if "mssqlNetbackupConfig" in data and data["mssqlNetbackupConfig"] is not None:
            obj._mssql_netbackup_config = (factory.create_object(data["mssqlNetbackupConfig"], "MSSqlNetbackupConfig"), dirty)
            factory.validate_type(obj._mssql_netbackup_config[0], "MSSqlNetbackupConfig")
        else:
            obj._mssql_netbackup_config = (obj.__undef__, dirty)
        if "mssqlCommvaultConfig" in data and data["mssqlCommvaultConfig"] is not None:
            obj._mssql_commvault_config = (factory.create_object(data["mssqlCommvaultConfig"], "MSSqlCommvaultConfig"), dirty)
            factory.validate_type(obj._mssql_commvault_config[0], "MSSqlCommvaultConfig")
        else:
            obj._mssql_commvault_config = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "config" == "type" or (self.config is not self.__undef__ and (not (dirty and not self._config[1]) or isinstance(self.config, list) or belongs_to_parent)):
            dct["config"] = dictify(self.config)
        if "operations" == "type" or (self.operations is not self.__undef__ and (not (dirty and not self._operations[1]) or isinstance(self.operations, list) or belongs_to_parent)):
            dct["operations"] = dictify(self.operations, prop_is_list_or_vo=True)
        if "shared_backup_locations" == "type" or (self.shared_backup_locations is not self.__undef__ and (not (dirty and not self._shared_backup_locations[1]) or isinstance(self.shared_backup_locations, list) or belongs_to_parent)):
            dct["sharedBackupLocations"] = dictify(self.shared_backup_locations, prop_is_list_or_vo=True)
        if "staging_source" == "type" or (self.staging_source is not self.__undef__ and (not (dirty and not self._staging_source[1]))):
            dct["stagingSource"] = dictify(self.staging_source)
        if "encryption_key" == "type" or (self.encryption_key is not self.__undef__ and (not (dirty and not self._encryption_key[1]) or isinstance(self.encryption_key, list) or belongs_to_parent)):
            dct["encryptionKey"] = dictify(self.encryption_key)
        if "ingestion_strategy" == "type" or (self.ingestion_strategy is not self.__undef__ and (not (dirty and not self._ingestion_strategy[1]) or isinstance(self.ingestion_strategy, list) or belongs_to_parent)):
            dct["ingestionStrategy"] = dictify(self.ingestion_strategy, prop_is_list_or_vo=True)
        if "mssql_netbackup_config" == "type" or (self.mssql_netbackup_config is not self.__undef__ and (not (dirty and not self._mssql_netbackup_config[1]) or isinstance(self.mssql_netbackup_config, list) or belongs_to_parent)):
            dct["mssqlNetbackupConfig"] = dictify(self.mssql_netbackup_config)
        if "mssql_commvault_config" == "type" or (self.mssql_commvault_config is not self.__undef__ and (not (dirty and not self._mssql_commvault_config[1]) or isinstance(self.mssql_commvault_config, list) or belongs_to_parent)):
            dct["mssqlCommvaultConfig"] = dictify(self.mssql_commvault_config)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._config = (self._config[0], True)
        self._operations = (self._operations[0], True)
        self._shared_backup_locations = (self._shared_backup_locations[0], True)
        self._staging_source = (self._staging_source[0], True)
        self._encryption_key = (self._encryption_key[0], True)
        self._ingestion_strategy = (self._ingestion_strategy[0], True)
        self._mssql_netbackup_config = (self._mssql_netbackup_config[0], True)
        self._mssql_commvault_config = (self._mssql_commvault_config[0], True)

    def is_dirty(self):
        return any([self._config[1], self._operations[1], self._shared_backup_locations[1], self._staging_source[1], self._encryption_key[1], self._ingestion_strategy[1], self._mssql_netbackup_config[1], self._mssql_commvault_config[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlLinkedSource):
            return False
        return super().__eq__(other) and \
               self.config == other.config and \
               self.operations == other.operations and \
               self.shared_backup_locations == other.shared_backup_locations and \
               self.staging_source == other.staging_source and \
               self.encryption_key == other.encryption_key and \
               self.ingestion_strategy == other.ingestion_strategy and \
               self.mssql_netbackup_config == other.mssql_netbackup_config and \
               self.mssql_commvault_config == other.mssql_commvault_config

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def config(self):
        """
        Reference to the configuration for the source.

        :rtype: ``str``
        """
        return self._config[0]

    @config.setter
    def config(self, value):
        self._config = (value, True)

    @property
    def operations(self):
        """
        User-specified operation hooks for this source.

        :rtype: :py:class:`v1_11_8.web.vo.LinkedSourceOperations`
        """
        return self._operations[0]

    @operations.setter
    def operations(self, value):
        self._operations = (value, True)

    @property
    def shared_backup_locations(self):
        """
        Shared source database backup locations.

        :rtype: ``list`` of ``str``
        """
        return self._shared_backup_locations[0]

    @shared_backup_locations.setter
    def shared_backup_locations(self, value):
        self._shared_backup_locations = (value, True)

    @property
    def staging_source(self):
        """
        The staging source for pre-provisioning of the database.

        :rtype: ``str``
        """
        return self._staging_source[0]

    @staging_source.setter
    def staging_source(self, value):
        self._staging_source = (value, True)

    @property
    def encryption_key(self):
        """
        The encryption key to use when restoring encrypted backups.

        :rtype: ``str``
        """
        return self._encryption_key[0]

    @encryption_key.setter
    def encryption_key(self, value):
        self._encryption_key = (value, True)

    @property
    def ingestion_strategy(self):
        """
        Configuration that determines what ingestion strategy the source will
        use.

        :rtype: :py:class:`v1_11_8.web.vo.IngestionStrategy`
        """
        return self._ingestion_strategy[0]

    @ingestion_strategy.setter
    def ingestion_strategy(self, value):
        self._ingestion_strategy = (value, True)

    @property
    def mssql_netbackup_config(self):
        """
        Configuration for source that allows ingesting NetBackup backups for
        SQL Server.

        :rtype: :py:class:`v1_11_8.web.vo.MSSqlNetbackupConfig`
        """
        return self._mssql_netbackup_config[0]

    @mssql_netbackup_config.setter
    def mssql_netbackup_config(self, value):
        self._mssql_netbackup_config = (value, True)

    @property
    def mssql_commvault_config(self):
        """
        Configuration for source that allows ingesting Commvault backups for
        SQL Server.

        :rtype: :py:class:`v1_11_8.web.vo.MSSqlCommvaultConfig`
        """
        return self._mssql_commvault_config[0]

    @mssql_commvault_config.setter
    def mssql_commvault_config(self, value):
        self._mssql_commvault_config = (value, True)

