#
# Copyright 2023 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-network-throughput-test.json
#
# Do not edit this file manually!
#

from delphixpy.v1_4_0.web.objects.UserObject import UserObject
from delphixpy.v1_4_0 import common

class __Undef:
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

class NetworkThroughputTest(UserObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.UserObject` *)* Bi-directional
    throughput tests to a target system.
    """
    def __init__(self, undef_enabled=True):
        super().__init__()
        self._type = ("NetworkThroughputTest", True)
        self._direction = (self.__undef__, True)
        self._duration = (self.__undef__, True)
        self._end_time = (self.__undef__, True)
        self._num_connections = (self.__undef__, True)
        self._remote_address = (self.__undef__, True)
        self._remote_host = (self.__undef__, True)
        self._start_time = (self.__undef__, True)
        self._state = (self.__undef__, True)
        self._throughput = (self.__undef__, True)


    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super().from_dict(data, dirty, undef_enabled)
        obj._direction = (data.get("direction", obj.__undef__), dirty)
        if obj._direction[0] is not None and obj._direction[0] is not obj.__undef__:
            assert isinstance(obj._direction[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._direction[0], type(obj._direction[0])))
            assert obj._direction[0] in ['TRANSMIT', 'RECEIVE'], "Expected enum ['TRANSMIT', 'RECEIVE'] but got %s" % obj._direction[0]
            common.validate_format(obj._direction[0], "None", None, None)
        obj._duration = (data.get("duration", obj.__undef__), dirty)
        if obj._duration[0] is not None and obj._duration[0] is not obj.__undef__:
            assert isinstance(obj._duration[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._duration[0], type(obj._duration[0])))
            common.validate_format(obj._duration[0], "None", None, None)
        obj._end_time = (data.get("endTime", obj.__undef__), dirty)
        if obj._end_time[0] is not None and obj._end_time[0] is not obj.__undef__:
            assert isinstance(obj._end_time[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._end_time[0], type(obj._end_time[0])))
            common.validate_format(obj._end_time[0], "date", None, None)
        obj._num_connections = (data.get("numConnections", obj.__undef__), dirty)
        if obj._num_connections[0] is not None and obj._num_connections[0] is not obj.__undef__:
            assert isinstance(obj._num_connections[0], int), ("Expected one of ['integer'], but got %s of type %s" % (obj._num_connections[0], type(obj._num_connections[0])))
            common.validate_format(obj._num_connections[0], "None", None, None)
        obj._remote_address = (data.get("remoteAddress", obj.__undef__), dirty)
        if obj._remote_address[0] is not None and obj._remote_address[0] is not obj.__undef__:
            assert isinstance(obj._remote_address[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._remote_address[0], type(obj._remote_address[0])))
            common.validate_format(obj._remote_address[0], "ipAddress", None, None)
        obj._remote_host = (data.get("remoteHost", obj.__undef__), dirty)
        if obj._remote_host[0] is not None and obj._remote_host[0] is not obj.__undef__:
            assert isinstance(obj._remote_host[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._remote_host[0], type(obj._remote_host[0])))
            common.validate_format(obj._remote_host[0], "objectReference", None, None)
        obj._start_time = (data.get("startTime", obj.__undef__), dirty)
        if obj._start_time[0] is not None and obj._start_time[0] is not obj.__undef__:
            assert isinstance(obj._start_time[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._start_time[0], type(obj._start_time[0])))
            common.validate_format(obj._start_time[0], "date", None, None)
        obj._state = (data.get("state", obj.__undef__), dirty)
        if obj._state[0] is not None and obj._state[0] is not obj.__undef__:
            assert isinstance(obj._state[0], str), ("Expected one of ['string'], but got %s of type %s" % (obj._state[0], type(obj._state[0])))
            assert obj._state[0] in ['RUNNING', 'COMPLETED', 'FAILED', 'CANCELED'], "Expected enum ['RUNNING', 'COMPLETED', 'FAILED', 'CANCELED'] but got %s" % obj._state[0]
            common.validate_format(obj._state[0], "None", None, None)
        obj._throughput = (data.get("throughput", obj.__undef__), dirty)
        if obj._throughput[0] is not None and obj._throughput[0] is not obj.__undef__:
            assert isinstance(obj._throughput[0], float), ("Expected one of ['number'], but got %s of type %s" % (obj._throughput[0], type(obj._throughput[0])))
            common.validate_format(obj._throughput[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super().to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "direction" == "type" or (self.direction is not self.__undef__ and (not (dirty and not self._direction[1]))):
            dct["direction"] = dictify(self.direction)
        if "duration" == "type" or (self.duration is not self.__undef__ and (not (dirty and not self._duration[1]))):
            dct["duration"] = dictify(self.duration)
        if "end_time" == "type" or (self.end_time is not self.__undef__ and (not (dirty and not self._end_time[1]))):
            dct["endTime"] = dictify(self.end_time)
        if "num_connections" == "type" or (self.num_connections is not self.__undef__ and (not (dirty and not self._num_connections[1]))):
            dct["numConnections"] = dictify(self.num_connections)
        if "remote_address" == "type" or (self.remote_address is not self.__undef__ and (not (dirty and not self._remote_address[1]))):
            dct["remoteAddress"] = dictify(self.remote_address)
        if "remote_host" == "type" or (self.remote_host is not self.__undef__ and (not (dirty and not self._remote_host[1]))):
            dct["remoteHost"] = dictify(self.remote_host)
        if "start_time" == "type" or (self.start_time is not self.__undef__ and (not (dirty and not self._start_time[1]))):
            dct["startTime"] = dictify(self.start_time)
        if "state" == "type" or (self.state is not self.__undef__ and (not (dirty and not self._state[1]))):
            dct["state"] = dictify(self.state)
        if "throughput" == "type" or (self.throughput is not self.__undef__ and (not (dirty and not self._throughput[1]))):
            dct["throughput"] = dictify(self.throughput)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._direction = (self._direction[0], True)
        self._duration = (self._duration[0], True)
        self._end_time = (self._end_time[0], True)
        self._num_connections = (self._num_connections[0], True)
        self._remote_address = (self._remote_address[0], True)
        self._remote_host = (self._remote_host[0], True)
        self._start_time = (self._start_time[0], True)
        self._state = (self._state[0], True)
        self._throughput = (self._throughput[0], True)

    def is_dirty(self):
        return any([self._direction[1], self._duration[1], self._end_time[1], self._num_connections[1], self._remote_address[1], self._remote_host[1], self._start_time[1], self._state[1], self._throughput[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, NetworkThroughputTest):
            return False
        return super().__eq__(other) and \
               self.direction == other.direction and \
               self.duration == other.duration and \
               self.end_time == other.end_time and \
               self.num_connections == other.num_connections and \
               self.remote_address == other.remote_address and \
               self.remote_host == other.remote_host and \
               self.start_time == other.start_time and \
               self.state == other.state and \
               self.throughput == other.throughput

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def direction(self):
        """
        The direction of the throughput test (transmit or receive). *(permitted
        values: TRANSMIT, RECEIVE)*

        :rtype: ``str``
        """
        return self._direction[0]

    @direction.setter
    def direction(self, value):
        self._direction = (value, True)

    @property
    def duration(self):
        """
        The duration of the test in seconds.

        :rtype: ``int``
        """
        return self._duration[0]

    @duration.setter
    def duration(self, value):
        self._duration = (value, True)

    @property
    def end_time(self):
        """
        Time when the test ended.

        :rtype: ``str``
        """
        return self._end_time[0]

    @end_time.setter
    def end_time(self, value):
        self._end_time = (value, True)

    @property
    def num_connections(self):
        """
        Number of connections used to achieve maximum sustained throughput.

        :rtype: ``int``
        """
        return self._num_connections[0]

    @num_connections.setter
    def num_connections(self, value):
        self._num_connections = (value, True)

    @property
    def remote_address(self):
        """
        The IP address of the remote host used for the throughput test.

        :rtype: ``str``
        """
        return self._remote_address[0]

    @remote_address.setter
    def remote_address(self, value):
        self._remote_address = (value, True)

    @property
    def remote_host(self):
        """
        The remote environment host used for the throughput test.

        :rtype: ``str``
        """
        return self._remote_host[0]

    @remote_host.setter
    def remote_host(self, value):
        self._remote_host = (value, True)

    @property
    def start_time(self):
        """
        Time when the test was started.

        :rtype: ``str``
        """
        return self._start_time[0]

    @start_time.setter
    def start_time(self, value):
        self._start_time = (value, True)

    @property
    def state(self):
        """
        The state of the test. *(permitted values: RUNNING, COMPLETED, FAILED,
        CANCELED)*

        :rtype: ``str``
        """
        return self._state[0]

    @state.setter
    def state(self, value):
        self._state = (value, True)

    @property
    def throughput(self):
        """
        Maximum sustained throughput measured (bits/s)

        :rtype: ``float``
        """
        return self._throughput[0]

    @throughput.setter
    def throughput(self, value):
        self._throughput = (value, True)

